/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.BioType;
import edu.nyu.jet.ne.NamedEntityAttribute;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClassAnnotator {
    private Map<String, Collection<NamedEntityAttribute>> dictionary;

    public ClassAnnotator(Reader in) throws IOException {
        String line;
        BufferedReader reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        IdentityHashMap<String, NamedEntityAttribute> classNames = new IdentityHashMap<String, NamedEntityAttribute>();
        this.dictionary = new HashMap<String, Collection<NamedEntityAttribute>>();
        while ((line = reader.readLine()) != null) {
            String[] tmp = line.split("\t");
            String word = tmp[0];
            ArrayList<Object> classes = new ArrayList<Object>(tmp.length - 1);
            for (int i = 1; i < tmp.length; ++i) {
                String className = tmp[i].intern();
                if (classNames.containsKey(className)) {
                    classes.add(classNames.get(className));
                    continue;
                }
                NamedEntityAttribute cls = new NamedEntityAttribute(className, BioType.N);
                classes.add(cls);
                classNames.put(className, cls);
            }
            this.dictionary.put(word, classes);
        }
    }

    public ClassAnnotator(File file) throws IOException {
        this(new FileReader(file));
    }

    public void annotate(Document doc, Span span) {
        Vector<Annotation> neTokens = doc.annotationsOfType("NE_INTERNAL", span);
        for (Annotation neToken : neTokens) {
            String token = doc.normalizedText(neToken);
            Collection<NamedEntityAttribute> entries = this.dictionary.get(token);
            if (entries == null) continue;
            Set categories = (Set)neToken.get("categories");
            categories.addAll(entries);
        }
    }
}

