/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.ClassHierarchyResolver;
import edu.nyu.jet.ne.MatchType;
import edu.nyu.jet.ne.NamedEntityAttribute;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassRule {
    private static Pattern hourMinutePattern = Pattern.compile("(\\d{1,2}):(\\d{2})");
    private static final int YEAR_MIN = 1000;
    private static final int YEAR_MAX = 2030;
    private MatchType type;
    private String[] categories;

    public ClassRule(MatchType type, String[] categories) {
        this.type = type;
        this.categories = categories;
    }

    public boolean accept(Document doc, Annotation[] tokens, int n, ClassHierarchyResolver resolver) {
        if (this.type == MatchType.ANY) {
            return true;
        }
        if (this.type == MatchType.SPECIAL) {
            if (this.categories.length != 1) {
                throw new UnsupportedOperationException();
            }
            try {
                SpecialType specialType = SpecialType.valueOf(this.categories[0]);
                return specialType.accept(doc, tokens, n, resolver);
            }
            catch (IllegalArgumentException ex) {
                String message = this.categories[0] + " is not supported.";
                throw new UnsupportedOperationException(message);
            }
        }
        boolean matched = false;
        Set neList = (Set)tokens[n].get("categories");
        block6: for (NamedEntityAttribute ne : neList) {
            for (String category : this.categories) {
                if (!resolver.isSubClassOf(ne.getCategory(), category)) continue;
                matched = true;
                break block6;
            }
        }
        switch (this.type) {
            case NORMAL: {
                return matched;
            }
            case NOT: {
                return !matched;
            }
        }
        throw new InternalError();
    }

    static boolean isCapital(Document doc, Annotation[] tokens, int n) {
        String text = doc.text(tokens[n]).trim();
        if (text.length() == 0 || !Character.isUpperCase(text.charAt(0))) {
            return false;
        }
        String pos = (String)tokens[n].get("pos");
        if (pos != null && (pos.equals("NNP") || pos.equals("NNPS"))) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        String before = doc.text(tokens[n - 1]).trim();
        return !before.equals("\"") && !before.equals("``") && !before.equals("`");
    }

    static boolean isYear(String text) {
        if (text.length() != 4) {
            return false;
        }
        try {
            int n = Integer.parseInt(text);
            if (n < 1000 || n > 2030) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    static boolean isTwoDigitYear(String text) {
        if (text.length() != 2) {
            return false;
        }
        return Character.isDigit(text.charAt(0)) && Character.isDigit(text.charAt(1));
    }

    static boolean isHourMinute(String text) {
        Matcher matcher = hourMinutePattern.matcher(text);
        if (!matcher.matches()) {
            return false;
        }
        int hour = Integer.parseInt(matcher.group(1));
        int minute = Integer.parseInt(matcher.group(2));
        if (hour < 0 || hour > 24) {
            return false;
        }
        return minute >= 0 && minute <= 60;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpecialType {
        CAPITAL{

            public boolean accept(Document doc, Annotation[] tokens, int pos, ClassHierarchyResolver resolver) {
                return ClassRule.isCapital(doc, tokens, pos);
            }
        }
        ,
        DCAPITAL{

            public boolean accept(Document doc, Annotation[] tokens, int pos, ClassHierarchyResolver resolver) {
                return !ClassRule.isCapital(doc, tokens, pos);
            }
        }
        ,
        YEAR{

            public boolean accept(Document doc, Annotation[] tokens, int pos, ClassHierarchyResolver resolver) {
                String text = doc.normalizedText(tokens[pos]);
                return ClassRule.isYear(text);
            }
        }
        ,
        HOUR_MINUTE{

            public boolean accept(Document doc, Annotation[] tokens, int pos, ClassHierarchyResolver resolver) {
                String text = doc.normalizedText(tokens[pos]);
                return ClassRule.isHourMinute(text);
            }
        }
        ,
        TWO_DIGIT_YEAR{

            public boolean accept(Document doc, Annotation[] tokens, int pos, ClassHierarchyResolver resolver) {
                String text = doc.normalizedText(tokens[pos]);
                return ClassRule.isTwoDigitYear(text);
            }
        };


        abstract boolean accept(Document var1, Annotation[] var2, int var3, ClassHierarchyResolver var4);
    }
}

