/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.BioType;
import edu.nyu.jet.ne.Dictionary;
import edu.nyu.jet.ne.NamedEntityAttribute;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DictionaryTagger {
    Dictionary dict;

    public void setDictionary(Dictionary dict) {
        this.dict = dict;
    }

    public void annotate(Document doc, Span span) {
        List<Annotation> neTokens = doc.annotationsOfType("NE_INTERNAL", span);
        if (neTokens == null) {
            neTokens = Collections.emptyList();
        }
        String[] words = new String[neTokens.size()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = doc.normalizedText(neTokens.get(i));
        }
        int offset = 0;
        this.dict.lookupStart(words);
        while (offset < words.length) {
            Dictionary.Entry entry = this.dict.lookup(offset);
            if (entry != null) {
                for (String category : entry.getValue()) {
                    NamedEntityAttribute attr = new NamedEntityAttribute(category, BioType.B);
                    Set attrs = (Set)neTokens.get(offset).get("categories");
                    attrs.add(attr);
                    attr = new NamedEntityAttribute(category, BioType.I);
                    for (int i = offset + 1; i < offset + entry.getLength(); ++i) {
                        attrs = (Set)neTokens.get(i).get("categories");
                        attrs.add(attr);
                    }
                }
                offset += entry.getLength();
                continue;
            }
            ++offset;
        }
    }

    public void annotate(Document doc) {
        this.annotate(doc, new Span(0, doc.length()));
    }
}

