/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluator {
    private static final String TOTAL = "\u0000";
    private TObjectIntHashMap correct = new TObjectIntHashMap();
    private TObjectIntHashMap miss = new TObjectIntHashMap();
    private TObjectIntHashMap gold = new TObjectIntHashMap();
    private TObjectIntHashMap system = new TObjectIntHashMap();

    public void evaluate(Document systemOut, Document goldOut) {
        Span span;
        String type;
        Map<Span, String> goldEntities = this.makeSpanToEntityTypeMap(goldOut);
        Map<Span, String> extractedEntities = this.makeSpanToEntityTypeMap(systemOut);
        for (Map.Entry<Span, String> entry : goldEntities.entrySet()) {
            type = entry.getValue();
            span = entry.getKey();
            String extractedType = extractedEntities.get(span);
            if (extractedType == null || !extractedType.equals(type)) {
                Evaluator.increment(this.miss, type);
            }
            Evaluator.increment(this.gold, type);
        }
        for (Map.Entry<Span, String> entry : extractedEntities.entrySet()) {
            type = entry.getValue();
            span = entry.getKey();
            String correctType = goldEntities.get(span);
            if (correctType != null && correctType.equals(type)) {
                Evaluator.increment(this.correct, type);
            }
            Evaluator.increment(this.system, type);
        }
    }

    public Collection<String> getTypes() {
        String[] types = new String[this.gold.size() - 1];
        int i = 0;
        for (Object key : this.gold.keys()) {
            if (key.equals(TOTAL)) continue;
            types[i++] = (String)key;
        }
        return Arrays.asList(types);
    }

    public double getPrecision(String type) {
        return (double)this.correct.get(type) / (double)this.system.get(type);
    }

    public double getPrecision() {
        return this.getPrecision(TOTAL);
    }

    public double getRecall(String type) {
        return (double)(this.gold.get(type) - this.miss.get(type)) / (double)this.gold.get(type);
    }

    public double getRecall() {
        return this.getRecall(TOTAL);
    }

    private Map<Span, String> makeSpanToEntityTypeMap(Document doc) {
        HashMap<Span, String> entities = new HashMap<Span, String>();
        Vector<Annotation> names = doc.annotationsOfType("ENAMEX");
        for (Annotation name : names) {
            entities.put(name.span(), (String)name.get("TYPE"));
        }
        return entities;
    }

    private static void increment(TObjectIntHashMap map, Object key) {
        if (map.containsKey(key)) {
            map.increment(key);
        } else {
            map.put(key, 1);
        }
        if (map.containsKey(TOTAL)) {
            map.increment(TOTAL);
        } else {
            map.put(TOTAL, 1);
        }
    }
}

