/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.ne.BioType;
import edu.nyu.jet.ne.NamedEntityAttribute;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class NamedEntityUtil {
    public static void splitToNamedEntity(Document doc, Span span) {
        Vector<Annotation> enamexList;
        Vector<Annotation> tokenList = doc.annotationsOfType("token", span);
        for (Annotation token : tokenList) {
            HashSet categories = new HashSet();
            FeatureSet f = new FeatureSet();
            f.put("categories", categories);
            doc.annotate("NE_INTERNAL", token.span(), f);
        }
        Vector<Annotation> posList = doc.annotationsOfType("tagger", span);
        if (posList != null) {
            for (Annotation pos : posList) {
                Vector<Annotation> neList = doc.annotationsAt(pos.start(), "NE_INTERNAL");
                if (neList == null || neList.size() <= 0) continue;
                for (Annotation ne : neList) {
                    ne.put("pos", pos.get("cat"));
                }
            }
        }
        if ((enamexList = doc.annotationsOfType("ENAMEX", span)) != null) {
            for (Annotation enamex : enamexList) {
                Vector<Annotation> neList = doc.annotationsOfType("NE_INTERNAL", enamex.span());
                String type = (String)enamex.get("TYPE");
                NamedEntityAttribute attrB = new NamedEntityAttribute(type, BioType.B);
                NamedEntityAttribute attrI = new NamedEntityAttribute(type, BioType.I);
                Set categories = (Set)neList.get(0).get("categories");
                categories.add(attrB);
                for (int i = 1; i < neList.size(); ++i) {
                    Set categories2 = (Set)neList.get(i).get("categories");
                    categories2.add(attrI);
                }
            }
            for (Annotation enamex : enamexList) {
                doc.removeAnnotation(enamex);
            }
        }
    }

    public static void splitToNamedEntity(Document doc) {
        NamedEntityUtil.splitToNamedEntity(doc, doc.fullSpan());
    }

    public static void packNamedEntity(Document doc, Span span, String system) {
        Vector<Annotation> namedEntityList = doc.annotationsOfType("NE_INTERNAL");
        if (namedEntityList == null) {
            return;
        }
        int offset = 0;
        while (offset < namedEntityList.size()) {
            Annotation ne;
            Set attrs;
            Set categories = (Set)namedEntityList.get(offset).get("categories");
            if (categories == null || categories.size() == 0) {
                ++offset;
                continue;
            }
            NamedEntityAttribute category = null;
            for (NamedEntityAttribute attr : categories) {
                if (attr.getBioType() != BioType.B) continue;
                category = attr;
                break;
            }
            if (category == null) {
                ++offset;
                continue;
            }
            NamedEntityAttribute followAttrbute = new NamedEntityAttribute(category.getCategory(), BioType.I);
            int len = 1;
            while (offset + len < namedEntityList.size() && (attrs = (Set)(ne = namedEntityList.get(offset + len)).get("categories")).contains(followAttrbute)) {
                ++len;
            }
            FeatureSet f = new FeatureSet();
            f.put("TYPE", category.getCategory());
            if (system != null) {
                f.put("SYSTEM", system);
            }
            int start = namedEntityList.get(offset).start();
            int end = namedEntityList.get(offset + len - 1).end();
            doc.annotate("ENAMEX", new Span(start, end), f);
            offset += len;
        }
        for (Annotation a : namedEntityList) {
            doc.removeAnnotation(a);
        }
    }

    public static void packNamedEntity(Document doc, String system) {
        NamedEntityUtil.packNamedEntity(doc, doc.fullSpan(), system);
    }
}

