/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import edu.umass.cs.mallet.base.types.LabelSequence;
import edu.umass.cs.mallet.base.types.Token;
import edu.umass.cs.mallet.base.types.TokenSequence;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SentenceToTokenSequencePipe
extends Pipe {
    public SentenceToTokenSequencePipe() {
        super(null, LabelAlphabet.class);
    }

    public Instance pipe(Instance carrier) {
        Span span;
        Document doc = (Document)carrier.getSource();
        List<Annotation> names = doc.annotationsOfType("ENAMEX", span = (Span)carrier.getData());
        if (names == null) {
            names = Collections.emptyList();
        }
        Annotation.sortByStartPosition(names);
        TokenSequence data = new TokenSequence();
        LabelSequence target = new LabelSequence((LabelAlphabet)this.getTargetAlphabet());
        int pos = span.start();
        for (Annotation name : names) {
            if (name.start() > pos) {
                this.addTokens(data, target, doc, new Span(pos, name.start()), "O");
            }
            this.addTokens(data, target, doc, name.span(), (String)name.get("TYPE"));
            pos = name.end();
        }
        if (pos < span.end()) {
            this.addTokens(data, target, doc, new Span(pos, span.end()), "O");
        }
        carrier.setData(data);
        carrier.setSource(data);
        carrier.setTarget(target);
        carrier.setProperty("document", doc);
        carrier.setProperty("span", span);
        return carrier;
    }

    private void addTokens(TokenSequence data, LabelSequence target, Document doc, Span span, String label) {
        Vector<Annotation> tokens = doc.annotationsOfType("token", span);
        if (tokens == null) {
            return;
        }
        Annotation.sortByStartPosition(tokens);
        if (label.equals("O")) {
            for (Annotation token : tokens) {
                data.add(this.makeToken(doc, token));
                target.add(label);
            }
        } else {
            data.add(this.makeToken(doc, (Annotation)tokens.get(0)));
            target.add("B-" + label);
            String followingLabel = "I-" + label;
            for (int i = 1; i < tokens.size(); ++i) {
                Annotation token = (Annotation)tokens.get(i);
                data.add(this.makeToken(doc, token));
                target.add(followingLabel);
            }
        }
    }

    private Token makeToken(Document doc, Annotation token) {
        Token t = new Token(doc.normalizedText(token));
        t.setProperty("span", token.span());
        return t;
    }
}

