/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.ChangeRule;
import edu.nyu.jet.ne.ChangeType;
import edu.nyu.jet.ne.ClassHierarchyResolver;
import edu.nyu.jet.ne.MatchRuleItem;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.Set;

public class TransformRule {
    private MatchRuleItem[] ruleItems;
    private ChangeRule[] changeRules;
    private ChangeType changeType;

    public void setMatchRules(MatchRuleItem[] ruleItems) {
        this.ruleItems = ruleItems;
    }

    public void setChangeRule(ChangeType type, ChangeRule[] changeRules) {
        this.changeType = type;
        this.changeRules = changeRules;
    }

    public int getPatternTokenCount() {
        return this.ruleItems.length;
    }

    public boolean accept(Document doc, Annotation[] tokens, int pos, ClassHierarchyResolver resolver) {
        if (pos + this.ruleItems.length > tokens.length) {
            return false;
        }
        for (int i = 0; i < this.ruleItems.length; ++i) {
            if (this.ruleItems[i].accept(doc, tokens, pos + i, resolver)) continue;
            return false;
        }
        return true;
    }

    public void transform(Document doc, Annotation[] tokens, int pos) {
        if (!this.canApplyChangeRule(doc, tokens, pos)) {
            return;
        }
        for (ChangeRule change : this.changeRules) {
            int index = change.getIndex();
            Set attrs = (Set)tokens[pos + index].get("categories");
            attrs.clear();
            attrs.add(change.getNamedEntity());
        }
    }

    private boolean canApplyChangeRule(Document doc, Annotation[] tokens, int pos) {
        if (this.changeType == ChangeType.FORCE) {
            return true;
        }
        for (ChangeRule change : this.changeRules) {
            int n = change.getIndex();
            Set attrs = (Set)tokens[pos + n].get("categories");
            if (attrs.size() <= 0) continue;
            return false;
        }
        return true;
    }
}

