/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.ClassHierarchyResolver;
import edu.nyu.jet.ne.ExactMatchClassHierarchyResolver;
import edu.nyu.jet.ne.RuleFormatException;
import edu.nyu.jet.ne.TransformRule;
import edu.nyu.jet.ne.TransformRuleParser;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformRules {
    private List<TransformRule> rules;
    private ClassHierarchyResolver resolver;

    public TransformRules(List<TransformRule> rules, ClassHierarchyResolver resolver) {
        this.rules = rules;
        this.resolver = resolver;
    }

    public TransformRules(List<TransformRule> rules) {
        this.rules = rules;
        this.resolver = new ExactMatchClassHierarchyResolver();
    }

    public void apply(Document doc, Span span) {
        Vector<Annotation> neList = doc.annotationsOfType("NE_INTERNAL", span);
        Annotation[] tokens = neList.toArray(new Annotation[0]);
        block0: for (int i = 0; i < tokens.length; ++i) {
            for (TransformRule rule : this.rules) {
                if (i + rule.getPatternTokenCount() > tokens.length || !rule.accept(doc, tokens, i, this.resolver)) continue;
                rule.transform(doc, tokens, i);
                continue block0;
            }
        }
    }

    public void setClassHierarchyResolver(ClassHierarchyResolver resolver) {
        this.resolver = resolver;
    }

    public ClassHierarchyResolver getClassHierarchyResolver() {
        return this.resolver;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public static TransformRules load(Reader in) throws IOException, RuleFormatException {
        TransformRuleParser parser = new TransformRuleParser();
        List<TransformRule> rules = parser.parse(in);
        return new TransformRules(rules);
    }

    public static TransformRules load(File file) throws IOException, RuleFormatException {
        FileReader in = new FileReader(file);
        return TransformRules.load(in);
    }
}

