/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.parser.DepTransformer;
import edu.nyu.jet.parser.SyntacticRelation;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import tratz.parse.FullSystemWrapper;
import tratz.parse.types.Arc;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

public class DepParser {
    private static FullSystemWrapper fsw = null;
    static DepTransformer transformer = null;
    static String[] SPECIAL_TOKEN = new String[]{"ENAMEX", "NUMEX", "TIMEX", "TIMEX2", "TERM"};

    public static void initialize(String dataPath, Properties config) {
        String parseModelFile = config.getProperty("DepParser.model.fileName");
        if (parseModelFile != null) {
            DepParser.initWrapper(dataPath + "/" + parseModelFile);
            transformer = new DepTransformer(config.getProperty("DepParser.transformations"));
        }
    }

    private static void initWrapper(String parseModelFile) {
        DepParser.initWrapper(null, null, null, null, null, null, parseModelFile, null);
    }

    private static void initWrapper(String prepositionModelFile, String nounCompoundModelFile, String possessivesModelFile, String srlArgsModelFile, String srlPredicatesModelFile, String posModelFile, String parseModelFile, String wnDir) {
        if (fsw == null) {
            try {
                fsw = new FullSystemWrapper(prepositionModelFile, nounCompoundModelFile, possessivesModelFile, srlArgsModelFile, srlPredicatesModelFile, posModelFile, parseModelFile, wnDir);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
    }

    public static boolean isInitialized() {
        return fsw != null;
    }

    public static SyntacticRelationSet parseDocument(Document doc) {
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        if (sentences == null || sentences.size() == 0) {
            System.out.println("DepParser:  no sentences");
            return null;
        }
        if (fsw == null) {
            System.out.println("DepParser:  no model loaded");
            return null;
        }
        SyntacticRelationSet relations = new SyntacticRelationSet();
        for (Annotation sentence : sentences) {
            Span span = sentence.span();
            DepParser.parseSentence(doc, span, relations);
        }
        return relations;
    }

    public static void parseSentence(Document doc, Span span, SyntacticRelationSet relations) {
        if (fsw == null) {
            System.out.println("DepParser:  no model loaded");
            return;
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        ArrayList<Integer> offset = new ArrayList<Integer>();
        offset.add(0);
        int tokenNum = 0;
        int posn = span.start();
        while (posn < span.end()) {
            ++tokenNum;
            Annotation tokenAnnotation = doc.tokenAt(posn);
            for (String s : SPECIAL_TOKEN) {
                Vector<Annotation> va = doc.annotationsAt(posn, s);
                if (va == null || va.size() <= 0) continue;
                tokenAnnotation = va.get(0);
                break;
            }
            if (tokenAnnotation == null) {
                return;
            }
            String tokenText = doc.normalizedText(tokenAnnotation).replaceAll(" ", "_");
            Vector<Annotation> v = doc.annotationsAt(posn, "tagger");
            Annotation a = v.get(0);
            String pos = (String)a.get("cat");
            tokens.add(new Token(tokenText, pos, tokenNum));
            offset.add(posn);
            if (posn >= tokenAnnotation.end()) break;
            posn = tokenAnnotation.end();
        }
        Sentence sent = new Sentence(tokens);
        Arc[] arcs = fsw.process(sent, tokens.size() > 0 && ((Token)tokens.get(0)).getPos() == null, true, true, true, true, true).getParse().getHeadArcs();
        List<Arc> arcList = transformer.transform(arcs, sent);
        for (Arc arc : arcs) {
            if (arc == null || arc.getDependency().equalsIgnoreCase("ROOT")) continue;
            Token head = arc.getHead();
            String headText = head.getText();
            String headPos = head.getPos();
            Integer headOffset = (Integer)offset.get(head.getIndex());
            Token dep = arc.getChild();
            String depText = dep.getText();
            String depPos = dep.getPos();
            Integer depOffset = (Integer)offset.get(dep.getIndex());
            String type = arc.getDependency();
            SyntacticRelation r = new SyntacticRelation(headOffset, headText, headPos, type, depOffset, depText, depPos);
            relations.add(r);
        }
    }
}

