/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tratz.parse.types.Arc;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepTransformer {
    String transformList;

    DepTransformer(String transformList) {
        this.transformList = transformList;
    }

    public List<Arc> transform(Arc[] arcs, Sentence sent) {
        String dep;
        Token head;
        Arc arc;
        Token child1;
        Token head1;
        String dep1;
        Arc arc1;
        int i;
        if (this.transformList == null) {
            return Arrays.asList(arcs);
        }
        List<Token> tokens = sent.getTokens();
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> ends = new ArrayList<Integer>();
        ArrayList paths = new ArrayList();
        ArrayList<Boolean> passives = new ArrayList<Boolean>();
        int start = -1;
        int end = -1;
        boolean passive = false;
        boolean[] vchLeaf = new boolean[arcs.length];
        for (i = 0; i < arcs.length; ++i) {
            vchLeaf[i] = true;
        }
        for (i = 1; i < arcs.length; ++i) {
            arc1 = arcs[i];
            if (arc1 == null) {
                arc1 = new Arc(tokens.get(i - 1), new Token("", 0), "ROOT");
            }
            dep1 = arc1.getDependency();
            head1 = arc1.getHead();
            child1 = arc1.getChild();
            if (!dep1.equals("vch")) continue;
            vchLeaf[head1.getIndex()] = false;
        }
        for (i = 1; i < arcs.length; ++i) {
            arc1 = arcs[i];
            if (arc1 == null) {
                arc1 = new Arc(tokens.get(i - 1), new Token("", 0), "ROOT");
            }
            if (!vchLeaf[i]) continue;
            dep1 = arc1.getDependency();
            head1 = arc1.getHead();
            child1 = arc1.getChild();
            if (!dep1.equals("vch")) continue;
            ArrayList<Integer> path = new ArrayList<Integer>();
            path.add(i);
            int next = head1.getIndex();
            passive = false;
            if (DepTransformer.isBe(arcs[next].getChild().getText())) {
                passive = true;
            }
            path.add(next);
            while (arcs[next].getDependency().equals("vch")) {
                if (DepTransformer.isBe(arcs[next = arcs[next].getHead().getIndex()].getChild().getText())) {
                    passive = true;
                }
                path.add(next);
            }
            starts.add(next);
            ends.add(i);
            passives.add(passive);
            paths.add(path);
        }
        for (i = 0; i < starts.size(); ++i) {
            start = (Integer)starts.get(i);
            end = (Integer)ends.get(i);
            passive = (Boolean)passives.get(i);
            arcs[end].setHead(arcs[start].getHead());
            arcs[end].setDependency(arcs[start].getDependency());
            for (int k = 1; k < arcs.length; ++k) {
                Arc arc2 = arcs[k];
                Token child = arc2.getChild();
                Token head2 = arc2.getHead();
                String dep2 = arc2.getDependency();
                if (passive && head2.getIndex() == end && dep2.equals("agent")) {
                    for (int l = 1; l < arcs.length; ++l) {
                        Arc arc22 = arcs[l];
                        Token child2 = arc22.getChild();
                        Token head22 = arc22.getHead();
                        String dep22 = arc22.getDependency();
                        if (head22.getIndex() != child.getIndex() || !dep22.equals("pobj")) continue;
                        arc22.setHead(head2);
                        arc22.setDependency("nsubj");
                    }
                }
                if (head2.getIndex() != start) continue;
                arc2.setHead(tokens.get(end - 1));
                if (!passive || !dep2.equals("nsubj")) continue;
                arc2.setDependency("dobj");
            }
            ArrayList path = (ArrayList)paths.get(i);
            for (int j = path.size() - 1; j > 0; --j) {
                arcs[(Integer)path.get(j)].setDependency("vch");
                arcs[(Integer)path.get(j)].setHead(tokens.get((Integer)path.get(j - 1) - 1));
            }
        }
        for (i = 1; i < arcs.length; ++i) {
            String indep;
            int inhead;
            int inchild;
            Arc inarc;
            boolean check;
            int j;
            boolean order;
            arc = arcs[i];
            Token child = arc.getChild();
            head = arc.getHead();
            dep = arc.getDependency();
            if (!dep.equals("rcmod")) continue;
            Token wh = null;
            boolean bl = order = head.getIndex() < child.getIndex();
            if (order) {
                for (j = head.getIndex(); j < child.getIndex(); ++j) {
                    if (!tokens.get(j).getPos().toLowerCase().startsWith("w")) continue;
                    check = false;
                    inarc = arcs[j + 1];
                    inchild = inarc.getChild().getIndex();
                    inhead = inarc.getHead().getIndex();
                    indep = inarc.getDependency();
                    while (inhead != 0) {
                        if (inhead == child.getIndex()) {
                            check = true;
                            break;
                        }
                        inhead = arcs[inhead].getHead().getIndex();
                    }
                    if (!check) break;
                    wh = tokens.get(j);
                    break;
                }
            } else {
                for (j = head.getIndex() - 2; j >= child.getIndex() - 1; --j) {
                    if (!tokens.get(j).getPos().toLowerCase().startsWith("w")) continue;
                    check = false;
                    inarc = arcs[j + 1];
                    inchild = arc.getChild().getIndex();
                    inhead = arc.getHead().getIndex();
                    indep = arc.getDependency();
                    while (inhead > 0) {
                        if (inhead == child.getIndex()) {
                            check = true;
                            break;
                        }
                        inhead = arcs[inhead].getHead().getIndex();
                    }
                    if (!check) break;
                    wh = tokens.get(j);
                    break;
                }
            }
            if (wh == null) continue;
            for (int m = 1; m < arcs.length; ++m) {
                Arc inarc2 = arcs[m];
                int inchild2 = arc.getChild().getIndex();
                int inhead2 = arc.getHead().getIndex();
                String indep2 = arc.getDependency();
                if (inhead2 != wh.getIndex()) continue;
                inarc2.setHead(wh);
            }
            arcs[wh.getIndex()].setChild(head);
        }
        for (i = 1; i < arcs.length; ++i) {
            arc = arcs[i];
            Token child = arc.getChild();
            head = arc.getHead();
            dep = arc.getDependency();
            if (!dep.equals("pobj")) continue;
            Token in = head;
            Arc arc2 = arcs[in.getIndex()];
            Token inhead = arc2.getHead();
            String inDep = arc2.getDependency();
            if (!inDep.equals("prep")) continue;
            arc.setDependency("prep_" + in.getText());
            arc.setHead(inhead);
        }
        return Arrays.asList(arcs);
    }

    public static boolean isBe(String word) {
        return word.equals("be") || word.equals("being") || word.equals("been") || word.equals("am") || word.equals("'m") || word.equals("is") || word.equals("'s") || word.equals("are") || word.equals("'re") || word.equals("was") || word.equals("were");
    }
}

