/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.lisp.Literal;
import edu.nyu.jet.parser.Production;
import edu.nyu.jet.pat.PatternSyntaxError;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;

public class Grammar {
    private Hashtable productions = new Hashtable();
    private Hashtable productionsEndingIn = new Hashtable();

    public Vector getProductions(String LHS) {
        return (Vector)this.productions.get(LHS);
    }

    public Vector getProductionsEndingIn(Object element) {
        return (Vector)this.productionsEndingIn.get(element);
    }

    public boolean defines(String s) {
        return this.productions.containsKey(s);
    }

    public Grammar(Reader reader) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(reader);
        block2: while (true) {
            try {
                while (true) {
                    if (tok.nextToken() == -1) {
                        return;
                    }
                    this.readGrammarRule(tok);
                }
            }
            catch (PatternSyntaxError pse) {
                int ln = tok.lineno();
                System.out.println("*** syntax error in grammar file, line " + ln);
                System.out.println(pse.toString());
                System.out.println("Current token = " + tok.toString());
                do {
                    if (tok.nextToken() == 59) continue block2;
                } while (tok.ttype != -1);
                return;
            }
            break;
        }
    }

    private void readGrammarRule(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        String LHS = tok.sval.intern();
        if (tok.nextToken() != 58) {
            throw new PatternSyntaxError(": expected");
        }
        if (tok.nextToken() != 61) {
            throw new PatternSyntaxError("= expected");
        }
        tok.nextToken();
        Vector prods = this.readRHS(LHS, tok);
        if (tok.ttype != 59) {
            throw new PatternSyntaxError("; expected");
        }
        this.productions.put(LHS, prods);
        for (int i = 0; i < prods.size(); ++i) {
            Production prod = (Production)prods.elementAt(i);
            Object lastElement = prod.rhs().lastElement();
            if (!this.productionsEndingIn.containsKey(lastElement)) {
                this.productionsEndingIn.put(lastElement, new Vector());
            }
            ((Vector)this.productionsEndingIn.get(lastElement)).addElement(prod);
        }
    }

    private Vector readRHS(String LHS, StreamTokenizer tok) throws IOException, PatternSyntaxError {
        Vector<Production> prods = new Vector<Production>();
        prods.addElement(new Production(LHS, this.readOption(tok)));
        while (tok.ttype == 124) {
            tok.nextToken();
            prods.addElement(new Production(LHS, this.readOption(tok)));
        }
        return prods;
    }

    private Vector readOption(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        Vector<Object> elements = new Vector<Object>();
        Object ge = this.readGrammarElement(tok);
        if (ge == null) {
            throw new PatternSyntaxError();
        }
        do {
            elements.addElement(ge);
        } while ((ge = this.readGrammarElement(tok)) != null);
        return elements;
    }

    private Object readGrammarElement(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.ttype == 34) {
            Literal lit = new Literal(tok.sval.intern());
            tok.nextToken();
            return lit;
        }
        if (tok.ttype == -3) {
            String sym = tok.sval.intern();
            tok.nextToken();
            return sym;
        }
        return null;
    }
}

