/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.Console;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.lisp.Literal;
import edu.nyu.jet.parser.Edge;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;

public class ParseTreeNode
extends Edge {
    public Annotation ann;
    public String word;
    public int head;
    public String function;

    public ParseTreeNode(Object category, ParseTreeNode[] children, int start, int end, Annotation ann, String word) {
        this(category, children, start, end, ann, word, null);
    }

    public ParseTreeNode(Object category, ParseTreeNode[] children, int start, int end, Annotation ann, String word, String function) {
        this.category = category;
        this.children = children;
        this.start = start;
        this.end = end;
        this.ann = ann;
        this.word = word;
        this.head = 0;
        this.function = function;
    }

    public ParseTreeNode(Object category, ParseTreeNode[] children, int start, int end, int head) {
        this(category, children, start, end, head, null);
    }

    public ParseTreeNode(Object category, ParseTreeNode[] children, int start, int end, int head, String function) {
        this.category = category;
        this.children = children;
        this.start = start;
        this.end = end;
        this.ann = null;
        this.word = null;
        this.head = head;
        this.function = function;
    }

    public String toString() {
        if (this.category instanceof Literal) {
            return this.category.toString();
        }
        if (this.word != null) {
            return (String)this.category + " = " + this.word;
        }
        return (String)this.category;
    }

    public void printTree() {
        this.printTree(0);
    }

    private void printTree(int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            Console.print(" ");
        }
        Console.println(this.toString());
        if (this.children != null && this.children.length > 0) {
            for (i = 0; i < this.children.length; ++i) {
                this.children[i].printTree(indent + 4);
            }
        }
    }

    public static Annotation makeParseAnnotations(Document doc, ParseTreeNode n) {
        if (n.children == null) {
            return n.ann;
        }
        int childCount = n.children.length;
        Annotation[] children = new Annotation[childCount];
        for (int i = 0; i < childCount; ++i) {
            children[i] = ParseTreeNode.makeParseAnnotations(doc, n.children[i]);
        }
        Annotation head = null;
        if (n.head > 0 && n.head <= children.length) {
            head = children[n.head - 1];
        }
        Annotation a = new Annotation("constit", new Span(n.start, n.end), new FeatureSet("cat", n.category, "children", children, "headC", head));
        doc.addAnnotation(a);
        n.ann = a;
        return a;
    }

    public static Annotation[] children(Annotation node) {
        if (node == null) {
            return null;
        }
        Object c = node.get("children");
        if (c == null) {
            return null;
        }
        if (!(c instanceof Annotation[])) {
            return null;
        }
        return (Annotation[])c;
    }

    public static void terminalToToken(Document doc, ParseTreeNode node) {
        if (node.children == null) {
            FeatureSet fs = new FeatureSet();
            doc.annotate("token", node.ann.span(), fs);
        } else {
            for (ParseTreeNode child : node.children) {
                ParseTreeNode.terminalToToken(doc, child);
            }
        }
    }
}

