/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;

public class ParseView
extends JFrame {
    private JScrollPane jScrollPane = new JScrollPane();
    private JParseComponent parseComponent;
    public static String[] relations = new String[]{"none", "subject", "object", "of", "apposite", "headC", "pp", "preName", "nameMod"};
    public static String[] features = new String[]{"none", "head"};
    private int i;
    private String relationToShow;
    private String featureToShow;

    public ParseView(String title, Annotation root) {
        super(title);
        this.setSize(400, 300);
        this.parseComponent = new JParseComponent();
        this.jScrollPane.getViewport().add(this.parseComponent);
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.buildMenus();
        this.setVisible(true);
        this.parseComponent.init(root);
    }

    private void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu relationMenu = new JMenu("relations");
        this.i = 0;
        while (this.i < relations.length) {
            JMenuItem showRelation = new JMenuItem(relations[this.i]);
            showRelation.addActionListener(new ActionListener(){
                int j;
                JParseComponent pc;
                {
                    this.j = ParseView.this.i;
                    this.pc = ParseView.this.parseComponent;
                }

                public void actionPerformed(ActionEvent e) {
                    ParseView.this.relationToShow = relations[this.j];
                    this.pc.repaint();
                }
            });
            relationMenu.add(showRelation);
            ++this.i;
        }
        menuBar.add(relationMenu);
        JMenu featureMenu = new JMenu("features");
        this.i = 0;
        while (this.i < features.length) {
            JMenuItem showRelation = new JMenuItem(features[this.i]);
            showRelation.addActionListener(new ActionListener(){
                int j;
                JParseComponent pc;
                {
                    this.j = ParseView.this.i;
                    this.pc = ParseView.this.parseComponent;
                }

                public void actionPerformed(ActionEvent e) {
                    ParseView.this.featureToShow = features[this.j];
                    this.pc.layOutTree();
                    this.pc.repaint();
                }
            });
            featureMenu.add(showRelation);
            ++this.i;
        }
        menuBar.add(featureMenu);
        this.setJMenuBar(menuBar);
    }

    protected class JParseComponent
    extends JComponent {
        ArrayList nodes = new ArrayList();
        HashMap position = new HashMap();
        FontMetrics fm;
        private int height;
        private int verticalSeparation;
        private int horizontalSeparation;
        private int maxX;
        private int maxY;
        private Annotation root;

        JParseComponent() {
        }

        void init(Annotation root) {
            this.fm = this.getGraphics().getFontMetrics();
            this.horizontalSeparation = this.fm.charWidth('m');
            this.height = this.fm.getHeight();
            this.verticalSeparation = this.height * 2;
            this.root = root;
            this.layOutTree();
        }

        void layOutTree() {
            this.maxX = 0;
            this.maxY = 0;
            this.computePosition(this.root, 10, 10);
            this.setPreferredSize(new Dimension(this.maxX + 50, this.maxY + 50));
        }

        int computePosition(Annotation root, int x, int y) {
            this.nodes.add(root);
            int childrenWidth = 0;
            Annotation[] children = ParseTreeNode.children(root);
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    int w = this.computePosition(children[i], x + childrenWidth, y + this.height + this.verticalSeparation);
                    childrenWidth += w + this.horizontalSeparation;
                }
                childrenWidth -= this.horizontalSeparation;
            } else {
                Document doc = root.span().document();
                String word = doc.text(root).trim();
                childrenWidth = this.fm.stringWidth(word);
            }
            String nodeName = this.nodeName(root);
            int localWidth = this.fm.stringWidth(nodeName);
            int width = Math.max(childrenWidth, localWidth);
            this.position.put(root, new Point(x + width / 2, y));
            this.maxX = Math.max(this.maxX, x);
            this.maxY = Math.max(this.maxY, y);
            return width;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            for (int i = 0; i < this.nodes.size(); ++i) {
                Annotation node = (Annotation)this.nodes.get(i);
                Point p = (Point)this.position.get(node);
                String nodeName = this.nodeName(node);
                int nodeWidth = this.fm.stringWidth(nodeName);
                g.drawString(nodeName, p.x - nodeWidth / 2, p.y);
                Annotation[] children = ParseTreeNode.children(node);
                if (children != null) {
                    for (int j = 0; j < children.length; ++j) {
                        Annotation child = children[j];
                        Point pChild = (Point)this.position.get(child);
                        g.drawLine(p.x, p.y + 2, pChild.x, pChild.y - this.height);
                    }
                } else {
                    Document doc = node.span().document();
                    String word = doc.text(node).trim();
                    int wordWidth = this.fm.stringWidth(word);
                    g.setColor(Color.blue);
                    g.drawString(word, p.x - wordWidth / 2, p.y + this.height + this.verticalSeparation);
                    g.drawLine(p.x, p.y + 2, p.x, p.y + this.verticalSeparation);
                    g.setColor(Color.black);
                }
                this.displayRelation(node, p, g);
            }
        }

        private String nodeName(Annotation node) {
            String head;
            String cat = (String)node.get("cat");
            if (ParseView.this.featureToShow == "head" && (head = SynFun.getImmediateHead(node)) != null) {
                return cat + " [" + head + "]";
            }
            return cat;
        }

        private void displayRelation(Annotation node, Point p, Graphics g) {
            if (ParseView.this.relationToShow == null) {
                return;
            }
            Object target = node.get(ParseView.this.relationToShow);
            if (target == null || !(target instanceof Annotation)) {
                return;
            }
            Point targetPosn = (Point)this.position.get(target);
            g.setColor(Color.red);
            g.drawLine(p.x + 4, p.y + 2, targetPosn.x + 4, targetPosn.y - this.height);
            g.setColor(Color.black);
        }
    }
}

