/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class Sparkle {
    static ExternalDocument doc;
    static String currentDoc;
    static final String sourceType = "text";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/Sparkle docs.txt";
    static final String keyFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/parse key.log";
    public static String[] relations;
    static int correct;
    static int spurious;
    static int missing;

    public static void main(String[] args) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace parser.properties");
        Ace.gazetteer = new Gazetteer();
        Pat.trace = false;
        Resolve.trace = false;
        HashMap key = Sparkle.readKey(keyFile);
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++docCount + ": " + currentDoc);
            doc = new ExternalDocument("sgml", "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training/nwire/" + currentDoc + ".sgm");
            doc.open();
            Control.processDocument(doc, null, docCount < 3, 1);
            ArrayList triples = Sparkle.extractDependencies(doc);
            ArrayList keyTriples = (ArrayList)key.get(currentDoc);
            Sparkle.score(triples, keyTriples);
            if (docCount < 3) continue;
            break;
        }
        System.out.print(correct + " triples correct, " + spurious + " spurious, ");
        System.out.println(missing + " missing.");
    }

    private static ArrayList extractDependencies(Document doc) {
        ArrayList<String> triples = new ArrayList<String>();
        Vector<Annotation> sents = doc.annotationsOfType("sentence");
        for (int isent = 0; isent < sents.size(); ++isent) {
            Annotation sent = sents.get(isent);
            int start = sent.span().start();
            int end = sent.span().end();
            for (int i = start; i < end; ++i) {
                Vector<Annotation> constits = doc.annotationsAt(i, "constit");
                if (constits == null) continue;
                for (int j = 0; j < constits.size(); ++j) {
                    Annotation ann = constits.elementAt(j);
                    for (int r = 0; r < relations.length; ++r) {
                        String relation = relations[r];
                        if (ann.get(relation) == null) continue;
                        Annotation value = (Annotation)ann.get(relation);
                        triples.add(Sparkle.buildQuad(isent + 1, ann, relation, value));
                    }
                }
            }
        }
        return triples;
    }

    private static String buildQuad(int sentNumber, Annotation parent, String relation, Annotation dependent) {
        String parentHead = SynFun.getNameOrHead(doc, parent);
        String dependentHead = SynFun.getNameOrHead(doc, dependent);
        return sentNumber + "|" + parentHead + "|" + relation + "|" + dependentHead;
    }

    private static HashMap readKey(String keyFile) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new FileReader(keyFile));
        HashMap<String, ArrayList<String>> key = new HashMap<String, ArrayList<String>>();
        String docId = "";
        while ((line = reader.readLine()) != null) {
            int poundsign = line.indexOf(35);
            if (poundsign >= 0) {
                line = line.substring(0, poundsign).trim();
            }
            if (line.trim().length() == 0) continue;
            if (line.length() >= 5 && line.substring(0, 5).equals("docid")) {
                docId = line.substring(5).trim();
                continue;
            }
            if (docId == "") {
                System.out.println("No docid specified, line ignored");
                continue;
            }
            ArrayList<String> vec = (ArrayList<String>)key.get(docId);
            if (vec == null) {
                vec = new ArrayList<String>();
            }
            vec.add(line);
            key.put(docId, vec);
        }
        return key;
    }

    private static void score(ArrayList response, ArrayList masterKey) {
        String quad;
        int i;
        if (masterKey == null) {
            System.out.println("No key.");
            return;
        }
        ArrayList key = new ArrayList(masterKey);
        for (i = 0; i < response.size(); ++i) {
            quad = (String)response.get(i);
            int j = key.indexOf(quad);
            if (j >= 0) {
                key.remove(j);
                System.out.println("Correct:  " + quad);
                ++correct;
                continue;
            }
            System.out.println("Spurious: " + quad);
            ++spurious;
        }
        for (i = 0; i < key.size(); ++i) {
            quad = (String)key.get(i);
            System.out.println("Missing:  " + quad);
            ++missing;
        }
    }

    static {
        relations = new String[]{"of", "subject", "object"};
        correct = 0;
        spurious = 0;
        missing = 0;
    }
}

