/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.parser.SyntacticRelation;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SyntacticRelationSet {
    ArrayList relations = new ArrayList();
    public static String[] relationTypes = new String[]{"of", "on", "in", "to", "by", "at", "through", "for", "with", "subject", "object", "poss", "nameMod"};
    public static HashMap nomVmap = new HashMap();
    public static boolean usePA = true;
    public static boolean useBaseForm = true;
    static final int GLARF_TUPLE_SIZE = 25;
    static final int GLARF_LOGICAL_ROLE = 0;
    static final int GLARF_PA_ROLE = 2;
    static final int GLARF_TRANSPARENT = 4;
    static final int GLARF_FUNCTOR = 5;
    static final int GLARF_FUNCTOR_OFFSET = 6;
    static final int GLARF_FUNCTOR_BASE_FORM = 9;
    static final int GLARF_FUNCTOR_VERB_FOR_NOM = 10;
    static final int GLARF_ARG = 17;
    static final int GLARF_ARG_OFFSET = 18;
    static final int GLARF_ARG_BASE_FORM = 21;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/";
    static final String outputDir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/sents/";

    public void addRelations(Document doc) {
        Vector<Annotation> constits = doc.annotationsOfType("constit");
        if (constits != null) {
            for (int j = 0; j < constits.size(); ++j) {
                Annotation ann = constits.elementAt(j);
                for (int r = 0; r < relationTypes.length; ++r) {
                    String type = relationTypes[r];
                    if (ann.get(type) == null) continue;
                    Annotation value = (Annotation)ann.get(type);
                    Annotation annHeadC = ann.get("mainV") != null ? (Annotation)ann.get("mainV") : Resolve.getHeadC(ann);
                    String annHead = SynFun.getHead(doc, annHeadC);
                    Annotation valueHeadC = Resolve.getHeadC(value);
                    String valueHead = SynFun.getHead(doc, valueHeadC);
                    SyntacticRelation relation = new SyntacticRelation(annHeadC.start(), annHead, type, valueHeadC.start(), valueHead);
                    this.relations.add(relation);
                    SyntacticRelation reciprocal = new SyntacticRelation(valueHeadC.start(), valueHead, type + "-1", annHeadC.start(), annHead);
                    this.relations.add(reciprocal);
                }
            }
        }
    }

    public void add(SyntacticRelation r) {
        if (!this.relations.contains(r)) {
            this.relations.add(r);
        }
    }

    public void addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add((SyntacticRelation)it.next());
        }
    }

    public int size() {
        return this.relations.size();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyntacticRelationSet)) {
            return false;
        }
        SyntacticRelationSet p = (SyntacticRelationSet)o;
        return this.relations.size() == p.relations.size() && this.relations.containsAll(p.relations);
    }

    public int hashCode() {
        if (this.size() == 0) {
            return 1;
        }
        return this.size() + this.relations.get(0).hashCode();
    }

    public SyntacticRelation get(int i) {
        return (SyntacticRelation)this.relations.get(i);
    }

    public SyntacticRelation getRelation(int from, int to) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation r = (SyntacticRelation)this.relations.get(i);
            if (r.sourcePosn != from || r.targetPosn != to) continue;
            return r;
        }
        return null;
    }

    public SyntacticRelation getRelation(int from, String type) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation r = (SyntacticRelation)this.relations.get(i);
            if (r.sourcePosn != from || !r.type.equalsIgnoreCase(type)) continue;
            return r;
        }
        return null;
    }

    public SyntacticRelationSet getRelationsFrom(int from) {
        SyntacticRelationSet s = new SyntacticRelationSet();
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation r = (SyntacticRelation)this.relations.get(i);
            if (r.sourcePosn != from) continue;
            s.add(r);
        }
        return s;
    }

    public SyntacticRelation getRelationTo(int to) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation r = (SyntacticRelation)this.relations.get(i);
            if (r.targetPosn != to) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation r = (SyntacticRelation)this.relations.get(i);
            buf.append(r.toString());
            if (i >= this.relations.size() - 1) continue;
            buf.append(this.relations.size() > 3 ? "\n " : "; ");
        }
        buf.append("}");
        return buf.toString();
    }

    public void write(PrintWriter pw) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation r = (SyntacticRelation)this.relations.get(i);
            pw.println(r.type + " | " + r.sourceWord + " | " + r.sourcePosn + " | " + r.targetWord + " | " + r.targetPosn);
        }
    }

    public void read(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            String[] parts = line.split(" \\| ");
            if (parts.length != 5) {
                System.err.println("Invalid input: " + line);
                continue;
            }
            try {
                SyntacticRelation r = new SyntacticRelation(Integer.valueOf(parts[2]), parts[1].trim(), parts[0].trim(), Integer.valueOf(parts[4]), parts[3].trim());
                this.add(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void readRelations(String fileName) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith(";")) continue;
                String[] fields = line.split(" \\| ");
                if (fields.length != 25) {
                    System.out.println("Invalid input line (" + fields.length + " fields): " + line);
                    continue;
                }
                try {
                    String type = fields[0].trim();
                    if (type.equals("RELATIVE") || type.equals("RED-RELATIVE")) continue;
                    String paRole = fields[2].trim();
                    String sourceWord = useBaseForm ? fields[9].trim().toLowerCase() : fields[5].trim();
                    int sourcePosn = Integer.parseInt(fields[6].trim());
                    String verb = fields[10].trim().toLowerCase();
                    String targetWord = useBaseForm ? fields[21].trim().toLowerCase() : fields[17].trim();
                    int targetPosn = Integer.parseInt(fields[18].trim());
                    if (!type.equals("NIL")) {
                        SyntacticRelation r = new SyntacticRelation(sourcePosn, sourceWord, type, targetPosn, targetWord);
                        boolean transparent = fields[4].equals("T");
                        if (transparent) {
                            r.setTransparent(true);
                        }
                        this.add(r);
                    }
                    if (!paRole.equals("NIL") && !paRole.equals("SUPPORT")) {
                        SyntacticRelation rpa = new SyntacticRelation(sourcePosn, sourceWord, paRole, targetPosn, targetWord);
                        this.add(rpa);
                    }
                    if (verb.equals("nil")) continue;
                    nomVmap.put(sourceWord + "/n", verb);
                    nomVmap.put(verb, sourceWord + "/n");
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid input line: " + line);
                }
            }
        }
        catch (IOException e) {
            System.out.println("readRelations error: " + e);
        }
        this.bypassTransparentLinks();
        this.addInverses();
    }

    private void bypassTransparentLinks() {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation rx = (SyntacticRelation)this.relations.get(i);
            String typex = rx.type;
            if (!typex.equals("ARG0") && !typex.equals("ARG1") && !typex.equals("ARG2") && !typex.equals("SBJ") && !typex.equals("OBJ") || !rx.targetWord.equals("of") && !rx.targetWord.equals("by")) continue;
            int tox = rx.targetPosn;
            for (int j = 0; j < this.relations.size(); ++j) {
                SyntacticRelation ry = (SyntacticRelation)this.relations.get(j);
                if (i == j || rx.targetPosn != ry.sourcePosn || !ry.type.equals("OBJ") || !ry.transparent) continue;
                rx.targetWord = ry.targetWord;
                rx.targetPosn = ry.targetPosn;
            }
        }
    }

    public void addInverses() {
        int Nrelations = this.relations.size();
        for (int i = 0; i < Nrelations; ++i) {
            SyntacticRelation r = (SyntacticRelation)this.relations.get(i);
            SyntacticRelation rinv = new SyntacticRelation(r.targetPosn, r.targetWord, r.type + "-1", r.sourcePosn, r.sourceWord);
            this.add(rinv);
        }
    }

    public static void main(String[] args) {
        SyntacticRelationSet s = new SyntacticRelationSet();
        s.readRelations("C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/sents/nw/AFP_ENG_20030323.0020.sent.txt.acetrip90");
        System.out.println(s.toString());
    }
}

