/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.Console;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.lisp.Variable;
import edu.nyu.jet.pat.Action;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternSyntaxError;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Vector;

public class NewAnnotationAction
extends Action {
    String type;
    FeatureSet features;
    Variable spanVariable;
    Variable bindingVariable;

    public NewAnnotationAction(String tp, FeatureSet fs, Variable sv) {
        this.type = tp;
        this.features = fs;
        this.spanVariable = sv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NewAnnotationAction(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.nextToken() == -3 && Character.isUpperCase(tok.sval.charAt(0))) {
            this.bindingVariable = new Variable(tok.sval);
            if (tok.nextToken() != 61) {
                throw new PatternSyntaxError("= expected");
            }
            tok.nextToken();
        }
        if (tok.ttype != 91) {
            throw new PatternSyntaxError("[ expected");
        }
        if (tok.nextToken() != -3) {
            throw new PatternSyntaxError("annotation type expected");
        }
        this.type = tok.sval;
        this.features = new FeatureSet(tok, true, ']');
        if (tok.nextToken() == -3 && tok.sval.equalsIgnoreCase("over")) {
            if (tok.nextToken() == -3 && Character.isUpperCase(tok.sval.charAt(0))) {
                this.spanVariable = new Variable(tok.sval);
                tok.nextToken();
                return;
            } else {
                if (tok.ttype != -2 || tok.nval != 0.0) throw new PatternSyntaxError("variable expected after 'over'");
                this.spanVariable = new Variable("0");
                tok.nextToken();
            }
            return;
        } else {
            this.spanVariable = null;
        }
    }

    public int perform(Document doc, PatternApplication patap) {
        Span span;
        HashMap bindings = patap.bestBindings;
        if (this.spanVariable == null) {
            span = new Span(patap.startPosition, patap.bestPosition);
        } else if (this.spanVariable.name.toString() == "0") {
            span = new Span(patap.startPosition, patap.startPosition);
        } else {
            Object value = bindings.get(this.spanVariable.name);
            if (value instanceof Span) {
                span = (Span)value;
            } else if (value instanceof Annotation) {
                span = ((Annotation)value).span();
            } else {
                System.out.println("Value of " + this.spanVariable.toString() + " is not a span.or annotation");
                return -1;
            }
        }
        if (Pat.trace) {
            Console.println("Annotating " + doc.text(span) + " as " + this.type + " " + this.features.substitute(bindings).toSGMLString());
        }
        NewAnnotationAction.hideAnnotations(doc, this.type, span);
        NewAnnotationAction.hideAnnotations(doc, "token", span);
        Annotation newAnnotation = new Annotation(this.type, span, this.features.substitute(bindings));
        doc.addAnnotation(newAnnotation);
        if (this.bindingVariable != null) {
            bindings.put(this.bindingVariable.name, newAnnotation);
        }
        return span.end();
    }

    public static void hideAnnotations(Document doc, String type, Span span) {
        for (int posn = span.start(); posn < span.end(); ++posn) {
            Vector<Annotation> annotations = doc.annotationsAt(posn, type);
            if (annotations == null) continue;
            for (int i = 0; i < annotations.size(); ++i) {
                Annotation ann = annotations.elementAt(i);
                ann.put("hidden", "true");
            }
        }
    }

    public String toString() {
        if (this.spanVariable == null) {
            return "add [" + this.type + this.features.toSGMLString() + "]";
        }
        return "add [" + this.type + this.features.toSGMLString() + "] over " + this.spanVariable.toString();
    }
}

