/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.lisp.Variable;
import edu.nyu.jet.pat.Action;
import edu.nyu.jet.pat.AddFeaturesAction;
import edu.nyu.jet.pat.AnnotationPatternElement;
import edu.nyu.jet.pat.AssignmentPatternElement;
import edu.nyu.jet.pat.IntegerPatternElement;
import edu.nyu.jet.pat.NewAnnotationAction;
import edu.nyu.jet.pat.PatternAlternation;
import edu.nyu.jet.pat.PatternElement;
import edu.nyu.jet.pat.PatternReference;
import edu.nyu.jet.pat.PatternRepetition;
import edu.nyu.jet.pat.PatternRule;
import edu.nyu.jet.pat.PatternSequence;
import edu.nyu.jet.pat.PatternSet;
import edu.nyu.jet.pat.PatternSyntaxError;
import edu.nyu.jet.pat.PrintAction;
import edu.nyu.jet.pat.SpanBindingPatternElement;
import edu.nyu.jet.pat.TokenStringPatternElement;
import edu.nyu.jet.pat.UndefinedCapPatternElement;
import edu.nyu.jet.pat.WriteAction;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PatternCollection {
    public Hashtable patterns = new Hashtable();
    public Hashtable patternSets = new Hashtable();
    public Vector patternNames = new Vector();
    public Vector patternSetNames = new Vector();
    private PatternSet currentPatternSet;

    public void readPatternCollection(Reader reader) throws IOException {
        this.currentPatternSet = null;
        LineNumberReader lnreader = new LineNumberReader(reader);
        StreamTokenizer tok = new StreamTokenizer(lnreader);
        block2: while (true) {
            try {
                while (true) {
                    if (tok.nextToken() == -1) {
                        return;
                    }
                    this.readPatternStatement(tok);
                }
            }
            catch (PatternSyntaxError pse) {
                int ln = lnreader.getLineNumber();
                System.out.println("*** syntax error in pattern file, line " + ln);
                System.out.println(pse.toString());
                System.out.println("Current token = " + tok.toString());
                do {
                    if (tok.nextToken() == 59) continue block2;
                } while (tok.ttype != -1);
                return;
            }
            break;
        }
    }

    private void readPatternStatement(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.ttype == -3) {
            if (tok.sval.equals("when")) {
                this.readWhenStatement(tok);
            } else if (tok.sval.equals("pattern")) {
                this.readPatternSetStatement(tok);
            } else {
                this.readPatternDefinition(tok);
            }
        } else {
            throw new PatternSyntaxError();
        }
    }

    private void readPatternDefinition(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        String patternName = tok.sval;
        if (tok.nextToken() != 58) {
            throw new PatternSyntaxError(": expected");
        }
        if (tok.nextToken() != 61) {
            throw new PatternSyntaxError("= expected");
        }
        tok.nextToken();
        PatternElement pattern = this.readPatternAlternation(tok);
        if (tok.ttype != 59) {
            throw new PatternSyntaxError("; expected");
        }
        this.patterns.put(patternName, pattern);
        this.patternNames.add(patternName);
    }

    private PatternElement readPatternAlternation(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        Vector<PatternElement> options = new Vector<PatternElement>();
        options.addElement(this.readPatternSequence(tok));
        while (tok.ttype == 124) {
            tok.nextToken();
            options.addElement(this.readPatternSequence(tok));
        }
        if (options.size() == 1) {
            return (PatternElement)options.get(0);
        }
        return new PatternAlternation(options);
    }

    private PatternElement readPatternSequence(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        Vector<PatternElement> sequence = new Vector<PatternElement>();
        PatternElement ape = this.readRepeatedPatternElement(tok);
        if (ape == null) {
            throw new PatternSyntaxError();
        }
        do {
            sequence.addElement(ape);
        } while ((ape = this.readRepeatedPatternElement(tok)) != null);
        if (sequence.size() == 1) {
            return (PatternElement)sequence.get(0);
        }
        return new PatternSequence(sequence);
    }

    private PatternElement readRepeatedPatternElement(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        PatternElement ape = this.readPatternElement(tok);
        if (ape == null) {
            return null;
        }
        char c = (char)tok.ttype;
        if (c == '?' || c == '*' || c == '+') {
            tok.nextToken();
            return new PatternRepetition(ape, c);
        }
        return ape;
    }

    private PatternElement readPatternElement(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.ttype == 34) {
            String stg = tok.sval;
            tok.nextToken();
            return new TokenStringPatternElement(stg);
        }
        if (tok.ttype == 91) {
            if (tok.nextToken() != -3) {
                throw new PatternSyntaxError();
            }
            String type = tok.sval;
            FeatureSet fs = new FeatureSet(tok, true, ']');
            tok.nextToken();
            if (type.equals("integer")) {
                return new IntegerPatternElement(fs);
            }
            if (type.equals("undefinedCap")) {
                return new UndefinedCapPatternElement(fs);
            }
            if (tok.ttype == 58) {
                if (tok.nextToken() == -3 && Character.isUpperCase(tok.sval.charAt(0))) {
                    String variable = tok.sval;
                    tok.nextToken();
                    return new AnnotationPatternElement(type, fs, new Variable(variable));
                }
                throw new PatternSyntaxError("variable expected after :");
            }
            return new AnnotationPatternElement(type, fs);
        }
        if (tok.ttype == -3) {
            if (Character.isUpperCase(tok.sval.charAt(0))) {
                String variable = tok.sval;
                if (tok.nextToken() != 61) {
                    throw new PatternSyntaxError("= expected");
                }
                AssignmentPatternElement pe = null;
                if (tok.nextToken() == -2) {
                    pe = new AssignmentPatternElement(new Variable(variable), new Integer((int)tok.nval));
                } else if (tok.ttype == -3) {
                    pe = new AssignmentPatternElement(new Variable(variable), tok.sval);
                } else {
                    throw new PatternSyntaxError("integer expected");
                }
                tok.nextToken();
                return pe;
            }
            String patternName = tok.sval;
            tok.nextToken();
            return new PatternReference(patternName, this);
        }
        if (tok.ttype == 40) {
            tok.nextToken();
            PatternElement pe = this.readPatternAlternation(tok);
            if (tok.ttype != 41) {
                throw new PatternSyntaxError(") expected");
            }
            if (tok.nextToken() == 58) {
                if (tok.nextToken() == -3 && Character.isUpperCase(tok.sval.charAt(0))) {
                    String variable = tok.sval;
                    pe = new SpanBindingPatternElement(pe, new Variable(variable));
                    tok.nextToken();
                } else {
                    throw new PatternSyntaxError("variable expected after :");
                }
            }
            return pe;
        }
        return null;
    }

    private void readWhenStatement(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.nextToken() != -3) {
            throw new PatternSyntaxError("no pattern name in when statement");
        }
        String patternName = tok.sval;
        Vector<Action> actions = new Vector<Action>();
        do {
            if (tok.nextToken() == -3) {
                if (tok.sval.equals("print")) {
                    actions.addElement(new PrintAction(tok));
                    continue;
                }
                if (tok.sval.equals("write")) {
                    actions.addElement(new WriteAction(tok));
                    continue;
                }
                if (tok.sval.equals("add")) {
                    actions.addElement(new NewAnnotationAction(tok));
                    continue;
                }
                if (tok.sval.equals("addFeatures")) {
                    actions.addElement(new AddFeaturesAction(tok));
                    continue;
                }
                throw new PatternSyntaxError("unknown action " + tok.sval);
            }
            throw new PatternSyntaxError("unknown action " + tok.sval);
        } while (tok.ttype == 44);
        if (tok.ttype != 59) {
            throw new PatternSyntaxError("; expected");
        }
        if (this.currentPatternSet == null) {
            throw new PatternSyntaxError("no pattern set defined");
        }
        this.currentPatternSet.addRule(new PatternRule(patternName, actions));
    }

    private void readPatternSetStatement(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.nextToken() != -3 || !tok.sval.equals("set")) {
            throw new PatternSyntaxError("'set' expected");
        }
        if (tok.nextToken() != -3) {
            throw new PatternSyntaxError("pattern set name expected");
        }
        String patternSetName = tok.sval;
        if (tok.nextToken() != 59) {
            throw new PatternSyntaxError("; expected");
        }
        if (this.patternSets.containsKey(patternSetName)) {
            this.currentPatternSet = (PatternSet)this.patternSets.get(patternSetName);
        } else {
            this.currentPatternSet = new PatternSet();
            this.patternSets.put(patternSetName, this.currentPatternSet);
            this.patternSetNames.add(patternSetName);
        }
    }

    public PatternElement getPattern(String patternName) {
        return (PatternElement)this.patterns.get(patternName);
    }

    public PatternElement dereference(String patternName) {
        return (PatternElement)this.patterns.get(patternName);
    }

    public PatternSet getPatternSet(String patternSetName) {
        return (PatternSet)this.patternSets.get(patternSetName);
    }

    public void makePatternGraph() {
        Enumeration pset = this.patternSets.elements();
        while (pset.hasMoreElements()) {
            PatternSet set = (PatternSet)pset.nextElement();
            set.makePatternGraph(this);
        }
    }

    public void apply(String patternSetName, Document doc) {
        if (this.patternSets.containsKey(patternSetName)) {
            PatternSet set = (PatternSet)this.patternSets.get(patternSetName);
            set.apply(doc);
        }
    }

    public void apply(String patternSetName, Document doc, Span span) {
        if (this.patternSets.containsKey(patternSetName)) {
            PatternSet set = (PatternSet)this.patternSets.get(patternSetName);
            set.apply(doc, span);
        }
    }
}

