/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.pat.FinalPatternNode;
import edu.nyu.jet.pat.Id;
import edu.nyu.jet.pat.InternalPatternNode;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternArc;
import edu.nyu.jet.pat.PatternCollection;
import edu.nyu.jet.pat.PatternElement;
import edu.nyu.jet.pat.PatternGraph;
import edu.nyu.jet.pat.PatternRule;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.HashMap;
import java.util.Vector;

public class PatternSet {
    Vector rules = new Vector();
    public InternalPatternNode rootNode;
    public static int limit;

    public void addRule(PatternRule rule) {
        this.rules.addElement(rule);
    }

    public void makePatternGraph(PatternCollection collection) {
        Vector initialArcs = new Vector();
        Id id = new Id(1);
        for (int i = 0; i < this.rules.size(); ++i) {
            PatternRule rule = (PatternRule)this.rules.get(i);
            PatternElement pe = collection.dereference(rule.patternName());
            if (pe == null) {
                System.out.println("Undefined pattern " + rule.patternName());
                continue;
            }
            PatternGraph pg = pe.toGraph(id);
            Vector actions = rule.actions();
            FinalPatternNode finalNode = new FinalPatternNode(new Id(id.value++), rule.patternName(), actions);
            pg.setOutEdges(finalNode);
            initialArcs.addAll(pg.inEdges);
        }
        PatternArc[] initialArcArray = initialArcs.toArray(new PatternArc[1]);
        this.rootNode = new InternalPatternNode(new Id(0), initialArcArray);
    }

    public void apply(Document doc) {
        this.apply(doc, new Span(0, doc.length()));
    }

    public void apply(Document doc, Span span) {
        int position = span.start();
        limit = span.end();
        while (doc.tokenAt(position) == null) {
            if (++position < limit) continue;
            return;
        }
        while (position < limit) {
            PatternApplication patap = new PatternApplication(doc, position);
            this.rootNode.eval(doc, position, new HashMap(), patap);
            int newPosition = patap.matchFound ? patap.performActions() : -1;
            if (newPosition >= 0) {
                position = newPosition;
                continue;
            }
            Annotation ann = doc.tokenAt(position);
            if (ann == null) {
                return;
            }
            position = ann.span().end();
        }
    }
}

