/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.refres.CorefScorer;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.Span;
import java.util.HashMap;
import java.util.Vector;

public class CorefCompare {
    public static void compareDocuments(Document response, Document key) {
        boolean different = false;
        HashMap<Annotation, Annotation> mentionMap = new HashMap<Annotation, Annotation>();
        Vector keyMentions = CorefScorer.findMentions(key);
        Vector responseMentions = CorefScorer.findMentions(response);
        block0: for (int i = 0; i < keyMentions.size(); ++i) {
            Annotation keyMention = (Annotation)keyMentions.get(i);
            Span keySpan = keyMention.span();
            for (int j = 0; j < responseMentions.size(); ++j) {
                Annotation responseMention = (Annotation)responseMentions.get(j);
                Annotation responseMentionHead = Resolve.getHeadC(responseMention);
                if (!responseMentionHead.span().equals(keySpan)) continue;
                mentionMap.put(keyMention, responseMention);
                responseMention.attributes().put("status", "OK");
                continue block0;
            }
            Annotation responseMention = new Annotation("mention", keySpan, new FeatureSet("status", "key"));
            response.addAnnotation(responseMention);
            mentionMap.put(keyMention, responseMention);
            different = true;
        }
        for (int j = 0; j < responseMentions.size(); ++j) {
            Annotation responseMention = (Annotation)responseMentions.get(j);
            if (responseMention.get("status") != null) continue;
            responseMention.attributes().put("status", "response");
            different = true;
        }
        Vector<Annotation> keyEntities = key.annotationsOfType("entity");
        Vector<Annotation> responseEntities = response.annotationsOfType("entity");
        block3: for (int i = 0; i < keyEntities.size(); ++i) {
            Annotation responseEntity;
            Annotation keyEntity = keyEntities.get(i);
            Vector keyEntityMentions = (Vector)keyEntity.get("mentions");
            block4: for (int j = 0; j < responseEntities.size(); ++j) {
                responseEntity = responseEntities.get(j);
                Vector responseEntityMentions = (Vector)responseEntity.get("mentions");
                if (keyEntityMentions.size() != responseEntityMentions.size()) continue;
                for (int k = 0; k < keyEntityMentions.size(); ++k) {
                    Annotation keyMention = (Annotation)keyEntityMentions.get(k);
                    boolean foundResponseMention = false;
                    for (int kk = 0; kk < responseEntityMentions.size(); ++kk) {
                        Annotation responseMention = (Annotation)responseEntityMentions.get(kk);
                        if (mentionMap.get(keyMention) != responseMention) continue;
                        foundResponseMention = true;
                        break;
                    }
                    if (!foundResponseMention) continue block4;
                }
                responseEntity.put("status", "OK");
                continue block3;
            }
            Vector<Annotation> m = new Vector<Annotation>();
            for (int k = 0; k < keyEntityMentions.size(); ++k) {
                Annotation keyMention = (Annotation)keyEntityMentions.get(k);
                Annotation responseMention = (Annotation)mentionMap.get(keyMention);
                m.add(responseMention);
            }
            responseEntity = new Annotation("entity", keyEntity.span(), new FeatureSet("mentions", m, "status", "key"));
            response.addAnnotation(responseEntity);
            different = true;
        }
        for (int j = 0; j < responseEntities.size(); ++j) {
            Annotation responseEntity = responseEntities.get(j);
            if (responseEntity.get("status") != null) continue;
            responseEntity.attributes().put("status", "response");
            different = true;
        }
        if (different) {
            Annotation entitiesDiffer = new Annotation("entitiesDiffer", new Span(0, 0), null);
            response.addAnnotation(entitiesDiffer);
        }
    }

    public static void compareCollections(DocumentCollection response, DocumentCollection key) {
        int keySize;
        int responseSize = response.size();
        if (responseSize != (keySize = key.size())) {
            System.out.println("CorefCompare.compareCollections:  collections of different sizes, can't compare.");
            return;
        }
        for (int i = 0; i < keySize; ++i) {
            CorefCompare.compareDocuments(response.get(i), key.get(i));
        }
    }
}

