/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class CorefFilter {
    private static HashMap idToMention;
    private static HashMap mentionToEntity;

    public static void buildEntitiesFromMentions(Document doc) {
        Vector<Annotation> mentionList;
        HashMap<Object, Vector<Annotation>> entityIdToMentions = new HashMap<Object, Vector<Annotation>>();
        Vector<Annotation> mentions = doc.annotationsOfType("mention");
        for (int i = 0; i < mentions.size(); ++i) {
            Annotation mention = mentions.get(i);
            Object entityId = mention.get("entity");
            if (entityId == null) {
                System.err.println("CorefEval.buildEntities:  mention annotation without entity id");
                continue;
            }
            mentionList = (Vector<Annotation>)entityIdToMentions.get(entityId);
            if (mentionList == null) {
                mentionList = new Vector<Annotation>();
            }
            mentionList.add(mention);
            entityIdToMentions.put(entityId, mentionList);
        }
        Set entityIds = entityIdToMentions.keySet();
        for (Object entityId : entityIds) {
            mentionList = (Vector)entityIdToMentions.get(entityId);
            Annotation firstMention = (Annotation)mentionList.get(0);
            doc.annotate("entity", firstMention.span(), new FeatureSet("mentions", mentionList));
        }
    }

    public static void buildEntitiesFromLinkedMentions(Document doc) {
        int i;
        Vector<Annotation> corefs = doc.annotationsOfType("coref");
        if (corefs == null) {
            return;
        }
        idToMention = new HashMap();
        for (i = 0; i < corefs.size(); ++i) {
            Annotation coref = corefs.get(i);
            Object id = coref.get("id");
            if (id == null) {
                System.err.println("(buildEntitiesFromRefs) coref annotation without id");
                continue;
            }
            idToMention.put(id, coref);
        }
        mentionToEntity = new HashMap();
        for (i = 0; i < corefs.size(); ++i) {
            Annotation mention = corefs.get(i);
            CorefFilter.mentionToEntity(mention, doc, 0);
        }
    }

    private static Annotation mentionToEntity(Annotation mention, Document doc, int level) {
        if (level > 100) {
            System.err.println("(mentionToEntity) loop of REF pointers");
            return null;
        }
        Annotation entity = (Annotation)mentionToEntity.get(mention);
        if (entity != null) {
            return entity;
        }
        String ref = (String)mention.get("ref");
        if (ref == null) {
            Vector<Annotation> v = new Vector<Annotation>();
            v.add(mention);
            entity = new Annotation("entity", mention.span(), new FeatureSet("mentions", v));
            doc.addAnnotation(entity);
        } else {
            Annotation referent = (Annotation)idToMention.get(ref);
            if (referent == null) {
                System.err.println("(mentionToEntity) undefined REF pointer" + ref);
            }
            entity = CorefFilter.mentionToEntity(referent, doc, level + 1);
            Vector v = (Vector)entity.get("mentions");
            v.add(mention);
        }
        mentionToEntity.put(mention, entity);
        return entity;
    }

    public static void buildMentionsFromEntities(Document doc) {
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        for (int i = 0; i < entities.size(); ++i) {
            Annotation entity = entities.get(i);
            Integer entityID = new Integer(i);
            Vector mentions = (Vector)entity.get("mentions");
            for (int j = 0; j < mentions.size(); ++j) {
                Annotation mention = (Annotation)mentions.get(j);
                Annotation mentionHead = Resolve.getHeadC(mention);
                if (mentionHead.type() != "mention") {
                    mentionHead = new Annotation("mention", mentionHead.span(), null);
                    doc.addAnnotation(mentionHead);
                }
                mentionHead.put("entity", entityID);
            }
        }
    }

    public static void buildLinkedMentionsFromEntities(Document doc) {
        int mentionID = 0;
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        for (int i = 0; i < entities.size(); ++i) {
            Annotation entity = entities.get(i);
            Vector mentions = (Vector)entity.get("mentions");
            int antecedent = 0;
            for (int j = 0; j < mentions.size(); ++j) {
                Annotation mention = (Annotation)mentions.get(j);
                Annotation mentionHead = Resolve.getHeadC(mention);
                if (mentionHead.type() != "COREF") {
                    mentionHead = new Annotation("COREF", mentionHead.span(), null);
                    doc.addAnnotation(mentionHead);
                }
                mentionHead.put("ID", new Integer(++mentionID));
                if (antecedent > 0) {
                    mentionHead.put("REF", new Integer(antecedent));
                }
                antecedent = mentionID;
            }
        }
    }
}

