/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.chunk.Chunker;
import edu.nyu.jet.refres.CorefFilter;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import java.io.IOException;

public class CorefWriter {
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String collection = "../coref/texts/trainingTexts.txt";
    static final String outCollection = "../coref/sysout/trainingTexts.txt";
    static final String dictFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/EDT type dict.txt";

    public static void main(String[] args) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ME ace.properties");
        Ace.useParser = false;
        Chunker.loadModel();
        EDTtype.readTypeDict(dictFile);
        DocumentCollection col = new DocumentCollection(collection);
        col.open();
        for (int docCount = 0; docCount < col.size(); ++docCount) {
            ExternalDocument doc = col.get(docCount);
            System.out.println("\nProcessing document " + docCount + ": " + doc.fileName());
            doc.open();
            Ace.monocase = Ace.allLowerCase(doc);
            Control.processDocument(doc, null, docCount == 0, docCount);
            CorefFilter.buildLinkedMentionsFromEntities(doc);
            doc.setSGMLtags(new String[]{"COREF"});
        }
        col.saveAs(outCollection);
    }
}

