/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.refres.CorefFilter;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.View;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class EntityView
extends View {
    private Object[] entities;

    public EntityView(Document doc, int docNo) {
        this.document = doc;
        try {
            Vector<Annotation> v = this.document.annotationsOfType("entity");
            if (v == null || v.size() == 0) {
                System.err.println(" (EntityView) No entities to display.");
                return;
            }
            Annotation.sort(v);
            Collections.reverse(v);
            this.entities = v.toArray();
            Object[] entityDescriptions = new String[this.entities.length];
            for (int i = 0; i < this.entities.length; ++i) {
                entityDescriptions[i] = this.entityDescription((Annotation)this.entities[i]);
            }
            this.jbInit(entityDescriptions, "Entities");
            this.setTitle("Entities for Document " + docNo);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            int n = (screenSize.width - frameSize.width) / 30;
            this.setLocation(30 * (docNo % n) + 15, 20 * (docNo % n) + 10);
            this.setVisible(true);
            this.jSplitPaneTop.setDividerLocation(0.3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jListValueChanged(ListSelectionEvent evt) {
        int i;
        if (evt.getValueIsAdjusting()) {
            return;
        }
        JList theList = (JList)evt.getSource();
        for (i = 0; i < this.entities.length; ++i) {
            if (theList.isSelectedIndex(i)) continue;
            this.bleachEntity((Annotation)this.entities[i]);
        }
        this.jTextPane.clearLines();
        for (i = 0; i < this.entities.length; ++i) {
            if (!theList.isSelectedIndex(i)) continue;
            this.highlightEntity((Annotation)this.entities[i]);
        }
    }

    private void highlightEntity(Annotation entity) {
        SimpleAttributeSet highlighted = new SimpleAttributeSet();
        StyleConstants.setBackground(highlighted, Color.pink);
        StyleConstants.setBold(highlighted, true);
        this.setEntityAttribute(entity, highlighted);
        Vector mentions = this.mentionsOfEntity(entity);
        Color color = Color.BLUE;
        if (entity.get("status") == "response") {
            color = Color.RED;
        }
        if (entity.get("status") == "key") {
            color = Color.GREEN;
        }
        this.connectMentions(mentions, color);
    }

    private void bleachEntity(Annotation entity) {
        SimpleAttributeSet bleached = new SimpleAttributeSet();
        this.setEntityAttribute(entity, bleached);
    }

    private String entityDescription(Annotation entity) {
        String id = (String)entity.get("id");
        String descriptor = (String)entity.get("descriptor");
        String status = (String)entity.get("status");
        String statusSuffix = "";
        if (status == "key") {
            statusSuffix = "[K]";
        } else if (status == "response") {
            statusSuffix = "[R]";
        }
        if (id != null || descriptor != null) {
            return id + ": " + descriptor + statusSuffix;
        }
        return Resolve.normalizeName(this.document.text(entity)) + statusSuffix;
    }

    private Vector mentionsOfEntity(Annotation entity) {
        return (Vector)entity.get("mentions");
    }

    private void setEntityAttribute(Annotation entity, SimpleAttributeSet atrSet) {
        Vector mentions = this.mentionsOfEntity(entity);
        if (mentions == null) {
            System.out.println("EntityView:  entity has no mentions:");
            System.out.println("            " + entity);
            return;
        }
        this.setAnnotationAttribute(mentions, atrSet);
    }

    private void connectMentions(Vector mentions, Color color) {
        Point lastPoint = null;
        for (int i = 0; i < mentions.size(); ++i) {
            Point p;
            Annotation mention = (Annotation)mentions.get(i);
            int start = mention.span().start();
            try {
                Rectangle r = this.jTextPane.modelToView(start);
                p = r.getLocation();
            }
            catch (BadLocationException e) {
                return;
            }
            if (i > 0) {
                this.jTextPane.addLine(lastPoint, p, color);
            }
            lastPoint = p;
        }
    }

    public static void task(String[] args) {
        String encoding = null;
        String file = null;
        if (args.length == 4 && args[1].equals("-encoding")) {
            encoding = args[2];
            file = args[3];
        } else if (args.length == 2) {
            file = args[1];
        } else {
            System.out.println("CorefView requires 1 argument: jet -CorefView [-encoding e] <document>");
            System.exit(1);
        }
        if (encoding != null && !JetTest.setEncoding(encoding)) {
            System.exit(1);
        }
        ExternalDocument doc = new ExternalDocument("sgml", file);
        doc.setAllTags(true);
        doc.open();
        CorefFilter.buildEntitiesFromMentions(doc);
        new EntityView(doc, 0);
    }
}

