/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hobbs {
    private static boolean hobbsTrace = false;
    static final int SAME_SENTENCE = 9998;

    public static int distance(Document doc, Annotation m1, Annotation m2, ArrayList<Annotation> antecedents, Vector sentences) {
        Span span1 = m1.span();
        Span span2 = m2.span();
        int isent1 = -1;
        int isent2 = -1;
        Annotation sent1 = null;
        Annotation sent2 = null;
        for (int i = 0; i < sentences.size(); ++i) {
            Annotation sentence = (Annotation)sentences.get(i);
            Span span = sentence.span();
            if (span1.within(span)) {
                isent1 = i;
                sent1 = sentence;
            }
            if (!span2.within(span)) continue;
            isent2 = i;
            sent2 = sentence;
        }
        if (isent1 < 0 || isent2 < 0) {
            System.out.println("Hobbs.distance:  cannot find containing sentences.");
            return 99999;
        }
        Annotation parse1 = (Annotation)sent1.get("parse");
        Annotation parse2 = (Annotation)sent2.get("parse");
        if (isent1 == isent2) {
            int distance;
            if (parse2 != null) {
                distance = antecedents.indexOf(m1);
                if (distance < 0) {
                    return 9998;
                }
            } else {
                distance = Hobbs.mentionCount(doc, m1.start(), m2.start());
            }
            return distance;
        }
        int d1 = parse1 != null ? Hobbs.bfsCount(parse1, m1) : Hobbs.mentionCount(doc, sent1.start(), m1.start());
        int d2 = 0;
        for (int i = isent1 + 1; i < isent2; ++i) {
            Annotation sentence = (Annotation)sentences.get(i);
            Annotation parse = (Annotation)sentence.get("parse");
            if (parse != null) {
                d2 += Hobbs.bfsCount(parse, null);
                continue;
            }
            d2 += Hobbs.mentionCount(doc, sentence.start(), sentence.end());
        }
        int d3 = parse2 != null ? antecedents.size() : Hobbs.mentionCount(doc, sent2.start(), m2.start());
        return d1 + d2 + d3;
    }

    private static int bfsCount(Annotation root, Annotation target) {
        LinkedList<Annotation> q = new LinkedList<Annotation>();
        int count = 0;
        q.add(root);
        while (q.size() > 0) {
            Annotation[] children;
            Annotation a = (Annotation)q.removeFirst();
            if (a == target) {
                return count;
            }
            if (Hobbs.hobbsAntecedent(a)) {
                ++count;
            }
            if ((children = ParseTreeNode.children(a)) == null) continue;
            for (int ichild = 0; ichild < children.length; ++ichild) {
                if (children[ichild] == null) continue;
                q.add(children[ichild]);
            }
        }
        if (target != null) {
            System.out.println("Hobbs.bfs:  target (" + target + ") not underneath root (" + root + ").");
        }
        return count;
    }

    static int mentionCount(Document doc, int start, int end) {
        int count = 0;
        for (int posn = start; posn < end; ++posn) {
            Vector<Annotation> anns = doc.annotationsAt(posn, "constit");
            if (anns == null) continue;
            for (int i = 0; i < anns.size(); ++i) {
                Annotation ann = anns.get(i);
                if (ann.get("mention") == null) continue;
                ++count;
            }
        }
        return count;
    }

    static ArrayList<Annotation> collectAntecedents(Annotation node, HashMap<Annotation, Annotation> parents, Document doc) {
        if (hobbsTrace) {
            System.out.println("Collecting antecedents of " + doc.text(node));
        }
        ArrayList<Annotation> antecedents = new ArrayList<Annotation>();
        ArrayList<Annotation> path = new ArrayList<Annotation>();
        Annotation x = Hobbs.ascendToNpOrS(node, path, parents);
        if (x == null) {
            return antecedents;
        }
        Hobbs.bfs(x, antecedents, path, node, doc, true, parents);
        while ((x = Hobbs.ascendToNpOrS(x, path, parents)) != null) {
            Hobbs.bfs(x, antecedents, path, node, doc, false, parents);
        }
        return antecedents;
    }

    private static void bfs(Annotation root, ArrayList<Annotation> antecedents, ArrayList<Annotation> path, Annotation anaphor, Document doc, boolean requireInterveningNPS, HashMap<Annotation, Annotation> parents) {
        LinkedList<Annotation> q = new LinkedList<Annotation>();
        q.add(root);
        block0: while (!q.isEmpty()) {
            Annotation[] children;
            Annotation a = (Annotation)q.removeFirst();
            if (!(path.contains(a) || !Hobbs.hobbsAntecedent(a) || antecedents.contains(a) || requireInterveningNPS && !Hobbs.interveningNPS(root, a, parents))) {
                antecedents.add(a);
                if (hobbsTrace) {
                    System.out.println("    antecedent: " + doc.text(a));
                }
            }
            if (a == anaphor || (children = ParseTreeNode.children(a)) == null) continue;
            for (Annotation child : children) {
                if (child == null) continue;
                q.add(child);
                if (path.contains(child)) continue block0;
            }
        }
    }

    private static boolean interveningNPS(Annotation x, Annotation y, HashMap<Annotation, Annotation> parents) {
        if (y == x) {
            return false;
        }
        do {
            if ((y = parents.get(y)) == null) {
                return false;
            }
            if (y != x) continue;
            return false;
        } while (y.get("cat") != "np" || y.get("cat") == "s");
        return true;
    }

    private static Annotation ascendToNpOrS(Annotation node, ArrayList<Annotation> path, HashMap<Annotation, Annotation> parents) {
        path.add(node);
        Annotation x = parents.get(node);
        while (x != null && x.get("cat") != "np" && x.get("cat") != "s") {
            path.add(x);
            x = parents.get(x);
        }
        return x;
    }

    private static boolean hobbsAntecedent(Annotation node) {
        return node != null && node.get("mention") != null;
    }

    public static boolean sameSimplex(Annotation x, Annotation y, HashMap<Annotation, Annotation> parents) {
        while (x != null && x.get("cat") != "s") {
            x = parents.get(x);
        }
        while (y != null && y.get("cat") != "s") {
            y = parents.get(y);
        }
        return x != null && x == y;
    }
}

