/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.Console;
import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.MaxEntModel;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.Datum;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.aceJet.PerfectAce;
import edu.nyu.jet.hmm.HMMNameTagger;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.refres.Hobbs;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxEntResolve {
    static Vector clauses;
    static Vector entities;
    public static SentenceSet sentenceSet;
    static boolean fullParse;
    public static boolean linkAppositesAndPredComps;
    public static boolean nameTypeMatch;
    private static Annotation speakerEntity;
    static HashMap mentionToEntity;
    static HashMap syntacticAntecedent;
    public static boolean trace;
    static Annotation parseTree;
    static HashMap<Annotation, Annotation> parents;
    static int pronounDefiniteNonCorefSuccessCount;
    static int pronounDefiniteNonCorefFailureCount;
    static String trainingDirectory1;
    static String trainingCollection1;
    static String trainingDirectory;
    static String trainingCollection;
    static String trainingDirectoryParses;
    static String trainingCollectionParses;
    static boolean useParser;
    static MaxEntModel pronounModel;

    public static void references(Document doc, Span span) {
        int start;
        Vector<Annotation> sentAnns;
        trace = Resolve.trace;
        if (pronounModel == null) {
            pronounModel = new MaxEntModel();
            String modelFile = JetTest.getConfigFile("Resolve.MaxEntModel.filename");
            if (modelFile == null) {
                System.err.println("No Resolve.MaxEntModel.filename specified");
                System.exit(1);
            }
            pronounModel.loadModel(modelFile);
        }
        if ((sentAnns = doc.annotationsAt(start = span.start(), "sentence")) != null && sentAnns.size() > 0) {
            Annotation sentAnn = sentAnns.get(0);
            fullParse = sentAnn.get("parse") != null;
            parseTree = (Annotation)sentAnn.get("parse");
            parents = SynFun.collectParents(parseTree);
        } else {
            fullParse = false;
        }
        Resolve.fullParse = fullParse;
        Vector<Annotation> mentions = Resolve.gatherMentions(doc, span);
        Vector<Annotation> clauses = Resolve.gatherClauses(doc, span);
        MaxEntResolve.references(doc, span, mentions, clauses);
    }

    public static void references(Document doc, Span span, Vector mentions, Vector clauses) {
        entities = doc.annotationsOfType("entity");
        if (entities == null) {
            entities = new Vector();
            speakerEntity = null;
        }
        mentionToEntity = new HashMap();
        if (trace) {
            Console.println("Resolving references");
        }
        Resolve.sentenceSet = sentenceSet = new SentenceSet(doc);
        Resolve.markMentions(mentions);
        syntacticAntecedent = Resolve.gatherSyntacticCoref(doc, mentions, clauses);
        for (int i = 0; i < mentions.size(); ++i) {
            Annotation mention = (Annotation)mentions.get(i);
            MaxEntResolve.resolveMention(doc, mention);
        }
        Resolve.updateEvents(doc, span, mentionToEntity);
    }

    public static void train(String directory, String fileList, int limit) throws IOException {
        String currentDocPath;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDocPath = reader.readLine()) != null) {
            System.out.println("\nProcessing file " + ++docCount + ": " + currentDocPath);
            String textFile = directory + "/" + currentDocPath;
            ExternalDocument doc = new ExternalDocument("sgml", textFile);
            doc.setAllTags(true);
            doc.open();
            Control.processDocument(doc, null, false, 0);
            Ace.tagReciprocalRelations(doc);
            MaxEntResolve.train(doc);
            if (docCount < limit) continue;
            break;
        }
    }

    public static void train(Document doc) {
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        if (sentences == null) {
            System.err.println("Cannot train reference resolution:  no sentences.");
            return;
        }
        entities = new Vector();
        mentionToEntity = new HashMap();
        Resolve.sentenceSet = sentenceSet = new SentenceSet(doc);
        for (int i = 0; i < sentences.size(); ++i) {
            Annotation sentence = sentences.get(i);
            Resolve.fullParse = fullParse = sentence.get("parse") != null;
            parseTree = (Annotation)sentence.get("parse");
            parents = SynFun.collectParents(parseTree);
            Vector<Annotation> mentions = Resolve.gatherMentions(doc, sentence.span());
            Vector<Annotation> clauses = Resolve.gatherClauses(doc, sentence.span());
            Resolve.markMentions(mentions);
            syntacticAntecedent = Resolve.gatherSyntacticCoref(doc, mentions, clauses);
            for (int j = 0; j < mentions.size(); ++j) {
                Annotation mention = mentions.get(j);
                MaxEntResolve.trainOnMention(doc, mention);
            }
        }
    }

    public static void trainOnMention(Document doc, Annotation mention) {
        ArrayList<Annotation> antecedents = null;
        if (fullParse) {
            antecedents = Hobbs.collectAntecedents(mention, parents, doc);
        }
        Annotation headC = Resolve.getHeadC(mention);
        String cat = (String)headC.get("cat");
        Vector<Annotation> corefs = doc.annotationsEndingAt(headC.end(), "mention");
        if (corefs == null || corefs.isEmpty()) {
            return;
        }
        Annotation coref = corefs.get(0);
        String eid = (String)coref.get("entity");
        if (eid == null) {
            System.err.println("mention tag for '" + doc.text(headC) + "' has no entity feature");
            return;
        }
        int mentionPosition = mention.span().start();
        String mentionHead = SynFun.getHead(doc, mention);
        if (mentionHead == null) {
            return;
        }
        String[] mentionName = Resolve.getNameTokens(doc, mention);
        boolean isNameMention = mentionName != null;
        boolean properAdjective = false;
        if (isNameMention) {
            boolean notNP;
            boolean bl = notNP = mention.get("cat") != "np";
            if (notNP && Ace.gazetteer.isNationality(mentionName)) {
                properAdjective = true;
            }
            mentionName = Resolve.normalizeGazName(mentionName, notNP, trace);
        }
        Annotation bestEntity = null;
        for (int ie = 0; ie < entities.size(); ++ie) {
            boolean dissimilarity = false;
            Annotation ent = (Annotation)entities.elementAt(ie);
            boolean match = eid.equals(ent.get("eid"));
            if (!isNameMention) {
                if (cat == "pro" || cat == "det" || cat == "np") {
                    String pronoun = mentionHead.toLowerCase().intern();
                    MaxEntResolve.trainPronounResolver(doc, mention, pronoun, ent, match, fullParse, antecedents);
                } else if (cat != "n" && cat != "adj" && cat != "ven" && cat != "v" && cat != "tv" && cat != "hyphword" && cat != "title" && cat != "nnp" && cat != "nnps" && cat != "adv" && cat != "$" && cat != "q") {
                    System.err.println("Unexpected head cat " + cat + " for " + doc.text(mention));
                    break;
                }
            }
            if (!match) continue;
            bestEntity = ent;
        }
        if (bestEntity == null) {
            bestEntity = Resolve.createNewEntity(doc, mention, mentionHead, properAdjective, entities);
            bestEntity.put("eid", eid);
        } else {
            if (bestEntity.get("properAdjective") != null && !properAdjective) {
                bestEntity.put("properAdjective", null);
            }
            if (trace) {
                Console.println("Resolving " + doc.text(mention) + " to " + doc.text(bestEntity));
            }
        }
        Resolve.addMentionToEntity(doc, mention, mentionHead, mentionName, bestEntity, mentionToEntity);
    }

    private static void trainPronounResolver(Document doc, Annotation mention, String pronoun, Annotation entity, boolean match, boolean parse, ArrayList<Annotation> antecedents) {
        boolean reflexive = Resolve.reflexives.contains(pronoun);
        String nominativeForm = Resolve.nominativeFormOf(pronoun);
        if (nominativeForm != "he" && nominativeForm != "she" && nominativeForm != "it" && nominativeForm != "they") {
            return;
        }
        if (MaxEntResolve.pronounDefiniteNonCoref(nominativeForm, entity)) {
            if (match) {
                System.err.println("Error in pronounDefiniteNonCoref, pronoun = " + pronoun + ", antecedent = " + doc.text(entity));
                ++pronounDefiniteNonCorefFailureCount;
            } else {
                ++pronounDefiniteNonCorefSuccessCount;
            }
            return;
        }
        Datum d = MaxEntResolve.pronounFeatures(doc, mention, nominativeForm, reflexive, entity, parse, antecedents);
        d.setOutcome(match ? "T" : "F");
        int distance = Resolve.distance(doc, entity, mention, parse, antecedents);
        pronounModel.addEvent(d);
    }

    private static boolean pronounDefiniteNonCoref(String nominativeForm, Annotation ent) {
        String nameType = (String)ent.get("nameType");
        if (nameType != null) {
            nameType = nameType.toUpperCase().intern();
        }
        String AceTypeSubtype = (String)ent.get("ACEtype");
        boolean match = nominativeForm == "he" ? ent.get("human") != null && ent.get("number") == "singular" && ent.get("gender") != "female" : (nominativeForm == "she" ? ent.get("human") != null && ent.get("number") == "singular" && ent.get("gender") != "male" : (nominativeForm == "it" ? ent.get("human") == null && ent.get("number") == "singular" : ent.get("number") == "plural" || nameType == "ORGANIZATION" || nameType == "GPE" || AceTypeSubtype != null && AceTypeSubtype.equals("PERSON:Group")));
        return !match;
    }

    private static Datum pronounFeatures(Document doc, Annotation mention, String pronoun, boolean reflexive, Annotation entity, boolean parse, ArrayList<Annotation> antecedents) {
        Datum d = new Datum();
        Annotation lastMention = (Annotation)entity.get("lastMention");
        String lastCat = (String)lastMention.get("cat");
        if (reflexive) {
            boolean sameSimplex = Hobbs.sameSimplex(lastMention, mention, parents);
            if (parse && sameSimplex) {
                d.addFV("reflexdist", "sameSimplex");
            } else {
                int distance = Resolve.distance(doc, entity, mention, parse, antecedents);
                if (distance == 9998) {
                    d.addFV("reflexdist", "sameSent");
                } else {
                    d.addFV("reflexdist", Math.min(distance / (useParser ? 1 : 25), 40) + "");
                }
            }
        } else {
            int distance = Resolve.distance(doc, entity, mention, parse, antecedents);
            if (distance == 9998) {
                d.addFV("dist", "sameSent");
            } else {
                d.addFV("dist", Math.min(distance / (useParser ? 1 : 25), 40) + "");
            }
            Annotation anteHeadC = Resolve.getHeadC(lastMention);
            String anteHead = SynFun.getHead(doc, anteHeadC);
            d.addFV("heads", anteHead + ":" + pronoun);
            if (lastMention.get("subject-1") != null) {
                d.addF("subject");
            }
            d.addFV("lastCat", lastCat);
        }
        int priorMentions = ((Vector)entity.get("mentions")).size();
        d.addFV("prior", Math.min(priorMentions, 10) + "");
        return d;
    }

    private static void resolveMention(Document doc, Annotation mention) {
        Vector<Annotation> names;
        ArrayList<Annotation> antecedents = null;
        if (fullParse) {
            antecedents = Hobbs.collectAntecedents(mention, parents, doc);
        }
        Annotation headC = Resolve.getHeadC(mention);
        String cat = (String)headC.get("cat");
        int mentionPosition = mention.span().start();
        String mentionHead = SynFun.getHead(doc, mention);
        if (mentionHead.equals("?") && cat.equalsIgnoreCase("name") && (names = doc.annotationsAt(mentionPosition, "ENAMEX")) != null && names.size() >= 1) {
            Annotation enamex = names.firstElement();
            FeatureSet atts = enamex.attributes();
            mentionHead = (String)atts.get("TYPE");
        }
        if (mentionHead == null) {
            return;
        }
        String[] mentionName = Resolve.getNameTokens(doc, mention);
        boolean isNameMention = mentionName != null;
        boolean properAdjective = false;
        if (isNameMention) {
            boolean notNP;
            boolean bl = notNP = mention.get("cat") != "np";
            if (notNP && Ace.gazetteer.isNationality(mentionName)) {
                properAdjective = true;
            }
            mentionName = Resolve.normalizeGazName(mentionName, notNP, trace);
        }
        Annotation bestEntity = null;
        float bestProbability = 0.0f;
        if (syntacticAntecedent.containsKey(mention) && !Ace.perfectEntities) {
            Annotation antecedent;
            if (trace) {
                System.out.println("Using syntactically-determined antecedent.");
            }
            if ((bestEntity = (Annotation)mentionToEntity.get(antecedent = (Annotation)syntacticAntecedent.get(mention))) == null) {
                System.err.println("Resolve:  syntactic antecedent not in entity");
                System.err.println("          mention:    " + doc.text(mention));
                System.err.println("          antecedent: " + doc.text(antecedent));
            } else {
                bestProbability = 1.0f;
            }
        } else if ((cat == "pro" || cat == "det") && Resolve.nominativeFormOf(mentionHead.toLowerCase()).equals("i") && speakerEntity != null) {
            bestEntity = speakerEntity;
            bestProbability = 1.0f;
        } else {
            for (int ie = 0; ie < entities.size(); ++ie) {
                float prob;
                Annotation ent = (Annotation)entities.elementAt(ie);
                if (Ace.perfectMentions & !Ace.perfectEntities) {
                    String eTypeSubtype = (String)ent.get("typeSubtype");
                    String typeSubtype = PerfectAce.getTypeSubtype(headC);
                    if (eTypeSubtype != null && typeSubtype != null && !typeSubtype.equals("") && !typeSubtype.equals(eTypeSubtype)) continue;
                }
                if (Ace.perfectEntities) {
                    String eid = PerfectAce.getEntityID(headC);
                    boolean match = ent.get("entityID") != null && ent.get("entityID").equals(eid);
                    prob = match ? 1.0f : 0.0f;
                } else if (isNameMention) {
                    int dissimilarity = Resolve.matchName(mentionName, mentionHead, ent);
                    boolean match = dissimilarity >= 0;
                    prob = match ? 1000.0f / (float)(1000 + Resolve.distance(doc, ent, mention, fullParse, antecedents)) : 0.0f;
                } else {
                    if (ent == speakerEntity) continue;
                    if (cat == "pro" || cat == "det" || cat == "np") {
                        String pronoun = mentionHead.toLowerCase().intern();
                        prob = MaxEntResolve.matchPronoun(doc, mention, pronoun, ent, fullParse, antecedents);
                    } else if (cat == "n" || cat == "adj" || cat == "ven" || cat == "v" || cat == "tv" || cat == "hyphword" || cat == "title" || cat == "nnp" || cat == "nnps" || cat == "adv") {
                        boolean match = Resolve.matchNom(doc, mention, ent);
                        prob = match ? 1000.0f / (float)(1000 + Resolve.distance(doc, ent, mention, fullParse, antecedents)) : 0.0f;
                    } else if (cat == "$") {
                        prob = 0.0f;
                    } else if (cat == "q") {
                        prob = 0.0f;
                    } else {
                        System.err.println("Unexpected head cat " + cat + " for " + doc.text(mention));
                        prob = 0.0f;
                        break;
                    }
                }
                if (!(prob > bestProbability)) continue;
                bestProbability = prob;
                bestEntity = ent;
            }
        }
        if ((double)bestProbability < 0.01) {
            bestEntity = Resolve.createNewEntity(doc, mention, mentionHead, properAdjective, entities);
        } else {
            if (bestEntity.get("properAdjective") != null && !properAdjective) {
                bestEntity.put("properAdjective", null);
            }
            if (trace) {
                Console.println("Resolving " + doc.text(mention) + " to " + doc.text(bestEntity));
            }
        }
        Resolve.addMentionToEntity(doc, mention, mentionHead, mentionName, bestEntity, mentionToEntity);
        Span span = mention.span();
        if (HMMNameTagger.inZone(doc, span, "POSTER") || HMMNameTagger.inZone(doc, span, "SPEAKER")) {
            speakerEntity = bestEntity;
        }
    }

    public static float matchPronoun(Document doc, Annotation anaphor, String pronoun, Annotation entity, boolean parse, ArrayList<Annotation> antecedents) {
        if (entity.get("properAdjective") != null) {
            return 0.0f;
        }
        String nominativeForm = Resolve.nominativeFormOf(pronoun);
        if (nominativeForm == "I" || nominativeForm == "i" || nominativeForm == "we" || nominativeForm == "you") {
            return nominativeForm.equals(entity.get("head")) ? 1.0f : 0.0f;
        }
        if (nominativeForm != "he" && nominativeForm != "she" && nominativeForm != "it" && nominativeForm != "they") {
            return 0.0f;
        }
        if (MaxEntResolve.pronounDefiniteNonCoref(nominativeForm, entity)) {
            return 0.0f;
        }
        boolean reflexive = Resolve.reflexives.contains(pronoun);
        Datum d = MaxEntResolve.pronounFeatures(doc, anaphor, nominativeForm, reflexive, entity, parse, antecedents);
        return (float)pronounModel.prob(d, "T");
    }

    public static void main(String[] args) throws IOException {
        if (useParser) {
            JetTest.initializeFromConfig("props/ace 05 use parses noresolve.properties");
        } else {
            JetTest.initializeFromConfig("props/ME ace 05 noresolve.properties");
        }
        pronounModel = useParser ? new MaxEntModel("data/pronounCorefFeaturesP.txt", "data/pronounCorefModelP.txt") : new MaxEntModel("data/pronounCorefFeatures.txt", "data/pronounCorefModel.txt");
        EDTtype.readTypeDict();
        Resolve.ACE = true;
        if (useParser) {
            MaxEntResolve.train(trainingDirectoryParses, trainingCollectionParses, 300);
        } else {
            MaxEntResolve.train(trainingDirectory, trainingCollection, 300);
        }
        pronounModel.buildModel();
        pronounModel.saveModel();
        System.out.println("pronounDefiniteNonCorefSuccessCount = " + pronounDefiniteNonCorefSuccessCount);
        System.out.println("pronounDefiniteNonCorefFailureCount = " + pronounDefiniteNonCorefFailureCount);
    }

    static {
        fullParse = false;
        linkAppositesAndPredComps = true;
        nameTypeMatch = false;
        speakerEntity = null;
        trace = false;
        parseTree = null;
        parents = null;
        pronounDefiniteNonCorefSuccessCount = 0;
        pronounDefiniteNonCorefFailureCount = 0;
        trainingDirectory1 = "coref";
        trainingCollection1 = "coref/training nwire coref.txt";
        trainingDirectory = "coref/2005-co";
        trainingCollection = "coref/2005-co/bcbnnwCo.txt";
        trainingDirectoryParses = "coref/2005-co-parsed";
        trainingCollectionParses = "coref/2005-co/bcbnnwCo.txt";
        useParser = true;
    }
}

