/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.Console;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.aceJet.PerfectAce;
import edu.nyu.jet.concepts.ConceptHierarchy;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.refres.Hobbs;
import edu.nyu.jet.refres.MaxEntResolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolve {
    static Vector<Annotation> clauses;
    static Vector<Annotation> entities;
    public static SentenceSet sentenceSet;
    static boolean fullParse;
    public static boolean linkAppositesAndPredComps;
    public static boolean nameTypeMatch;
    static HashMap<Annotation, Annotation> mentionToEntity;
    static HashMap<Annotation, Annotation> syntacticAntecedent;
    public static boolean trace;
    static Annotation parseTree;
    static HashMap<Annotation, Annotation> parents;
    static HashSet<String> pronounsNotHandled;
    public static boolean useMaxEnt;
    public static boolean ACE;
    private static final String[] maleHeads;
    private static final String[] femaleHeads;
    private static HashMap<String, String> genderDict;
    private static final String[] definiteDets;
    private static final String[] indefiniteDets;
    private static final String[] genericPersonTerms;
    private static final String[] genericOrganizationTerms;
    private static final String[] genericCountryTerms;
    private static final String[] genericStateTerms;
    private static final String[] genericGpeTerms;
    private static final String[] genericLocationTerms;
    private static final String[] genericFacilityTerms;
    private static HashMap<String, String> nominative;
    static HashSet<String> reflexives;

    public static void references(Document doc, Span span) {
        if (useMaxEnt) {
            MaxEntResolve.references(doc, span);
            return;
        }
        int start = span.start();
        Vector<Annotation> sentAnns = doc.annotationsAt(start, "sentence");
        if (sentAnns != null && sentAnns.size() > 0) {
            Annotation sentAnn = sentAnns.get(0);
            fullParse = sentAnn.get("parse") != null;
            parseTree = (Annotation)sentAnn.get("parse");
            parents = SynFun.collectParents(parseTree);
        } else {
            fullParse = false;
        }
        Vector<Annotation> mentions = Resolve.gatherMentions(doc, span);
        Vector<Annotation> clauses = Resolve.gatherClauses(doc, span);
        Resolve.references(doc, span, mentions, clauses);
    }

    public static void references(Document doc, Span span, Vector<Annotation> mentions, Vector<Annotation> clauses) {
        entities = doc.annotationsOfType("entity");
        if (entities == null) {
            entities = new Vector();
        }
        mentionToEntity = new HashMap();
        if (trace) {
            Console.println("Resolving references");
        }
        sentenceSet = new SentenceSet(doc);
        Resolve.markMentions(mentions);
        syntacticAntecedent = Resolve.gatherSyntacticCoref(doc, mentions, clauses);
        pronounsNotHandled = new HashSet();
        for (int i = 0; i < mentions.size(); ++i) {
            Annotation mention = mentions.get(i);
            Resolve.resolveMention(doc, mention);
        }
        Resolve.updateEvents(doc, span, mentionToEntity);
    }

    public static Vector<Annotation> gatherMentions(Document doc, Span span) {
        Vector<Annotation> mentions = new Vector<Annotation>();
        Vector<Annotation> heads = new Vector<Annotation>();
        Set<Integer> nameTokens = null;
        nameTokens = Resolve.gatherNameTokens(doc, span);
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> constits = doc.annotationsAt(i, "constit");
            if (constits == null) continue;
            for (int j = 0; j < constits.size(); ++j) {
                String head;
                Annotation headC;
                Annotation ann = constits.elementAt(j);
                String cat = (String)ann.get("cat");
                if (!(cat != null && (cat.equals("ngroup") || cat.equals("np") && !Resolve.conjoinedNP(doc, ann) || cat.equals("det") && ann.get("tposs") == "t" || ACE && cat.equals("name") || ACE && AceDocument.ace2004 && cat.equals("title") || ACE && AceDocument.ace2004 && (cat.equals("n") || cat.equals("nnp") || cat.equals("nnps")) && !nameTokens.contains(i) || (ACE && fullParse || Ace.perfectMentions) && (cat.equals("whnp") || cat.equals("np-pro")) || Ace.perfectMentions && (cat.equals("adj") || cat.equals("adv")) && !nameTokens.contains(i)) && (headC = Resolve.getHeadC(ann)).get("cat") != "timex" && headC.get("cat") != "ordinal" && (Ace.perfectMentions || headC.get("cat") != "adv" && !"there".equalsIgnoreCase(head = SynFun.getHead(doc, ann))) && headC.get("cat") != "ving" && (!Ace.perfectMentions || PerfectAce.validMention(doc, headC, cat)))) continue;
                mentions.add(ann);
                Annotation immHeadC = (Annotation)ann.get("headC");
                if (immHeadC == null) continue;
                heads.add(immHeadC);
            }
        }
        mentions.removeAll(heads);
        return mentions;
    }

    private static Set<Integer> gatherNameTokens(Document doc, Span span) {
        HashSet<Integer> nameTokens = new HashSet<Integer>();
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> constits = doc.annotationsAt(i, "constit");
            if (constits == null) continue;
            block1: for (int j = 0; j < constits.size(); ++j) {
                Annotation ann = constits.elementAt(j);
                String cat = (String)ann.get("cat");
                if (cat != "name") continue;
                int posn = ann.start();
                while (posn < ann.end()) {
                    nameTokens.add(posn);
                    Annotation tok = doc.tokenAt(posn);
                    if (tok == null) continue block1;
                    posn = tok.span().end();
                }
            }
        }
        return nameTokens;
    }

    public static Vector<Annotation> gatherClauses(Document doc, Span span) {
        clauses = new Vector();
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> constits = doc.annotationsAt(i, "constit");
            if (constits == null) continue;
            for (int j = 0; j < constits.size(); ++j) {
                Annotation ann = constits.elementAt(j);
                String cat = (String)ann.get("cat");
                if (cat == null || !cat.equals("s") && !cat.equals("rn-wh") && !cat.equals("rn-vingo")) continue;
                clauses.add(ann);
            }
        }
        return clauses;
    }

    private static boolean conjoinedNP(Document doc, Annotation ann) {
        Annotation[] children = ParseTreeNode.children(ann);
        if (children == null || children.length != 3) {
            return false;
        }
        if (children[0] == null || children[1] == null || children[2] == null) {
            return false;
        }
        boolean answer = children[0].get("cat") == "np" && children[1].get("cat") == "cconj" && children[2].get("cat") == "np";
        return answer;
    }

    public static void markMentions(Vector mentions) {
        if (mentions == null) {
            return;
        }
        for (int i = 0; i < mentions.size(); ++i) {
            Annotation mention = (Annotation)mentions.get(i);
            mention.put("mention", "true");
        }
    }

    public static HashMap<Annotation, Annotation> gatherSyntacticCoref(Document doc, Vector<Annotation> mentions, Vector<Annotation> clauses) {
        HashMap<Annotation, Annotation> syntacticAntecedent = new HashMap<Annotation, Annotation>();
        Vector<Annotation> mentions2 = new Vector<Annotation>(mentions);
        for (Annotation mention : mentions2) {
            Annotation apposite;
            Annotation of;
            Annotation headC = Resolve.getHeadC(mention);
            String head = SynFun.getHead(doc, mention);
            Annotation ngHead = Resolve.getNgHead(mention);
            if (head == null) {
                System.err.println("No head for annotation " + mention + " over " + doc.text(mention));
                continue;
            }
            if (mention.get("preName") != null) {
                Annotation preName = (Annotation)mention.get("preName");
                Resolve.recordSyntacticCoref(preName, mention, doc, mentions, syntacticAntecedent);
            }
            String number = SynFun.getNumber(mention);
            if (head != null && (head.equals("city") || head.equals("state") || head.equals("county") || head.equals("village") || head.equals("town") || head.equals("island") || head.equals("port") || head.equals("province") || head.equals("district") || head.equals("region")) && (number == null || !number.equals("plural"))) {
                of = (Annotation)mention.get("of");
                Annotation nameMod = (Annotation)mention.get("nameMod");
                if (of != null && Resolve.isName(Resolve.getHeadC(of))) {
                    Resolve.recordSyntacticCoref(mention, of, doc, mentions, syntacticAntecedent);
                    if (trace) {
                        System.out.println("Found X of Y coref pair: " + doc.text(mention));
                    }
                } else if (nameMod != null) {
                    Resolve.recordSyntacticCoref(mention, nameMod, doc, mentions, syntacticAntecedent);
                    if (trace) {
                        System.out.println("Found nameMod X coref pair: " + doc.text(mention));
                    }
                }
            }
            if (head != null && (head.equals("all") || head.equals("both")) && (of = (Annotation)mention.get("of")) != null) {
                Resolve.recordSyntacticCoref(of, mention, doc, mentions, syntacticAntecedent);
                if (trace) {
                    System.out.println("Found X of Y coref pair: " + doc.text(mention));
                }
            }
            if (linkAppositesAndPredComps && mention.get("apposite") != null) {
                apposite = (Annotation)mention.get("apposite");
                if (nameTypeMatch && !Resolve.typeMatch(doc, mention, apposite)) continue;
                Resolve.recordSyntacticCoref(apposite, mention, doc, mentions, syntacticAntecedent);
                if (trace) {
                    System.out.println("Refres: found apposition coref pair: " + doc.text(mention));
                }
            }
            if (linkAppositesAndPredComps && mention.get("predComp") != null) {
                Annotation predComp = (Annotation)mention.get("predComp");
                if (!mentions.contains(predComp) || nameTypeMatch && !Resolve.typeMatch(doc, mention, predComp)) continue;
                Resolve.recordSyntacticCoref(predComp, mention, doc, mentions, syntacticAntecedent);
                if (trace) {
                    System.out.println("Refres: found predComp coref pair: " + doc.text(mention) + " = " + doc.text(predComp));
                }
            }
            if (mention.get("paren") != null) {
                apposite = (Annotation)mention.get("paren");
                Resolve.recordSyntacticCoref(apposite, mention, doc, mentions, syntacticAntecedent);
                if (trace) {
                    System.out.println("Refres: found parenthesized apposition coref pair: " + doc.text(mention));
                }
            }
            if (mention.get("host") == null) continue;
            Annotation host = (Annotation)mention.get("host");
            Resolve.recordSyntacticCoref(mention, host, doc, mentions, syntacticAntecedent);
        }
        for (int i = 0; i < clauses.size(); ++i) {
            Annotation vp;
            Annotation subject;
            String subjectHead;
            Annotation clause = clauses.get(i);
            String head = SynFun.getHead(doc, clause);
            if (head == null) {
                System.err.println("No head for annotation " + clause + " over " + doc.text(clause));
                continue;
            }
            if (clause.get("subject") == null || "there".equalsIgnoreCase(subjectHead = SynFun.getHead(doc, subject = (Annotation)clause.get("subject"))) || "it".equalsIgnoreCase(subjectHead) || (vp = (Annotation)clause.get("headC")) == null || vp.get("object") == null) continue;
            Annotation object = (Annotation)vp.get("object");
            if (!head.equals("be") && !head.equals("become")) continue;
            Resolve.recordSyntacticCoref(object, subject, doc, mentions, syntacticAntecedent);
            if (!trace) continue;
            System.out.println("Found copula relation: " + doc.text(clause));
        }
        return syntacticAntecedent;
    }

    private static void recordSyntacticCoref(Annotation anaphor, Annotation antecedent, Document doc, Vector<Annotation> mentions, Map<Annotation, Annotation> syntacticAntecedent) {
        Annotation prior;
        int antecedentPosn = mentions.indexOf(antecedent);
        if (antecedentPosn < 0) {
            System.err.println("Antecedent not in mentions: " + doc.text(antecedent));
            return;
        }
        int anaphorPosn = mentions.indexOf(anaphor);
        if (anaphorPosn < 0) {
            System.err.println("Anaphor not in mentions: " + doc.text(anaphor));
            return;
        }
        if (antecedentPosn > anaphorPosn) {
            mentions.set(antecedentPosn, anaphor);
            mentions.set(anaphorPosn, antecedent);
        }
        if ((prior = syntacticAntecedent.get(anaphor)) != null) {
            int priorPosn;
            antecedentPosn = mentions.indexOf(antecedent);
            if (antecedentPosn < (priorPosn = mentions.indexOf(prior))) {
                syntacticAntecedent.put(prior, antecedent);
            } else {
                syntacticAntecedent.put(anaphor, antecedent);
                syntacticAntecedent.put(antecedent, prior);
            }
        } else {
            syntacticAntecedent.put(anaphor, antecedent);
        }
    }

    private static boolean typeMatch(Document doc, Annotation men1, Annotation men2) {
        String type2;
        String type1 = EDTtype.bareType(EDTtype.getTypeSubtype(doc, null, men1));
        return type1.equals(type2 = EDTtype.bareType(EDTtype.getTypeSubtype(doc, null, men2)));
    }

    public static void updateEvents(Document doc, Span span, Map mentionToEntity) {
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> events = doc.annotationsAt(i, "event");
            if (events == null) continue;
            Annotation event = events.elementAt(0);
            FeatureSet resolvedFeatures = new FeatureSet(event.attributes());
            Enumeration features = resolvedFeatures.keys();
            while (features.hasMoreElements()) {
                String feature = (String)features.nextElement();
                Object value = resolvedFeatures.get(feature);
                if (!mentionToEntity.containsKey(value)) continue;
                resolvedFeatures.put(feature, mentionToEntity.get(value));
            }
            doc.annotate("r-event", event.span(), resolvedFeatures);
        }
    }

    private static void resolveMention(Document doc, Annotation mention) {
        Vector<Annotation> names;
        ArrayList<Annotation> antecedents = null;
        if (fullParse) {
            antecedents = Hobbs.collectAntecedents(mention, parents, doc);
        }
        Annotation headC = Resolve.getHeadC(mention);
        String cat = (String)headC.get("cat");
        int mentionPosition = mention.span().start();
        String mentionHead = SynFun.getHead(doc, mention);
        if (mentionHead.equals("?") && cat.equalsIgnoreCase("name") && (names = doc.annotationsAt(mentionPosition, "ENAMEX")) != null && names.size() >= 1) {
            Annotation enamex = names.firstElement();
            FeatureSet atts = enamex.attributes();
            mentionHead = (String)atts.get("TYPE");
        }
        if (mentionHead == null) {
            return;
        }
        String[] mentionName = Resolve.getNameTokens(doc, mention);
        boolean isNameMention = mentionName != null;
        boolean properAdjective = false;
        if (isNameMention) {
            boolean notNP;
            boolean bl = notNP = mention.get("cat") != "np";
            if (notNP && Ace.gazetteer.isNationality(mentionName)) {
                properAdjective = true;
            }
            mentionName = Resolve.normalizeGazName(mentionName, notNP, trace);
        }
        int bestDistance = 9999;
        int bestDissimilarity = 999;
        Annotation bestEntity = null;
        boolean reflexive = false;
        if (syntacticAntecedent.containsKey(mention) && !Ace.perfectEntities) {
            Annotation antecedent;
            if (trace) {
                System.out.println("Using syntactically-determined antecedent.");
            }
            if ((bestEntity = mentionToEntity.get(antecedent = syntacticAntecedent.get(mention))) == null) {
                System.err.println("Resolve:  syntactic antecedent not in entity");
                System.err.println("          mention:    " + doc.text(mention));
                System.err.println("          antecedent: " + doc.text(antecedent));
            }
        } else {
            for (int ie = 0; ie < entities.size(); ++ie) {
                int distance;
                int dissimilarity = 0;
                Annotation ent = entities.elementAt(ie);
                boolean match = false;
                if (Ace.perfectMentions & !Ace.perfectEntities) {
                    String eTypeSubtype = (String)ent.get("typeSubtype");
                    String typeSubtype = PerfectAce.getTypeSubtype(headC);
                    if (eTypeSubtype != null && typeSubtype != null && !typeSubtype.equals("") && !typeSubtype.equals(eTypeSubtype)) continue;
                }
                if (Ace.perfectEntities) {
                    String eid = PerfectAce.getEntityID(headC);
                    match = ent.get("entityID") != null && ent.get("entityID").equals(eid);
                } else if (isNameMention) {
                    dissimilarity = Resolve.matchName(mentionName, mentionHead, ent);
                    match = dissimilarity >= 0;
                } else if (cat == "pro" || cat == "det" || cat == "np") {
                    String pronoun = mentionHead.toLowerCase().intern();
                    match = Resolve.matchPronoun(doc, mention, pronoun, ent);
                    reflexive = reflexives.contains(pronoun);
                } else if (cat == "n" || cat == "adj" || cat == "ven" || cat == "v" || cat == "tv" || cat == "hyphword" || cat == "title" || cat == "nnp" || cat == "nnps" || cat == "adv") {
                    match = Resolve.matchNom(doc, mention, ent);
                } else if (cat == "$") {
                    match = false;
                } else if (cat == "q") {
                    match = false;
                } else {
                    System.err.println("Unexpected head cat " + cat + " for " + doc.text(mention));
                    match = false;
                    break;
                }
                if (!match) continue;
                boolean sameSimplex = false;
                if (reflexive) {
                    Annotation lastMention = (Annotation)ent.get("lastMention");
                    sameSimplex = Hobbs.sameSimplex(lastMention, mention, parents);
                }
                int n = distance = reflexive & sameSimplex ? 0 : Resolve.distance(doc, ent, mention, fullParse, antecedents);
                if (dissimilarity >= bestDissimilarity && (dissimilarity != bestDissimilarity || distance >= bestDistance)) continue;
                bestDistance = distance;
                bestDissimilarity = dissimilarity;
                bestEntity = ent;
            }
        }
        if (bestEntity == null) {
            bestEntity = Resolve.createNewEntity(doc, mention, mentionHead, properAdjective, entities);
        } else {
            if (bestEntity.get("properAdjective") != null && !properAdjective) {
                bestEntity.put("properAdjective", null);
            }
            if (trace) {
                Console.println("Resolving " + doc.text(mention) + " to " + doc.text(bestEntity));
            }
        }
        Resolve.addMentionToEntity(doc, mention, mentionHead, mentionName, bestEntity, mentionToEntity);
    }

    static Annotation createNewEntity(Document doc, Annotation mention, String mentionHead, boolean properAdjective, Vector<Annotation> entities) {
        boolean isHumanMention;
        Annotation token;
        Annotation headC;
        Annotation entity = doc.annotate("entity", mention.span(), new FeatureSet("mentions", new Vector()));
        String mentionNumber = SynFun.getNumber(mention);
        if (mentionNumber == null) {
            mentionNumber = "singular";
        }
        if (mentionHead.equals("they") || mentionHead.equals("them") || mentionHead.equals("their") || mentionHead.equals("these") || mentionHead.equals("those") || mentionHead.equals("some") || mentionHead.equals("many") || mentionHead.equals("everybody") || mentionHead.equals("everyone")) {
            mentionNumber = "plural";
        }
        if ((headC = Resolve.getHeadC(mention)).get("cat") == "q" && (token = doc.tokenAt(headC.start())) != null && token.get("intvalue") != null) {
            mentionNumber = "plural";
        }
        entity.put("number", mentionNumber);
        if (EDTtype.isDictLoaded()) {
            String ACEtype = EDTtype.getTypeSubtype(doc, null, mention);
            entity.put("ACEtype", ACEtype);
            isHumanMention = EDTtype.bareType(ACEtype).equals("PERSON");
        } else {
            isHumanMention = SynFun.getHuman(mention) || mentionHead == "PERSON";
        }
        String x = Resolve.nominativeFormOf(mentionHead);
        if (x == "he" || x == "she") {
            isHumanMention = true;
        }
        if (isHumanMention) {
            entity.put("human", "t");
        }
        entities.addElement(entity);
        if (properAdjective) {
            entity.put("properAdjective", "true");
        }
        if (Ace.perfectEntities) {
            entity.put("entityID", PerfectAce.getEntityID(Resolve.getHeadC(mention)));
        }
        if (trace) {
            Console.println("Creating new entity for " + doc.text(mention));
        }
        return entity;
    }

    static void addMentionToEntity(Document doc, Annotation mention, String mentionHead, String[] mentionName, Annotation entity, Map<Annotation, Annotation> mentionToEntity) {
        String typeSubtype;
        boolean isNameMention;
        entity.put("lastMention", mention);
        entity.put("position", new Integer(mention.span().start()));
        Vector mentions = (Vector)entity.get("mentions");
        mentions.addElement(mention);
        mentionToEntity.put(mention, entity);
        boolean bl = isNameMention = mentionName != null;
        if (isNameMention) {
            if (entity.get("name") == null) {
                entity.put("name", mentionName);
                Annotation ngHead = Resolve.getNgHead(mention);
                String[] mentionTokens = Tokenizer.gatherTokenStrings(doc, ngHead.span());
                entity.put("nameWithMods", mentionTokens);
                entity.put("nameType", mentionHead);
            }
        } else if (entity.get("head") == null) {
            entity.put("head", Resolve.nominativeFormOf(mentionHead));
        }
        Resolve.assignGenderFeature(mentionHead, mentionName, entity);
        if (Ace.perfectMentions && entity.get("typeSubtype") == null && (typeSubtype = PerfectAce.getTypeSubtype(Resolve.getHeadC(mention))) != null && !typeSubtype.equals("")) {
            entity.put("typeSubtype", typeSubtype);
        }
    }

    static void assignGenderFeature(String mentionHead, String[] mentionName, Annotation entity) {
        String head = mentionHead.toLowerCase();
        if (entity.get("gender") != null) {
            return;
        }
        if (Resolve.in(head, maleHeads)) {
            entity.put("gender", "male");
        } else if (Resolve.in(head, femaleHeads)) {
            entity.put("gender", "female");
        } else if (mentionHead == "PERSON" && mentionName != null && genderDict != null) {
            String firstName = mentionName[0].toLowerCase();
            String gender = genderDict.get(firstName);
            if (gender != null && gender.equals("M")) {
                entity.put("gender", "male");
            } else if (gender != null && gender.equals("F")) {
                entity.put("gender", "female");
            }
        }
    }

    public static void readGenderDict(String dataPath, Properties config) {
        String fileName = config.getProperty("NameGender.fileName");
        if (fileName == null) {
            return;
        }
        System.err.println("Reading gender dictionary " + fileName);
        genderDict = new HashMap();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(dataPath + File.separatorChar + fileName));
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split(" +");
                String name = fields[0];
                String gender = fields[1];
                genderDict.put(name, gender);
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println("Error in readGenderDict:" + e);
        }
    }

    static int distance(Document doc, Annotation entity, Annotation mention, boolean parse, ArrayList<Annotation> antecedents) {
        int mentionPosition = mention.span().start();
        int distance = 999999;
        Vector anteMentions = (Vector)entity.get("mentions");
        for (int i = 0; i < anteMentions.size(); ++i) {
            Annotation anteMention = (Annotation)anteMentions.get(i);
            int anteMentionPosition = anteMention.span().start();
            int d = parse ? Hobbs.distance(doc, anteMention, mention, antecedents, sentenceSet.sentences()) : sentenceSet.pseudoHobbsDistance(anteMentionPosition, mentionPosition);
            distance = Math.min(distance, d);
        }
        return distance;
    }

    public static String[] normalizeGazName(String[] name, boolean notNP, boolean trace) {
        String[] old;
        if (Ace.gazetteer == null) {
            return name;
        }
        if (notNP && Ace.gazetteer.isNationality(name)) {
            old = name;
            name = Ace.gazetteer.nationalityToCountry(name);
            if (trace) {
                System.out.println("Refres: using country " + Resolve.concat(name) + " for nationality " + Resolve.concat(old));
            }
        }
        if (Ace.gazetteer.isCountryAlias(name)) {
            old = name;
            name = Ace.gazetteer.canonicalCountryName(name);
            if (trace) {
                System.out.println("Refres: using country " + Resolve.concat(name) + " for alias " + Resolve.concat(old));
            }
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    static boolean matchNom(Document doc, Annotation anaphor, Annotation entity) {
        entityPosition = (Integer)entity.get("position");
        anaphorPosition = anaphor.span().start();
        numberofPriorMentionsOfEntity = ((Vector)entity.get("mentions")).size();
        anaphorHead = SynFun.getHead(doc, anaphor);
        if (anaphorHead == null) {
            return false;
        }
        anaphorDet = SynFun.getDet(anaphor);
        anaphorNumber = SynFun.getNumber(anaphor);
        if (anaphorNumber == null) {
            anaphorNumber = "singular";
        }
        ng = Resolve.getNgHead(anaphor);
        anaphorConcept = null;
        if (JetTest.conceptHierarchy != null) {
            anaphorConcept = JetTest.conceptHierarchy.getConceptFor(anaphorHead);
        }
        entityNumber = (String)entity.get("number");
        if (Resolve.in(anaphorDet, Resolve.indefiniteDets)) {
            return false;
        }
        if (ng.get("quant") != null || anaphorDet == "q") {
            return false;
        }
        if (ng.get("poss") != null) {
            return false;
        }
        if (anaphorNumber != null && entityNumber != null && !anaphorNumber.equals(entityNumber)) {
            return false;
        }
        if (Resolve.nameNomCoref(doc, anaphorDet, anaphorHead, anaphor, entity)) {
            return true;
        }
        anaphorTokens = Resolve.getNgTokens(doc, anaphor);
        anaphorLeftModifiers = Resolve.getLeftModifierTokens(doc, anaphor);
        anaphorRightModifiers = Resolve.getRightModifierTokens(doc, anaphor);
        anaphorModifiers = Resolve.concat((String[])anaphorLeftModifiers, (String[])anaphorRightModifiers);
        mentions = (Vector)entity.get("mentions");
        for (i = 0; i < mentions.size(); ++i) {
            block18: {
                antecedent = (Annotation)mentions.get(i);
                antecedentHeadC = Resolve.getHeadC(antecedent);
                aCat = (String)antecedentHeadC.get("cat");
                if (aCat == "pro" || aCat == "det") continue;
                antecedentDet = SynFun.getDet(antecedent);
                antecedentHead = SynFun.getHead(doc, antecedent);
                if (antecedentHead == null) continue;
                antecedentConcept = null;
                if (JetTest.conceptHierarchy != null) {
                    antecedentConcept = JetTest.conceptHierarchy.getConceptFor(antecedentHead);
                }
                synonym = false;
                if (anaphorConcept == null || antecedentConcept == null) break block18;
                if (ConceptHierarchy.isaStar(antecedentConcept, anaphorConcept)) ** GOTO lbl-1000
            }
            if (anaphorHead.equals(antecedentHead) || synonym) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = headCompatibility = false;
            }
            if (!headCompatibility) continue;
            if (antecedentDet == null && (anaphorModifiers.length > 0 || anaphorDet != null)) {
                return false;
            }
            antecedentTokens = Resolve.getNgTokens(doc, antecedent);
            antecedentLeftModifiers = Resolve.getLeftModifierTokens(doc, antecedent);
            antecedentRightModifiers = Resolve.getRightModifierTokens(doc, antecedent);
            antecedentModifiers = Resolve.concat((String[])antecedentLeftModifiers, (String[])antecedentRightModifiers);
            leftModifierCompatibility = Resolve.intersect(anaphorLeftModifiers, antecedentLeftModifiers);
            ofModifierCompatibility = Resolve.intersect(anaphorRightModifiers, antecedentRightModifiers);
            modifierCompatibility = Resolve.intersect(anaphorModifiers, antecedentModifiers);
            if (!leftModifierCompatibility || !ofModifierCompatibility) {
                if (Resolve.trace) {
                    System.out.println("Refres: modifier compability rejects merge of");
                    System.out.println("        " + doc.text(antecedent) + " and " + doc.text(anaphor));
                }
                return false;
            }
            if (Resolve.equalArray(anaphorTokens, antecedentTokens) && Resolve.equalArray(anaphorRightModifiers, antecedentRightModifiers)) {
                return true;
            }
            if (numberofPriorMentionsOfEntity == 1 && Resolve.sentenceSet.sentencesBetween(entityPosition, anaphorPosition) > 4) {
                return false;
            }
            if (synonym) {
                System.out.println("******* WordNet allowed merge of ");
                System.out.println("        " + doc.text(antecedent) + " and " + doc.text(anaphor));
            }
            return true;
        }
        return false;
    }

    private static String[] getNgTokens(Document doc, Annotation mention) {
        Annotation ngHead = Resolve.getNgHead(mention);
        return Tokenizer.gatherTokenStrings(doc, ngHead.span());
    }

    private static String[] getLeftModifierTokens(Document doc, Annotation mention) {
        Annotation ngHead = Resolve.getNgHead(mention);
        int ngStart = ngHead.start();
        Annotation headC = Resolve.getHeadC(mention);
        int headCstart = headC.start();
        int posn = ngStart;
        ArrayList<String> mods = new ArrayList<String>();
        block0: while (posn < headCstart) {
            Annotation token;
            Vector<Annotation> constits = doc.annotationsAt(posn, "constit");
            if (constits != null) {
                for (int i = 0; i < constits.size(); ++i) {
                    Annotation constit = constits.get(i);
                    String cat = (String)constit.get("cat");
                    if (cat != "det" && cat != "ving" && cat != "ven") continue;
                    posn = constit.span().end();
                    continue block0;
                }
            }
            if ((token = doc.tokenAt(posn)) == null) {
                ++posn;
                continue;
            }
            String text = doc.text(token);
            if (text != null) {
                text = text.trim();
                mods.add(text);
            }
            posn = token.span().end();
            if (token.span().start() != token.span().end()) continue;
            ++posn;
        }
        return mods.toArray(new String[mods.size()]);
    }

    private static String[] getRightModifierTokens(Document doc, Annotation mention) {
        int extentEnd;
        Annotation headC = Resolve.getHeadC(mention);
        int headEnd = headC.end();
        if (headEnd == (extentEnd = mention.end())) {
            return new String[0];
        }
        String[] tokens = Tokenizer.gatherTokenStrings(doc, new Span(headEnd, extentEnd));
        if (tokens.length > 0 && tokens[0] == ",") {
            return new String[0];
        }
        return tokens;
    }

    public static Annotation getNgHead(Annotation ng) {
        Annotation hd = ng;
        while ((ng = (Annotation)hd.get("headC")) != null) {
            if (ng.get("cat") != "np") {
                return hd;
            }
            hd = ng;
        }
        return hd;
    }

    private static String[] getOfModifierTokens(Document doc, Annotation mention) {
        Annotation of = (Annotation)mention.get("of");
        if (of == null) {
            return new String[0];
        }
        return Tokenizer.gatherTokenStrings(doc, of.span());
    }

    private static String[] concat(String[] s1, String[] s2) {
        int i;
        if (s1.length == 0) {
            return s2;
        }
        if (s2.length == 0) {
            return s1;
        }
        String[] s = new String[s1.length + s2.length];
        for (i = 0; i < s1.length; ++i) {
            s[i] = s1[i];
        }
        for (i = 0; i < s2.length; ++i) {
            s[i + s1.length] = s2[i];
        }
        return s;
    }

    public static boolean nameNomCoref(Document doc, String det, String mentionHead, Annotation mention, Annotation entity) {
        if (det == null) {
            return false;
        }
        if (!(det.equals("the") || det.equals("this") || det.equals("that"))) {
            return false;
        }
        String[] entityName = (String[])entity.get("name");
        if (entityName == null) {
            return false;
        }
        if (entityName[0].equals("AP")) {
            return false;
        }
        return Resolve.nomInName(doc, mention, entity);
    }

    public static boolean nomInName(Document doc, Annotation mention, Annotation entity) {
        String[] entityNameWithMods = (String[])entity.get("nameWithMods");
        if (entityNameWithMods == null) {
            return false;
        }
        Annotation ngHead = Resolve.getNgHead(mention);
        String[] mentionTokens = Tokenizer.gatherTokenStrings(doc, ngHead.span());
        for (int i = 0; i < mentionTokens.length; ++i) {
            if (mentionTokens[i].equalsIgnoreCase("the")) continue;
            boolean match = false;
            for (int j = 0; j < entityNameWithMods.length; ++j) {
                if (!mentionTokens[i].equalsIgnoreCase(entityNameWithMods[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    static int matchName(String[] mentionName, String mentionHead, Annotation ent) {
        String[] entityName = (String[])ent.get("name");
        if (entityName == null) {
            return -1;
        }
        String entityHead = (String)ent.get("nameType");
        if (nameTypeMatch && !mentionHead.equals(entityHead)) {
            return -1;
        }
        int dissimilarity = Resolve.matchFullName(mentionName, mentionHead, entityName, entityHead);
        if (dissimilarity >= 0) {
            return dissimilarity;
        }
        dissimilarity = Resolve.matchFullName(entityName, entityHead, mentionName, mentionHead);
        if (dissimilarity >= 0) {
            return dissimilarity;
        }
        if (mentionName.length == 1) {
            dissimilarity = Resolve.isAcronym(entityName, mentionName[0]);
            if (dissimilarity >= 0) {
                return dissimilarity;
            }
            dissimilarity = Resolve.isAbbreviation(entityName, mentionName[0]);
            if (dissimilarity >= 0) {
                return dissimilarity;
            }
        }
        if (entityName.length == 1) {
            dissimilarity = Resolve.isAcronym(mentionName, entityName[0]);
            if (dissimilarity >= 0) {
                return dissimilarity;
            }
            dissimilarity = Resolve.isAbbreviation(mentionName, entityName[0]);
            if (dissimilarity >= 0) {
                return dissimilarity;
            }
        }
        return -1;
    }

    public static int matchFullName(String[] mentionName, String mentionHead, String[] entityName, String entityHead) {
        int j = 0;
        for (int i = 0; i < mentionName.length; ++i) {
            while (j < entityName.length && !mentionName[i].equalsIgnoreCase(entityName[j])) {
                ++j;
            }
            if (j >= entityName.length) {
                return -1;
            }
            ++j;
        }
        if (mentionName.length < entityName.length) {
            if ((Ace.gazetteer.isNationality(mentionName) || Ace.gazetteer.isLocation(mentionName) || mentionHead == "GPE") && entityHead != "PERSON") {
                if (trace) {
                    System.out.println("Refres: rejecting (location) " + Resolve.concat(mentionName) + " as alias of " + Resolve.concat(entityName));
                }
                return -1;
            }
            if (trace) {
                System.out.println("Refres: recognizing " + Resolve.concat(mentionName) + " as alias of " + Resolve.concat(entityName));
            }
        }
        return entityName.length - mentionName.length;
    }

    public static int isAcronym(String[] name, String acronym) {
        if (name.length < 2 || acronym.length() < 2) {
            return -1;
        }
        int iname = 0;
        for (int i = 0; i < acronym.length(); ++i) {
            while (iname < name.length && 0 < name[iname].length() && name[iname].charAt(0) != acronym.charAt(i)) {
                ++iname;
            }
            if (iname >= name.length) {
                return -1;
            }
            ++iname;
        }
        if (trace) {
            System.out.println("Refres: recognizing " + acronym + " as acronym of " + Resolve.concat(name));
        }
        return name.length - acronym.length();
    }

    public static int isAbbreviation(String[] name, String abbrev) {
        if (name.length < 2 || abbrev.length() < 4 || abbrev.length() % 2 == 1) {
            return -1;
        }
        int iname = 0;
        for (int i = 0; i < abbrev.length() / 2; ++i) {
            if (abbrev.charAt(2 * i + 1) != '.') {
                return -1;
            }
            while (iname < name.length && name[iname].charAt(0) != abbrev.charAt(2 * i)) {
                ++iname;
            }
            if (iname >= name.length) {
                return -1;
            }
            ++iname;
        }
        if (trace) {
            System.out.println("Refres: recognizing " + abbrev + " as abbreviation of " + Resolve.concat(name));
        }
        return name.length - (abbrev.length() - 2);
    }

    static String nominativeFormOf(String pronoun) {
        if (nominative.containsKey(pronoun)) {
            return nominative.get(pronoun);
        }
        return pronoun;
    }

    public static boolean matchPronoun(Document doc, Annotation anaphor, String mentionHead, Annotation ent) {
        boolean match;
        if (ent.get("properAdjective") != null) {
            return false;
        }
        Annotation lastMention = (Annotation)ent.get("lastMention");
        String lastCat = (String)lastMention.get("cat");
        if (lastCat != "np" && lastCat != "det" && lastCat != "ngroup") {
            return false;
        }
        int entityPosition = (Integer)ent.get("position");
        int anaphorPosition = anaphor.span().start();
        String entityHead = (String)ent.get("head");
        String nominativeForm = Resolve.nominativeFormOf(mentionHead);
        if (nominativeForm == "he") {
            match = ent.get("human") != null && ent.get("number") == "singular" && ent.get("gender") != "female";
        } else if (nominativeForm == "she") {
            match = ent.get("human") != null && ent.get("number") == "singular" && ent.get("gender") != "male";
        } else if (nominativeForm == "it") {
            match = ent.get("human") == null && ent.get("number") == "singular";
        } else if (nominativeForm == "they") {
            match = ent.get("number") == "plural" || ent.get("nameType") == "ORGANIZATION" || ent.get("nameType") == "GPE";
        } else if (nominativeForm == "I" || nominativeForm == "i" || nominativeForm == "we" || nominativeForm == "you") {
            match = nominativeForm.equals(entityHead);
        } else if (mentionHead == "some" || mentionHead == "either" || mentionHead == "neither" || mentionHead == "any" || mentionHead == "each" || mentionHead == "all" || mentionHead == "both" || mentionHead == "none" || mentionHead == "many" || mentionHead == "afew" || mentionHead == "most" || mentionHead == "q" || mentionHead == "one") {
            match = false;
        } else if (mentionHead == "everyone" || mentionHead == "everything" || mentionHead == "everybody" || mentionHead == "nobody" || mentionHead == "noone" || mentionHead == "nothing" || mentionHead == "anyone" || mentionHead == "anything" || mentionHead == "anybody" || mentionHead == "someone" || mentionHead == "somebody" || mentionHead == "something" || mentionHead == "another") {
            match = false;
        } else if (mentionHead == "this" || mentionHead == "these" || mentionHead == "that" || mentionHead == "those") {
            match = false;
        } else {
            if (pronounsNotHandled.contains(mentionHead)) {
                System.err.println("Pronoun not being handled:  " + mentionHead);
                pronounsNotHandled.add(mentionHead);
            }
            match = false;
        }
        return match;
    }

    public static String normalizeName(String name) {
        StringTokenizer st = new StringTokenizer(name);
        StringBuffer result = new StringBuffer();
        while (st.hasMoreTokens()) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(st.nextToken());
        }
        return result.toString();
    }

    public static String concat(String[] s) {
        if (s.length == 0) {
            return "";
        }
        String r = s[0];
        for (int i = 1; i < s.length; ++i) {
            r = r + " " + s[i];
        }
        return r;
    }

    public static boolean isName(Annotation constit) {
        return constit != null && constit.get("cat") == "name";
    }

    public static Annotation getHeadC(Annotation ann) {
        while (ann.get("headC") != null) {
            ann = (Annotation)ann.get("headC");
        }
        return ann;
    }

    public static String[] getNameTokens(Document doc, Annotation constit) {
        Annotation head = Resolve.getHeadC(constit);
        if (head.get("cat") != "name") {
            return null;
        }
        return Tokenizer.gatherTokenStrings(doc, head.span());
    }

    public static String[] getHeadTokens(Document doc, Annotation constit) {
        Annotation head = Resolve.getHeadC(constit);
        return Tokenizer.gatherTokenStrings(doc, head.span());
    }

    public static boolean in(Object o, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || !array[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersect(Object[] setA, Object[] setB) {
        if (setA.length == 0) {
            return true;
        }
        if (setB.length == 0) {
            return true;
        }
        for (int i = 0; i < setA.length; ++i) {
            if (!Resolve.in(setA[i], setB)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalArray(Object[] first, Object[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i] != null && first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }

    static {
        fullParse = false;
        linkAppositesAndPredComps = true;
        nameTypeMatch = false;
        trace = false;
        parseTree = null;
        parents = null;
        useMaxEnt = false;
        ACE = false;
        maleHeads = new String[]{"mr", "mr.", "husband", "father", "grandfather", "son", "grandson", "uncle", "brother", "man", "gentleman", "sir", "boy", "boyfriend", "groom", "bridegroom"};
        femaleHeads = new String[]{"mrs", "mrs.", "ms", "ms.", "wife", "mother", "grandmother", "daughter", "granddaughter", "aunt", "sister", "woman", "lady", "girl", "girlfriend", "bride"};
        genderDict = null;
        definiteDets = new String[]{"the", "this", "these", "that", "those"};
        indefiniteDets = new String[]{"few", "afew", "more", "many", "most", "some", "any", "several", "less", "neither", "another", "such", "no", "either"};
        genericPersonTerms = new String[]{"man", "human", "person", "individual", "gentleman", "fellow", "boy", "woman", "lady", "girl", "official", "player", "diplomat", "chairman", "officer", "executive", "leader", "lawyer", "friend", "father", "president", "spokesman", "governor", "coach", "attorney", "member", "director", "body"};
        genericOrganizationTerms = new String[]{"academy", "administration", "agency", "airline", "army", "association", "board", "business", "college", "church", "company", "corporation", "establishment", "institute", "institution", "firm", "group", "military", "office", "panel", "partnership", "party", "police", "school", "synagogue", "syndicate", "team", "trust", "union", "university", "organization", "cathedral", "coalition", "temple", "bank", "commission", "committee", "council", "court", "department", "division", "federation", "force", "guild", "industry", "mosque", "league", "parliament", "seminary", "society"};
        genericCountryTerms = new String[]{"government", "country", "nation", "people", "kingdom"};
        genericStateTerms = new String[]{"state"};
        genericGpeTerms = new String[]{"village", "capital", "metropolis", "capital", "city", "town", "province"};
        genericLocationTerms = new String[]{"area", "region", "mount", "mountain", "hill", "ridge", "lake", "pond", "ocean", "sea", "river", "creek", "brook", "bayou", "stream"};
        genericFacilityTerms = new String[]{"tower", "castle", "hotel", "palace", "hall", "house", "road", "route", "bridge", "pass", "tunnel", "home", "street", "stadium"};
        nominative = new HashMap();
        nominative.put("me", "i");
        nominative.put("my", "i");
        nominative.put("myself", "i");
        nominative.put("your", "you");
        nominative.put("yourself", "you");
        nominative.put("him", "he");
        nominative.put("his", "he");
        nominative.put("himself", "he");
        nominative.put("her", "she");
        nominative.put("hers", "she");
        nominative.put("herself", "she");
        nominative.put("its", "it");
        nominative.put("itself", "it");
        nominative.put("us", "we");
        nominative.put("our", "we");
        nominative.put("ourselves", "we");
        nominative.put("them", "they");
        nominative.put("their", "they");
        nominative.put("themselves", "they");
        reflexives = new HashSet();
        reflexives.add("myself");
        reflexives.add("yourself");
        reflexives.add("himself");
        reflexives.add("herself");
        reflexives.add("itself");
        reflexives.add("ourselves");
        reflexives.add("themselves");
    }
}

