/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.scorer;

import edu.nyu.jet.Console;
import edu.nyu.jet.hmm.BigramHMMemitter;
import edu.nyu.jet.hmm.HMMNameTagger;
import edu.nyu.jet.hmm.WordFeatureHMMemitter;
import edu.nyu.jet.scorer.NameTagger;
import edu.nyu.jet.scorer.SGMLScorer;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.IOException;
import java.util.Vector;

public class NEScorer {
    public static void main(String[] args) throws IOException {
        if (args.length < 5) {
            NEScorer.argErr();
        }
        DocumentCollection testCollection = new DocumentCollection(args[0], args[1]);
        DocumentCollection keyCollection = new DocumentCollection(args[2], args[3]);
        HMMNameTagger tagger = null;
        int tagStart = 4;
        if (args[4].equals("unigram") || args[4].equals("bigram")) {
            boolean useBigrams;
            if (args.length < 7) {
                NEScorer.argErr();
            }
            tagger = new HMMNameTagger((useBigrams = args[4].equals("bigram")) ? BigramHMMemitter.class : WordFeatureHMMemitter.class);
            tagger.load(args[5]);
            tagStart = 6;
        }
        String[] tags = new String[args.length - tagStart];
        for (int itag = 0; itag < args.length - tagStart; ++itag) {
            tags[itag] = args[tagStart + itag];
        }
        NEScorer.scoreCollection((NameTagger)tagger, testCollection, keyCollection, tags);
    }

    private static void argErr() {
        System.err.println("NEScorer requires 5 or more arguments:");
        System.err.print("         test-directory test-file-list key-directory key-file-list");
        System.err.println(" [uni/bigram tagger-model] tag ...");
        System.exit(1);
    }

    public static void scoreCollection(NameTagger tagger, String testCollection, String keyCollection, String[] tagsToScore) {
        DocumentCollection testCol = new DocumentCollection(testCollection);
        DocumentCollection keyCol = new DocumentCollection(keyCollection);
        NEScorer.scoreCollection(tagger, testCol, keyCol, tagsToScore);
    }

    public static void scoreCollection(NameTagger tagger, DocumentCollection testCol, DocumentCollection keyCol, String[] tagsToScore) {
        testCol.open();
        keyCol.open();
        if (testCol.size() != keyCol.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        int tagsInResponses = 0;
        int tagsInKeys = 0;
        int matchingTags = 0;
        int matchingAttrs = 0;
        for (int i = 0; i < testCol.size(); ++i) {
            ExternalDocument testDoc = testCol.get(i);
            testDoc.setAllTags(true);
            testDoc.open();
            testDoc.stretchAll();
            System.out.println("Scoring " + testDoc.fileName());
            if (tagger != null) {
                tagger.tagDocument(testDoc);
            }
            ExternalDocument keyDoc = keyCol.get(i);
            keyDoc.setAllTags(true);
            keyDoc.open();
            keyDoc.stretchAll();
            Vector<Annotation> textSpans = keyDoc.annotationsOfType("TEXT");
            if (textSpans == null) {
                System.out.println("No <TEXT> in " + testDoc.fileName() + ", cannot be scored.");
                continue;
            }
            Span textSpan = textSpans.get(0).span();
            for (String tag : tagsToScore) {
                NEScorer.eraseAnnotationsOutside(keyDoc, tag, textSpan);
            }
            SGMLScorer scorer = new SGMLScorer(testDoc, keyDoc);
            for (String tag : tagsToScore) {
                scorer.match(tag);
                Console.println(scorer.report());
            }
            System.out.println("Total tags in response:  " + scorer.totalTagsInDoc1);
            System.out.println("Total tags in key:       " + scorer.totalTagsInDoc2);
            System.out.println("Matching tags:           " + scorer.totalMatchingTags);
            System.out.println("Matching attributes:     " + scorer.totalMatchingAttrs);
            System.out.println("Type recall:             " + (float)scorer.totalMatchingTags / (float)scorer.totalTagsInDoc2);
            System.out.println("Type precision:          " + (float)scorer.totalMatchingTags / (float)scorer.totalTagsInDoc1);
            System.out.println("Attribute recall:        " + (float)scorer.totalMatchingAttrs / (float)scorer.totalTagsInDoc2);
            System.out.println("Attribute precision:     " + (float)scorer.totalMatchingAttrs / (float)scorer.totalTagsInDoc1);
            tagsInResponses += scorer.totalTagsInDoc1;
            tagsInKeys += scorer.totalTagsInDoc2;
            matchingTags += scorer.totalMatchingTags;
            matchingAttrs += scorer.totalMatchingAttrs;
        }
        System.out.println("Overall Type Recall:          " + (float)matchingTags / (float)tagsInKeys);
        System.out.println("Overall Type Precision:       " + (float)matchingTags / (float)tagsInResponses);
        System.out.println("Overall Attribute Recall:     " + (float)matchingAttrs / (float)tagsInKeys);
        System.out.println("Overall Attribute Precision:  " + (float)matchingAttrs / (float)tagsInResponses);
    }

    private static void eraseAnnotationsOutside(Document doc, String type, Span span) {
        Vector v = doc.annotationsOfType(type);
        if (v == null) {
            return;
        }
        v = (Vector)v.clone();
        for (int i = 0; i < v.size(); ++i) {
            Annotation a = (Annotation)v.get(i);
            if (a.span().within(span)) continue;
            doc.removeAnnotation(a);
        }
    }
}

