/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.scorer;

import edu.nyu.jet.Console;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.pat.PatternSyntaxError;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class SGMLProcessor {
    public static boolean includeWhitespace = true;
    private static final int COLLECTING_TEXT = 0;
    private static final int COLLECTING_TYPE = 1;
    private static final int COLLECTING_FEATURE = 2;
    private static final int COLLECTING_VALUE = 3;
    private static final int COLLECTING_ESCAPED_VALUE = 4;
    private static final int COLLECTING_TAG_END = 5;
    private static final int SKIPPING_XML_DECLARATION = 6;
    public static boolean allTags = false;
    public static String[] emptyTags = null;
    static Stack<String> openTagType;
    static Stack<Integer> openTagPosn;
    static Stack<FeatureSet> openTagFeatureSet;
    static ArrayList<Annotation> newAnnotations;
    static boolean strictNesting;
    static HashMap<String, Annotation> idToAnnotation;

    public static Document sgmlToDoc(String sgmlText, String tag) {
        Document doc = new Document();
        return SGMLProcessor.sgmlToDoc(doc, sgmlText, tag);
    }

    public static Document sgmlToDoc(Document doc, String tag) {
        doc.clearAnnotations();
        return SGMLProcessor.sgmlToDoc(doc, doc.text(), tag);
    }

    public static Document sgmlToDoc(Document doc, String sgmlText, String tag) {
        String[] tags = new String[]{tag};
        return SGMLProcessor.sgmlToDoc(doc, sgmlText, tags);
    }

    public static Document sgmlToDoc(String sgmlText, String[] tags) {
        Document doc = new Document();
        return SGMLProcessor.sgmlToDoc(doc, sgmlText, tags);
    }

    public static Document sgmlToDoc(Document doc, String[] tags) {
        doc.clearAnnotations();
        return SGMLProcessor.sgmlToDoc(doc, doc.text(), tags);
    }

    public static Document sgmlToDoc(Document doc, String sgmlText, String[] tags) {
        newAnnotations = new ArrayList();
        StringBuffer type = null;
        StringBuffer whitespaceBeforeType = null;
        StringBuffer feature = null;
        StringBuffer value = null;
        FeatureSet fs = null;
        String tagName = "";
        int state = 0;
        char valueDelimiter = ' ';
        int annotationStart = 0;
        String annotationType = null;
        FeatureSet annotationFS = null;
        openTagType = new Stack();
        openTagPosn = new Stack();
        openTagFeatureSet = new Stack();
        for (int i = 0; i < sgmlText.length(); ++i) {
            char c = sgmlText.charAt(i);
            if (state == 0) {
                if (c == '<') {
                    state = 1;
                    type = new StringBuffer();
                    whitespaceBeforeType = new StringBuffer();
                    fs = new FeatureSet();
                    continue;
                }
                doc.append(c);
                continue;
            }
            if (state == 1) {
                if (Character.isWhitespace(c)) {
                    if (type.length() > 0 && !type.equals("/")) {
                        tagName = type.toString().intern();
                        if (tagName == "?xml") {
                            state = 6;
                            continue;
                        }
                        if (tagName.charAt(0) != '/' && SGMLProcessor.tagToCapture(tagName, tags)) {
                            state = 2;
                            feature = new StringBuffer();
                            value = new StringBuffer();
                            continue;
                        }
                        doc.append('<' + whitespaceBeforeType.toString() + type.toString() + ' ');
                        state = 0;
                        continue;
                    }
                    whitespaceBeforeType.append(c);
                    continue;
                }
                if (c == '/' && type.length() > 0) {
                    tagName = type.toString().intern();
                    state = 5;
                    continue;
                }
                if (c == '>') {
                    tagName = type.toString();
                    if (tagName.length() > 0 && tagName.charAt(0) != '/' && SGMLProcessor.tagToCapture(tagName, tags)) {
                        SGMLProcessor.endOfOpenTag(doc, tagName, fs);
                        state = 0;
                        continue;
                    }
                    if (tagName.length() > 0 && tagName.charAt(0) == '/' && SGMLProcessor.tagToCapture(tagName.substring(1), tags)) {
                        int istack = openTagType.search(tagName.substring(1));
                        if (istack > 0) {
                            if (strictNesting) {
                                for (int j = 1; j < istack; ++j) {
                                    String t = openTagType.pop();
                                    Console.println("Error in SGML read:  unclosed " + t + " tag.");
                                    openTagPosn.pop();
                                    openTagFeatureSet.pop();
                                }
                            }
                            int iv = openTagType.size() - istack;
                            annotationType = (String)openTagType.remove(iv);
                            annotationStart = (Integer)openTagPosn.remove(iv);
                            annotationFS = (FeatureSet)openTagFeatureSet.remove(iv);
                            int annotationEnd = doc.length();
                            Annotation a = new Annotation(annotationType, new Span(annotationStart, annotationEnd), annotationFS);
                            doc.addAnnotation(a);
                            newAnnotations.add(a);
                            state = 0;
                            continue;
                        }
                        Console.println("Error in SGML read:  unmatched " + tagName + " tag at position " + i);
                        state = 0;
                        continue;
                    }
                    doc.append('<' + whitespaceBeforeType.toString() + type.toString() + '>');
                    state = 0;
                    continue;
                }
                type.append(c);
                continue;
            }
            if (state == 2) {
                if (c == '=') {
                    state = 3;
                    valueDelimiter = ' ';
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                if (c == '>') {
                    if (feature.length() > 0) {
                        Console.println("Error in SGML read:  in tag " + tagName + ", feature " + feature + " not followed by value");
                    }
                    SGMLProcessor.endOfOpenTag(doc, tagName, fs);
                    state = 0;
                    continue;
                }
                if (c == '/') {
                    if (feature.length() > 0) {
                        Console.println("Error in SGML read:  in tag " + tagName + ", feature " + feature + " not followed by value");
                    }
                    state = 5;
                    continue;
                }
                feature.append(c);
                continue;
            }
            if (state == 3) {
                if (value.length() == 0 && valueDelimiter == ' ' && (c == '\"' || c == '\'')) {
                    valueDelimiter = c;
                    continue;
                }
                if (valueDelimiter == ' ' && c == '>') {
                    fs.put(feature.toString().intern(), value.toString().intern());
                    SGMLProcessor.endOfOpenTag(doc, tagName, fs);
                    state = 0;
                    continue;
                }
                if (valueDelimiter == ' ' && Character.isWhitespace(c) || valueDelimiter != ' ' && c == valueDelimiter) {
                    Object jetValue = SGMLProcessor.decodeJetValue(value.toString());
                    fs.put(feature.toString().intern(), jetValue);
                    feature = new StringBuffer();
                    value = new StringBuffer();
                    state = 2;
                    continue;
                }
                if (c == '\\') {
                    state = 4;
                    continue;
                }
                value.append(c);
                continue;
            }
            if (state == 4) {
                value.append(c);
                state = 3;
                continue;
            }
            if (state == 5) {
                if (Character.isWhitespace(c)) continue;
                if (c == '>') {
                    Annotation a = new Annotation(tagName, new Span(doc.length(), doc.length()), fs);
                    doc.addAnnotation(a);
                    newAnnotations.add(a);
                    state = 0;
                    continue;
                }
                Console.println("Error in SGML read:  in tag " + tagName + " missing > after /");
                state = 0;
                continue;
            }
            if (state == 6) {
                if (c != '>') continue;
                state = 0;
                continue;
            }
            Console.println("Internal error in SGMLProcessor: invalid state");
            System.exit(1);
        }
        if (state != 0) {
            Console.println("Error in SGML read:  incomplete tag");
        }
        if (!openTagType.empty()) {
            Console.println("Error in SGML read:  unbalanced tags");
            while (!openTagType.empty()) {
                Console.println("  Unclosed tag " + openTagType.pop());
                Console.println(" " + openTagPosn.pop());
                Console.println(" " + openTagFeatureSet.pop());
            }
        }
        SGMLProcessor.dereference(doc);
        return doc;
    }

    private static void endOfOpenTag(Document doc, String tagName, FeatureSet fs) {
        if (SGMLProcessor.emptyTag(tagName)) {
            Annotation a = new Annotation(tagName, new Span(doc.length(), doc.length()), fs);
            doc.addAnnotation(a);
            newAnnotations.add(a);
        } else {
            openTagType.push(tagName);
            openTagPosn.push(new Integer(doc.length()));
            openTagFeatureSet.push(fs);
        }
    }

    private static Object decodeJetValue(String s) {
        if (s.startsWith("{") && s.endsWith("}")) {
            StringTokenizer st = new StringTokenizer(s.substring(1, s.length() - 1));
            int len = st.countTokens();
            Object[] result = new Object[len];
            for (int i = 0; i < len; ++i) {
                result[i] = st.nextToken().intern();
            }
            return result;
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            StreamTokenizer st = new StreamTokenizer(new StringReader(s.substring(1, s.length())));
            try {
                FeatureSet fs = new FeatureSet(st, false, ']');
                return fs;
            }
            catch (IOException e) {
                System.out.println("SGMLProcessor:  error in reading featureSet, " + s + "\n" + e);
                return null;
            }
            catch (PatternSyntaxError e) {
                System.out.println("SGMLProcessor:  error in reading featureSet, " + s + "\n" + e);
                return null;
            }
        }
        return s.intern();
    }

    private static boolean tagToCapture(String tag, String[] tags) {
        if (allTags) {
            return true;
        }
        for (int j = 0; j < tags.length; ++j) {
            if (!tag.equalsIgnoreCase(tags[j])) continue;
            return true;
        }
        return false;
    }

    private static boolean emptyTag(String tag) {
        if (emptyTags == null) {
            return false;
        }
        for (int j = 0; j < emptyTags.length; ++j) {
            if (!tag.equalsIgnoreCase(emptyTags[j])) continue;
            return true;
        }
        return false;
    }

    public static void dereference(Document doc) {
        Annotation ann;
        int i;
        Vector<Annotation> anns;
        int itype;
        idToAnnotation = new HashMap();
        String[] types = doc.getAnnotationTypes();
        for (itype = 0; itype < types.length; ++itype) {
            anns = doc.annotationsOfType(types[itype]);
            for (i = 0; i < anns.size(); ++i) {
                ann = anns.get(i);
                String id = (String)ann.get("id");
                if (id == null) continue;
                idToAnnotation.put(id, ann);
            }
        }
        for (itype = 0; itype < types.length; ++itype) {
            anns = doc.annotationsOfType(types[itype]);
            for (i = 0; i < anns.size(); ++i) {
                ann = anns.get(i);
                FeatureSet fs = ann.attributes();
                Enumeration e = fs.keys();
                while (e.hasMoreElements()) {
                    String feature = (String)e.nextElement();
                    Object value = fs.get(feature);
                    if (SGMLProcessor.isAnnotationReference(value)) {
                        fs.put(feature, SGMLProcessor.resolveAnnotationReference(value));
                        continue;
                    }
                    if (!(value instanceof Object[])) continue;
                    Object[] ray = (Object[])value;
                    boolean arrayOfAnnotations = true;
                    for (int j = 0; j < ray.length; ++j) {
                        if (SGMLProcessor.isAnnotationReference(ray[j])) {
                            ray[j] = SGMLProcessor.resolveAnnotationReference(ray[j]);
                            continue;
                        }
                        arrayOfAnnotations = false;
                    }
                    if (!arrayOfAnnotations) continue;
                    Annotation[] r = new Annotation[ray.length];
                    for (int j = 0; j < ray.length; ++j) {
                        r[j] = (Annotation)ray[j];
                    }
                    fs.put(feature, r);
                }
            }
        }
    }

    private static boolean isAnnotationReference(Object value) {
        return value instanceof String && ((String)value).length() > 0 && ((String)value).charAt(0) == '#';
    }

    private static Object resolveAnnotationReference(Object value) {
        String id = ((String)value).substring(1);
        Annotation ann = idToAnnotation.get(id);
        if (ann == null) {
            System.out.println("Undefined annotation reference " + value);
            return null;
        }
        return ann;
    }

    private static void stretchAnnotations(Document doc, ArrayList newAnnotations) {
        Annotation a;
        int i;
        int length = doc.length();
        boolean[] startingPoint = new boolean[length];
        for (i = 0; i < newAnnotations.size(); ++i) {
            a = (Annotation)newAnnotations.get(i);
            startingPoint[a.start()] = true;
        }
        for (i = 0; i < newAnnotations.size(); ++i) {
            int posn;
            a = (Annotation)newAnnotations.get(i);
            doc.removeAnnotation(a);
            Span s = a.span();
            for (posn = s.end(); posn < length && !startingPoint[posn] && Character.isWhitespace(doc.charAt(posn)); ++posn) {
            }
            s.setEnd(posn);
            doc.addAnnotation(a);
        }
    }

    static {
        strictNesting = false;
    }
}

