/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.scorer;

import edu.nyu.jet.scorer.SGMLProcessor;
import edu.nyu.jet.scorer.SGMLScorer;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SGMLScorerWindow
extends JFrame
implements ActionListener {
    JButton jButtonScore = new JButton();
    JButton jButtonReset = new JButton();
    JLabel jLabel = new JLabel();
    JTextField jTextField = new JTextField();
    JPanel jPanelBottom = new JPanel();
    JPanel jPanelBottomLeft = new JPanel();
    JPanel jPanelBottomRight = new JPanel();
    JPanel jPanelTopLeft = new JPanel();
    JPanel jPanelTopRight = new JPanel();
    JPanel jPanelButtons = new JPanel();
    JPanel jPanelTypeText = new JPanel();
    JSplitPane jSplitPane = new JSplitPane();
    JSplitPane jSplitPaneMain = new JSplitPane(0);
    JScrollPane jScrollPaneLeft = new JScrollPane();
    JScrollPane jScrollPaneRight = new JScrollPane();
    JScrollPane jScrollPaneBottom = new JScrollPane();
    JTextPane jTextPaneLeft = new JTextPane();
    JTextPane jTextPaneRight = new JTextPane();
    JTextArea jTextAreaBottom = new JTextArea();
    final JFileChooser fc = new JFileChooser(".");
    SGMLScorer scorer = null;
    String loadedText1 = "";
    String loadedText2 = "";
    String text1 = null;
    String text2 = null;
    Document doc1 = null;
    Document doc2 = null;
    boolean keyProcessed = false;
    boolean responseProcessed = false;
    boolean editMode = false;

    public SGMLScorerWindow() {
        try {
            this.jbInit();
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("SGML Scorer");
        JMenuBar jmb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem item = new JMenuItem("Load Key File ...");
        item.setMnemonic(75);
        fileMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Load Response File ...");
        item.setMnemonic(80);
        fileMenu.add(item);
        item.addActionListener(this);
        fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.setMnemonic(88);
        fileMenu.add(item);
        item.addActionListener(this);
        JMenu modeMenu = new JMenu("Mode");
        modeMenu.setMnemonic(77);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbmItem = new JRadioButtonMenuItem("Edit Mode");
        rbmItem.setMnemonic(69);
        modeMenu.add(rbmItem);
        group.add(rbmItem);
        rbmItem.addActionListener(this);
        rbmItem = new JRadioButtonMenuItem("Non-Edit Mode");
        rbmItem.setSelected(true);
        rbmItem.setMnemonic(78);
        modeMenu.add(rbmItem);
        group.add(rbmItem);
        rbmItem.addActionListener(this);
        jmb.add(fileMenu);
        jmb.add(modeMenu);
        this.setJMenuBar(jmb);
        this.jTextPaneLeft.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextPaneLeft.setFont(new Font("dialog", 0, 12));
        this.jTextPaneLeft.setEditable(false);
        this.jTextPaneLeft.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                SGMLScorerWindow.this.jTextPaneLeftCaretUpdate(evt);
            }
        });
        this.jScrollPaneLeft.getViewport().add((Component)this.jTextPaneLeft, null);
        this.jPanelTopLeft.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Key File"), BorderFactory.createEmptyBorder(4, 8, 4, 4)));
        this.jPanelTopLeft.setLayout(new BorderLayout());
        this.jPanelTopLeft.add((Component)this.jScrollPaneLeft, "Center");
        this.jTextPaneRight.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextPaneRight.setFont(new Font("dialog", 0, 12));
        this.jTextPaneRight.setEditable(false);
        this.jTextPaneRight.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                SGMLScorerWindow.this.jTextPaneRightCaretUpdate(evt);
            }
        });
        this.jScrollPaneRight.getViewport().add((Component)this.jTextPaneRight, null);
        this.jPanelTopRight.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Response File"), BorderFactory.createEmptyBorder(4, 8, 4, 4)));
        this.jPanelTopRight.setLayout(new BorderLayout());
        this.jPanelTopRight.add((Component)this.jScrollPaneRight, "Center");
        this.jSplitPane.setPreferredSize(new Dimension(1016, 510));
        this.jSplitPane.setDividerLocation(500);
        this.jSplitPane.add((Component)this.jPanelTopLeft, "left");
        this.jSplitPane.add((Component)this.jPanelTopRight, "right");
        this.jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SGMLScorerWindow.this.scorer();
            }
        });
        this.jButtonScore.setText("Score");
        this.jButtonScore.setToolTipText("Score homology of the two files");
        this.jButtonScore.setMnemonic(83);
        this.jButtonScore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SGMLScorerWindow.this.scorer();
            }
        });
        this.jButtonReset.setText("Reset");
        this.jButtonReset.setToolTipText("Reset texts to original form");
        this.jButtonReset.setMnemonic(82);
        this.jButtonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SGMLScorerWindow.this.jTextPaneLeft.setText(SGMLScorerWindow.this.loadedText1);
                SGMLScorerWindow.this.jTextPaneRight.setText(SGMLScorerWindow.this.loadedText2);
                SGMLScorerWindow.this.jTextAreaBottom.setText("");
                SGMLScorerWindow.this.jTextField.selectAll();
                SGMLScorerWindow.this.doc1 = null;
                SGMLScorerWindow.this.doc2 = null;
                SGMLScorerWindow.this.keyProcessed = false;
                SGMLScorerWindow.this.responseProcessed = false;
            }
        });
        this.jPanelButtons.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanelButtons.setLayout(new GridLayout(1, 2));
        this.jPanelButtons.add(this.jButtonScore);
        this.jPanelButtons.add(this.jButtonReset);
        this.jLabel.setText("Type(s):  ");
        this.jLabel.setToolTipText("The type(s) to be scored, separated by ','  Case sensitive");
        this.jPanelTypeText.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanelTypeText.setLayout(new BorderLayout());
        this.jPanelTypeText.add((Component)this.jLabel, "West");
        this.jPanelTypeText.add((Component)this.jTextField, "Center");
        this.jPanelBottomLeft.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanelBottomLeft.setLayout(new GridLayout(2, 1));
        this.jPanelBottomLeft.add(this.jPanelTypeText);
        this.jPanelBottomLeft.add(this.jPanelButtons);
        this.jTextAreaBottom.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextAreaBottom.setEditable(false);
        this.jScrollPaneBottom.getViewport().add((Component)this.jTextAreaBottom, null);
        this.jPanelBottomRight.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Statistics"), BorderFactory.createEmptyBorder(4, 8, 4, 4)));
        this.jPanelBottomRight.setLayout(new BorderLayout());
        this.jPanelBottomRight.add((Component)this.jScrollPaneBottom, "Center");
        this.jPanelBottom.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.add((Component)this.jPanelBottomLeft, "West");
        this.jPanelBottom.add((Component)this.jPanelBottomRight, "Center");
        this.jPanelBottom.setPreferredSize(new Dimension(1016, 70));
        this.jSplitPaneMain.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this.jSplitPaneMain.add((Component)this.jSplitPane, "top");
        this.jSplitPaneMain.add((Component)this.jPanelBottom, "bottom");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing() {
                SGMLScorerWindow.this.dispose();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jSplitPaneMain, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Load Key File ...")) {
            this.fc.setDialogTitle("Load Key File");
            this.fc.setApproveButtonText("Load");
            this.fc.setApproveButtonMnemonic(76);
            this.fc.setApproveButtonToolTipText("Load key file");
            int returnVal = this.fc.showDialog(this, null);
            if (returnVal == 0) {
                try {
                    File file = this.fc.getSelectedFile();
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String line = null;
                    StringBuffer keyFileText = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        keyFileText.append(line + "\n");
                    }
                    this.loadedText1 = keyFileText.toString();
                    this.jTextPaneLeft.setText(this.loadedText1);
                    this.keyProcessed = false;
                    this.doc1 = null;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals("Load Response File ...")) {
            this.fc.setDialogTitle("Load Response File");
            this.fc.setApproveButtonText("Load");
            this.fc.setApproveButtonMnemonic(76);
            this.fc.setApproveButtonToolTipText("Load response file");
            int returnVal = this.fc.showDialog(this, null);
            if (returnVal == 0) {
                try {
                    File file = this.fc.getSelectedFile();
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String line = null;
                    StringBuffer responseFileText = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        responseFileText.append(line + "\n");
                    }
                    this.loadedText2 = responseFileText.toString();
                    this.jTextPaneRight.setText(this.loadedText2);
                    this.responseProcessed = false;
                    this.doc2 = null;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals("Exit")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Edit Mode")) {
            this.editMode = true;
            this.jTextPaneLeft.setEditable(true);
            this.jTextPaneRight.setEditable(true);
        } else {
            this.editMode = false;
            this.jTextPaneLeft.setEditable(false);
            this.jTextPaneRight.setEditable(false);
        }
    }

    private void scorer() {
        int i;
        String[] types = this.getTypes();
        if (this.editMode) {
            this.text1 = this.jTextPaneLeft.getText();
            this.text2 = this.jTextPaneRight.getText();
            this.doc1 = SGMLProcessor.sgmlToDoc(this.text1, types);
            this.doc2 = SGMLProcessor.sgmlToDoc(this.text2, types);
        } else {
            if (!this.keyProcessed) {
                this.doc1 = SGMLProcessor.sgmlToDoc(this.loadedText1, types);
                this.keyProcessed = true;
            }
            if (!this.responseProcessed) {
                this.doc2 = SGMLProcessor.sgmlToDoc(this.loadedText2, types);
                this.responseProcessed = true;
            }
        }
        this.jTextPaneLeft.setText(this.doc1.text());
        this.jTextPaneRight.setText(this.doc2.text());
        this.scorer = new SGMLScorer(this.doc1, this.doc2);
        for (i = 0; i < types.length; ++i) {
            this.scorer.match(types[i]);
        }
        for (i = 0; i < types.length; ++i) {
            this.highlight(types[i]);
        }
        float precision = this.scorer.totalTagsInDoc2 == 0 ? -100.0f : (float)(10000 * this.scorer.numOfMatchingTags / this.scorer.totalTagsInDoc2);
        precision = (float)((double)precision / 100.0);
        float recall = this.scorer.totalTagsInDoc1 == 0 ? -100.0f : (float)(10000 * this.scorer.numOfMatchingTags / this.scorer.totalTagsInDoc1);
        recall = (float)((double)recall / 100.0);
        float typeAccuracy = this.scorer.numOfMatchingTags == 0 ? -100.0f : (float)(10000 * this.scorer.numOfMatchingAttrs / this.scorer.numOfMatchingTags);
        typeAccuracy = (float)((double)typeAccuracy / 100.0);
        StringBuffer statistics = new StringBuffer();
        statistics.append("# of matching tags = " + this.scorer.totalMatchingTags);
        statistics.append(";  # of tags in key = " + this.scorer.totalTagsInDoc1);
        statistics.append(";  # of tags in response = " + this.scorer.totalTagsInDoc2);
        statistics.append(";\nprecision = " + (precision < 0.0f ? "NA" : precision + "%"));
        statistics.append(";  recall = " + (recall < 0.0f ? "NA" : recall + "%"));
        statistics.append(";  type accuracy = " + (typeAccuracy < 0.0f ? "NA" : typeAccuracy + "%"));
        this.jTextAreaBottom.setText(statistics.toString());
        this.highlightMismatches();
        this.jTextField.selectAll();
    }

    private String[] getTypes() {
        Vector<String> types = new Vector<String>();
        String jTextFieldContent = this.jTextField.getText();
        StringTokenizer stok = new StringTokenizer(jTextFieldContent, ", \t\n\r\f");
        while (stok.hasMoreTokens()) {
            types.add(stok.nextToken());
        }
        Object[] tmp = types.toArray();
        String[] returnTypes = new String[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            returnTypes[i] = (String)tmp[i];
        }
        return returnTypes;
    }

    private void highlight(String type) {
        SimpleAttributeSet highlighted = new SimpleAttributeSet();
        Color color = new Color(type.hashCode());
        StyleConstants.setForeground(highlighted, color);
        StyleConstants.setBold(highlighted, true);
        this.setAnnotationAttribute(type, highlighted);
    }

    private void bleach(String type) {
        SimpleAttributeSet bleached = new SimpleAttributeSet();
        this.setAnnotationAttribute(type, bleached);
    }

    private void setAnnotationAttribute(String annType, AttributeSet attrSet) {
        Vector<Annotation> annotationsOfType2;
        Vector<Annotation> annotationsOfType1 = this.doc1.annotationsOfType(annType);
        if (annotationsOfType1 != null) {
            StyledDocument sd = this.jTextPaneLeft.getStyledDocument();
            for (Annotation ann : annotationsOfType1) {
                int start = ann.span().start();
                int length = ann.span().endNoWS(this.doc1) - start;
                sd.setCharacterAttributes(start, length, attrSet, true);
            }
        }
        if ((annotationsOfType2 = this.doc2.annotationsOfType(annType)) != null) {
            StyledDocument sd = this.jTextPaneRight.getStyledDocument();
            for (Annotation ann : annotationsOfType2) {
                int start = ann.span().start();
                int length = ann.span().endNoWS(this.doc2) - start;
                sd.setCharacterAttributes(start, length, attrSet, true);
            }
        }
    }

    private void highlightMismatches() {
        int length;
        int start;
        StyledDocument sd;
        SimpleAttributeSet unmatchLine = new SimpleAttributeSet();
        StyleConstants.setBackground(unmatchLine, Color.orange);
        if (this.scorer.mismatch1 != null) {
            sd = this.jTextPaneLeft.getStyledDocument();
            for (Annotation ann : this.scorer.mismatch1) {
                start = ann.span().start();
                length = ann.span().endNoWS(this.doc1) - start;
                sd.setCharacterAttributes(start, length, unmatchLine, false);
            }
        }
        if (this.scorer.mismatch2 != null) {
            sd = this.jTextPaneRight.getStyledDocument();
            for (Annotation ann : this.scorer.mismatch2) {
                start = ann.span().start();
                length = ann.span().endNoWS(this.doc2) - start;
                sd.setCharacterAttributes(start, length, unmatchLine, false);
            }
        }
    }

    private void jTextPaneLeftCaretUpdate(CaretEvent evt) {
        String toolTip = null;
        StringBuffer annBuffer = new StringBuffer();
        int dot = evt.getDot();
        int mark = evt.getMark();
        if (this.doc1 == null) {
            return;
        }
        for (int pos = Math.min(dot, mark); pos < Math.max(dot, mark) || pos == dot && dot == mark; ++pos) {
            Vector<Annotation> annotationsAtCaret = this.doc1.annotationsAt(pos);
            if (annotationsAtCaret == null) continue;
            for (Annotation ann : annotationsAtCaret) {
                annBuffer.append(ann.toString() + " ");
            }
        }
        toolTip = annBuffer.toString();
        if (toolTip.length() != 0) {
            this.jTextPaneLeft.setToolTipText(toolTip);
        } else {
            this.jTextPaneLeft.setToolTipText(null);
        }
    }

    private void jTextPaneRightCaretUpdate(CaretEvent evt) {
        String toolTip = null;
        StringBuffer annBuffer = new StringBuffer();
        int dot = evt.getDot();
        int mark = evt.getMark();
        if (this.doc2 == null) {
            return;
        }
        for (int pos = Math.min(dot, mark); pos < Math.max(dot, mark) || pos == dot && dot == mark; ++pos) {
            Vector<Annotation> annotationsAtCaret = this.doc2.annotationsAt(pos);
            if (annotationsAtCaret == null) continue;
            for (Annotation ann : annotationsAtCaret) {
                annBuffer.append(ann.toString() + " ");
            }
        }
        toolTip = annBuffer.toString();
        if (toolTip.length() != 0) {
            this.jTextPaneRight.setToolTipText(toolTip);
        } else {
            this.jTextPaneRight.setToolTipText(null);
        }
    }
}

