/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.time.TimeRule;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTimeRule
extends TimeRule {
    private DateTimeFormatter formatter;

    @Override
    public void setParameters(Map params) {
        super.setParameters(params);
        this.formatter = DateTimeFormat.forPattern((String)params.get("format"));
    }

    @Override
    public void apply(Document doc, List<Object> values, Span span, DateTime ref) {
        Map params = this.getParameters();
        String value = (String)params.get("value");
        String diff = (String)params.get("diff");
        String dir = (String)params.get("dir");
        DateTime val = ref;
        if (value != null) {
            value = this.assignValues(value, values);
            val = new DateTime(value);
        } else if (diff != null) {
            diff = this.assignValues(diff, values);
            Period period = new Period(diff);
            if (dir == null || dir.equals("plus")) {
                val = ref.plus(period);
            } else if (dir.equals("minus")) {
                val = ref.minus(period);
            }
        } else {
            val = ref;
            for (Map.Entry entry : params.entrySet()) {
                Matcher m = Pattern.compile("set_(.*)").matcher((String)entry.getKey());
                if (!m.matches()) continue;
                String field = this.assignValues((String)entry.getValue(), values);
                String fieldName = m.group(1);
                if (fieldName.equals("month")) {
                    int month = Integer.parseInt(field);
                    val = this.getTimeAnnotator().normalizeMonth(val, month);
                    continue;
                }
                if (fieldName.equals("day")) {
                    int day = Integer.parseInt(field);
                    val = val.withField(DateTimeFieldType.dayOfMonth(), day);
                    continue;
                }
                throw new InternalError();
            }
        }
        String formattedDate = this.formatter.print(val);
        FeatureSet attrs = new FeatureSet();
        attrs.put("VAL", formattedDate);
        doc.annotate("TIMEX2", span, attrs);
    }
}

