/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.time.DayOfWeekPattern;
import edu.nyu.jet.time.MonthPattern;
import edu.nyu.jet.time.NumberPattern;
import edu.nyu.jet.time.PatternItem;
import edu.nyu.jet.time.RegexPattern;
import edu.nyu.jet.time.ScriptRule;
import edu.nyu.jet.time.SimpleTimeRule;
import edu.nyu.jet.time.StringPattern;
import edu.nyu.jet.time.TimePattern;
import edu.nyu.jet.time.TimeRule;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ho.yaml.Yaml;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeAnnotator {
    private List<TimeRule> mainRules;
    private List<TimeRule> transformRules;
    private Map config;
    private int early_month = 4;
    private int late_month = 9;
    private int min_year = 1000;
    private int max_year = 9999;

    public TimeAnnotator() {
    }

    public TimeAnnotator(String ruleFilename) throws IOException {
        this(new File(ruleFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeAnnotator(File ruleFile) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(ruleFile);
            this.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void annotate(Document doc, Span span, DateTime ref) {
        this.applyRules(doc, span, ref, this.mainRules);
        if (this.transformRules != null) {
            this.applyRules(doc, span, ref, this.transformRules);
        }
    }

    private void applyRules(Document doc, Span span, DateTime ref, List<TimeRule> rules) {
        Vector<Annotation> tokens = doc.annotationsOfType("token", span);
        if (tokens == null) {
            return;
        }
        int offset = 0;
        while (offset < tokens.size()) {
            Span resultSpan = null;
            for (TimeRule rule : rules) {
                ArrayList<Object> values;
                resultSpan = rule.matches(doc, tokens, offset, ref, values = new ArrayList<Object>());
                if (resultSpan == null) continue;
                try {
                    rule.apply(doc, values, resultSpan, ref);
                    break;
                }
                catch (IllegalFieldValueException illegalFieldValueException) {
                }
                catch (IllegalArgumentException e) {
                    System.err.println("TimeAnnotator.applyRules:  " + e);
                }
            }
            if (resultSpan != null) {
                offset = this.nextOffset(tokens, offset, resultSpan);
                continue;
            }
            ++offset;
        }
    }

    public void load(InputStream in) throws IOException {
        this.mainRules = null;
        Map root = (Map)Yaml.load(in);
        List rules = (List)root.get("rules");
        this.config = (Map)root.get("config");
        if (this.config == null) {
            this.config = new HashMap();
        }
        this.mainRules = new ArrayList<TimeRule>(rules.size());
        boolean sortByPatternLength = true;
        if (this.config.containsKey("sortByPatternLength")) {
            sortByPatternLength = (Boolean)this.config.get("sortByPatternLength");
        }
        if (this.config.containsKey("min_year")) {
            this.min_year = (Integer)this.config.get("min_year");
        }
        if (this.config.containsKey("max_year")) {
            this.max_year = (Integer)this.config.get("max_year");
        }
        if (this.config.containsKey("early_month")) {
            this.early_month = (Integer)this.config.get("early_month");
        }
        if (this.config.containsKey("late_month")) {
            this.late_month = (Integer)this.config.get("late_month");
        }
        this.mainRules = this.loadRules(rules, sortByPatternLength);
        if (root.containsKey("transformRules")) {
            this.transformRules = this.loadRules((List)root.get("transformRules"), sortByPatternLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
    }

    public Map getConfig() {
        return this.config;
    }

    private List<TimeRule> loadRules(List rules, boolean sortByPatternLength) {
        ArrayList<TimeRule> result = new ArrayList<TimeRule>();
        for (Object obj : rules) {
            result.addAll(this.loadRule((Map)obj));
        }
        if (sortByPatternLength) {
            Comparator<TimeRule> cmp = new Comparator<TimeRule>(){

                @Override
                public int compare(TimeRule o1, TimeRule o2) {
                    return o2.getPatternItems().length - o1.getPatternItems().length;
                }
            };
            Collections.sort(result, cmp);
        }
        return result;
    }

    public List<TimeRule> loadRule(Map params) {
        ArrayList<TimeRule> rules = new ArrayList<TimeRule>();
        String type = (String)params.get("type");
        Map ruleParams = (Map)params.get("params");
        if (type.equals("simple")) {
            for (PatternItem[] patterns : this.getPatterns(this.getPatternStrings(params))) {
                SimpleTimeRule timeRule = new SimpleTimeRule();
                timeRule.setTimeAnnotator(this);
                timeRule.setPatternItems(patterns);
                timeRule.setParameters(ruleParams);
                rules.add(timeRule);
            }
        } else if (type.equals("script")) {
            for (PatternItem[] patterns : this.getPatterns(this.getPatternStrings(params))) {
                ScriptRule timeRule = new ScriptRule();
                timeRule.setTimeAnnotator(this);
                ((TimeRule)timeRule).setParameters(ruleParams);
                timeRule.setPatternItems(patterns);
                rules.add(timeRule);
            }
        } else {
            new RuntimeException(type + " is not supported.");
        }
        return rules;
    }

    public List<PatternItem[]> getPatterns(List<String[]> patternStrings) {
        ArrayList<PatternItem[]> result = new ArrayList<PatternItem[]>();
        Pattern regexp = Pattern.compile("\\(regex:(.*)\\)");
        for (String[] patternString : patternStrings) {
            PatternItem[] patternItem = new PatternItem[patternString.length];
            for (int i = 0; i < patternString.length; ++i) {
                if (patternString[i].equals("(number)")) {
                    patternItem[i] = new NumberPattern();
                    continue;
                }
                if (patternString[i].equals("(ordinal)")) {
                    patternItem[i] = new NumberPattern(NumberPattern.Ordinal.MUST);
                    continue;
                }
                if (patternString[i].equals("(year)")) {
                    patternItem[i] = new NumberPattern(this.min_year, this.max_year);
                    continue;
                }
                if (patternString[i].equals("(month)")) {
                    patternItem[i] = new MonthPattern();
                    continue;
                }
                if (patternString[i].equals("(day)")) {
                    patternItem[i] = new NumberPattern(1, 31);
                    continue;
                }
                if (patternString[i].equals("(dow)")) {
                    patternItem[i] = new DayOfWeekPattern();
                    continue;
                }
                if (patternString[i].equals("(time)")) {
                    patternItem[i] = new TimePattern(false);
                    continue;
                }
                if (patternString[i].equals("(duration)")) {
                    patternItem[i] = new TimePattern(true);
                    continue;
                }
                Matcher m = regexp.matcher(patternString[i]);
                if (m.matches()) {
                    Pattern p = Pattern.compile(m.group(1));
                    patternItem[i] = new RegexPattern(p);
                    continue;
                }
                patternItem[i] = new StringPattern(patternString[i]);
            }
            result.add(patternItem);
        }
        return result;
    }

    public List<String[]> getPatternStrings(Map params) {
        ArrayList<String> patterns;
        if (params.containsKey("patterns")) {
            patterns = (ArrayList<String>)params.get("patterns");
        } else if (params.containsKey("pattern")) {
            patterns = new ArrayList<String>(1);
            patterns.add((String)params.get("pattern"));
        } else {
            throw new RuntimeException();
        }
        ArrayList<String[]> result = new ArrayList<String[]>(patterns.size());
        for (String pattern : patterns) {
            result.add(pattern.split("\\s+"));
        }
        return result;
    }

    private int nextOffset(List<Annotation> tokens, int offset, Span span) {
        int i;
        for (i = offset; i < tokens.size() && tokens.get(i).start() < span.end(); ++i) {
        }
        return i;
    }

    public DateTime normalizeMonth(DateTime ref, int month) {
        int refMonth = ref.getMonthOfYear();
        int refYear = ref.getYear();
        DateTime result = ref.withField(DateTimeFieldType.monthOfYear(), month);
        if (refMonth < this.early_month && month > this.late_month) {
            result = result.withField(DateTimeFieldType.year(), refYear - 1);
        } else if (refMonth > this.late_month && month < this.early_month) {
            result = result.withField(DateTimeFieldType.year(), refYear + 1);
        }
        return result;
    }
}

