/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.time.NumberAnnotator;
import edu.nyu.jet.time.TimeAnnotator;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;

public class TimeMain {
    private static final String DOC_DIR = "docs";
    private static final String RESULT_DIR = "result";
    private static final String RULE_FILE = "data/time_rules.yaml";
    private static final Pattern YMDpattern = Pattern.compile("(^|\\D)((199|200|201)\\d{5})($|\\D)");
    public static TimeAnnotator timeAnnotator;

    public static void main(String[] args) throws IOException {
        timeAnnotator = new TimeAnnotator(RULE_FILE);
        File docDir = new File(DOC_DIR);
        File[] docFiles = docDir.listFiles();
        for (int i = 0; i < docFiles.length; ++i) {
            TimeMain.processDocument(docFiles[i]);
        }
    }

    private static void processDocument(File file) throws IOException {
        String content = TimeMain.readFileToString(file);
        Document doc = new Document(content);
        doc.annotateWithTag("DATETIME");
        doc.annotateWithTag("TEXT");
        TimeMain.processDocument(doc);
        File outputDir = new File(RESULT_DIR);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File outputFile = new File(outputDir, file.getName());
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        out.write(doc.writeSGML("TIMEX2").toString());
        ((Writer)out).close();
    }

    public static void processDocument(Document doc) {
        Vector<Annotation> texts;
        DateTime dt;
        Matcher m;
        String docId;
        Vector<Annotation> v = doc.annotationsOfType("DATETIME");
        if (v == null || v.size() == 0) {
            v = doc.annotationsOfType("DATE_TIME");
        }
        NumberAnnotator numberAnnotator = new NumberAnnotator();
        DateTime ref = new DateTime();
        boolean foundDate = false;
        if (v != null && v.size() > 0) {
            Annotation a = v.get(0);
            Tokenizer.tokenize(doc, a.span());
            numberAnnotator.annotate(doc, a.span());
            timeAnnotator.annotate(doc, a.span(), ref);
            Vector<Annotation> times = doc.annotationsOfType("TIMEX2", a.span());
            if (times != null && times.size() > 0) {
                Annotation time = times.get(0);
                if (time.get("VAL") != null) {
                    ref = new DateTime(time.get("VAL"));
                    foundDate = true;
                } else {
                    System.out.println("*** Cannot analyze DATETIME time expression " + doc.text(time));
                }
            } else {
                System.out.println("*** Cannot analyze DATETIME " + doc.text(a));
            }
        }
        if (!foundDate && (docId = Ace.getDocId(doc)) != null && (m = YMDpattern.matcher(docId)).find() && (dt = TimeMain.parseDocIdDate(m.group(2))) != null) {
            ref = dt;
            foundDate = true;
        }
        if (!foundDate) {
            System.out.println("*** Using today's date as reference date.");
        }
        if ((texts = doc.annotationsOfType("TEXT")) == null) {
            Span span = doc.fullSpan();
            if (doc.annotationsOfType("token") == null) {
                Tokenizer.tokenize(doc, span);
            }
            numberAnnotator.annotate(doc, span);
            timeAnnotator.annotate(doc, span, ref);
        } else {
            for (Annotation text : texts) {
                Span span = text.span();
                if (doc.annotationsOfType("token", span) == null) {
                    Tokenizer.tokenize(doc, span);
                }
                numberAnnotator.annotate(doc, span);
                timeAnnotator.annotate(doc, span, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileToString(File file) throws IOException {
        int BUFFER_SIZE = 4096;
        char[] buffer = new char[4096];
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringWriter out = new StringWriter();
        try {
            int readCount;
            while ((readCount = reader.read(buffer)) >= 0) {
                out.write(buffer, 0, readCount);
            }
        }
        finally {
            TimeMain.closeQuitely(reader);
        }
        return out.toString();
    }

    private static void closeQuitely(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static DateTime parseDocIdDate(String str) {
        int year = Integer.parseInt(str.substring(0, 4));
        int month = Integer.parseInt(str.substring(4, 6));
        int day = Integer.parseInt(str.substring(6, 8));
        try {
            return new DateTime(year, month, day, 0, 0, 0, 0);
        }
        catch (IllegalFieldValueException e) {
            return null;
        }
    }
}

