/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.time.PatternItem;
import edu.nyu.jet.time.PatternMatchResult;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimePattern
extends PatternItem {
    private boolean isDuration;

    public TimePattern(boolean isDuration) {
        this.isDuration = isDuration;
    }

    @Override
    public PatternMatchResult match(Document doc, List<Annotation> tokens, int offset) {
        int start = tokens.get(offset).start();
        Vector<Annotation> annotations = doc.annotationsAt(start, "TIMEX2");
        if (annotations == null || annotations.size() == 0) {
            return null;
        }
        Annotation time = (Annotation)annotations.get(0);
        String val = (String)time.get("VAL");
        if (val == null) {
            return null;
        }
        boolean isDuration = val.startsWith("P");
        if (this.isDuration && !isDuration) {
            return null;
        }
        if (!this.isDuration && isDuration) {
            return null;
        }
        return new PatternMatchResult(time, time.span());
    }
}

