/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.time.PatternItem;
import edu.nyu.jet.time.PatternMatchResult;
import edu.nyu.jet.time.TimeAnnotator;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeRule {
    private PatternItem[] patterns;
    private TimeAnnotator timeAnnotator;
    private Map params;

    public abstract void apply(Document var1, List<Object> var2, Span var3, DateTime var4);

    public void setTimeAnnotator(TimeAnnotator timeAnnotator) {
        this.timeAnnotator = timeAnnotator;
    }

    public TimeAnnotator getTimeAnnotator() {
        return this.timeAnnotator;
    }

    public void setPatternItems(PatternItem[] patterns) {
        this.patterns = patterns;
    }

    public PatternItem[] getPatternItems() {
        return this.patterns;
    }

    public void setParameters(Map params) {
        this.params = params;
    }

    public Map getParameters() {
        return this.params;
    }

    public Span matches(Document doc, List<Annotation> tokens, int offset, DateTime ref, List<Object> values) {
        int start;
        int pos = offset;
        int end = start = tokens.get(offset).start();
        for (int i = 0; i < this.patterns.length; ++i) {
            if (pos >= tokens.size()) {
                return null;
            }
            PatternMatchResult result = this.patterns[i].match(doc, tokens, pos);
            if (result == null) {
                return null;
            }
            values.add(result.value);
            pos = this.nextOffset(tokens, pos, result.span);
            end = result.span.end();
        }
        return new Span(start, end);
    }

    protected int nextOffset(List<Annotation> tokens, int offset, Span span) {
        int i;
        for (i = offset; i < tokens.size() && tokens.get(i).start() < span.end(); ++i) {
        }
        return i;
    }

    protected String assignValues(String value, List<Object> values) {
        Pattern regex = Pattern.compile("\\((\\d+)\\)");
        Matcher matcher = regex.matcher(value);
        StringBuilder buffer = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            int offset = Integer.parseInt(matcher.group(1)) - 1;
            buffer.append(value, start, matcher.start());
            buffer.append(values.get(offset));
            start = matcher.end();
        }
        buffer.append(value, start, value.length());
        return buffer.toString();
    }
}

