/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation {
    String type;
    Span span;
    FeatureSet attributes;
    public static final int MAX_ANNOTATION_DEPTH = 2;

    public Annotation(String tp, Span sp, FeatureSet att) {
        this.type = tp;
        this.span = sp;
        this.attributes = att;
    }

    public String type() {
        return this.type;
    }

    public Span span() {
        return this.span;
    }

    public int start() {
        return this.span.start();
    }

    public int end() {
        return this.span.end();
    }

    public FeatureSet attributes() {
        return this.attributes;
    }

    public Object get(String feature) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(feature);
    }

    public void put(String feature, Object value) {
        if (this.attributes == null) {
            this.attributes = new FeatureSet();
        }
        this.attributes.put(feature, value);
    }

    public void remove(String feature) {
        if (this.attributes != null) {
            this.attributes.remove(feature);
        }
    }

    public void assignId() {
        if (this.get("id") != null) {
            return;
        }
        Document doc = this.span.document();
        if (doc == null) {
            System.out.println("Annotation.assignId failed:  null document field in " + this.toString());
            return;
        }
        int id = doc.getNextAnnotationId();
        this.put("id", new Integer(id));
    }

    public int getId() {
        Object id = this.get("id");
        if (id == null) {
            System.out.println("Annotation.getId failed:  no id for Annotation.");
            return 0;
        }
        if (id instanceof Integer) {
            return (Integer)id;
        }
        if (id instanceof String) {
            try {
                return Integer.parseInt((String)id);
            }
            catch (NumberFormatException e) {
                System.out.println("getId:  invalid id attribute " + id);
                return 0;
            }
        }
        System.out.println("getId:  invalid id attribute " + id);
        return 0;
    }

    public void prepareToMakeString(int nestingLimit) {
        if (this.attributes != null) {
            this.attributes.prepareToMakeString(nestingLimit);
        }
    }

    public String toString() {
        if (this.attributes == null) {
            return "<" + this.type + " " + this.span + ">";
        }
        return "<" + this.type + " " + this.span + " " + this.attributes.toSGMLString(2, false, false) + ">";
    }

    public String toSGMLString() {
        return this.toSGMLString(1, true, true);
    }

    public String toSGMLString(int nestingLimit, boolean useIds, boolean quoteValues) {
        if (this.attributes == null || this.attributes.size() == 0) {
            return "<" + this.type + ">";
        }
        return "<" + this.type + " " + this.attributes.toSGMLString(nestingLimit, useIds, quoteValues) + ">";
    }

    public static void sort(Vector annotations) {
        if (annotations == null) {
            return;
        }
        for (int i = 0; i < annotations.size() - 1; ++i) {
            block1: for (int j = i + 1; j < annotations.size(); ++j) {
                Annotation anni = (Annotation)annotations.get(i);
                Annotation annj = (Annotation)annotations.get(j);
                if (anni.span.end() < annj.span.end()) {
                    annotations.set(i, annj);
                    annotations.set(j, anni);
                }
                if (anni.span.end() != annj.span.end() || annj.get("children") == null) continue;
                Annotation[] children = (Annotation[])annj.get("children");
                for (int c = 0; c < children.length; ++c) {
                    if (children[c] != anni) continue;
                    annotations.set(i, annj);
                    annotations.set(j, anni);
                    continue block1;
                }
            }
        }
    }

    public static void sortByStartPosition(List<Annotation> annotations) {
        if (annotations == null) {
            return;
        }
        Collections.sort(annotations, StartPositionComparator.instance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StartPositionComparator
    implements Comparator<Annotation> {
        public static StartPositionComparator instance = new StartPositionComparator();

        private StartPositionComparator() {
        }

        @Override
        public int compare(Annotation a, Annotation b) {
            if (a.start() < b.start()) {
                return -1;
            }
            if (a.start() > b.start()) {
                return 1;
            }
            return 0;
        }
    }
}

