/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import java.util.StringTokenizer;

class AnnotationColorEntry {
    String type;
    String feature;
    String featureValue;
    String color;
    char key;

    AnnotationColorEntry(String tp, String f, String fv, String c, char k) {
        this.type = tp;
        this.feature = f;
        this.featureValue = fv;
        this.color = c;
        this.key = k;
    }

    static AnnotationColorEntry read(String line) {
        String color;
        String feature = null;
        String fv = null;
        char key = ' ';
        StringTokenizer stok = new StringTokenizer(line);
        if (!stok.hasMoreTokens()) {
            return null;
        }
        String annType = stok.nextToken();
        if (stok.countTokens() == 0) {
            color = "0x" + Integer.toHexString(annType.hashCode() & 0xFFFFFF);
        } else {
            String keyString;
            if (stok.countTokens() > 2) {
                feature = stok.nextToken();
                fv = stok.nextToken();
            }
            color = stok.nextToken();
            if (stok.countTokens() > 0 && (keyString = stok.nextToken()).length() > 0) {
                key = keyString.charAt(0);
            }
        }
        return new AnnotationColorEntry(annType, feature, fv, color, key);
    }

    public String toString() {
        if (this.feature == null) {
            return this.type + " " + this.color + " " + this.key;
        }
        return this.type + " " + this.feature + " " + this.featureValue + " " + this.color + " " + this.key;
    }

    public String typeAndFeature() {
        if (this.feature == null) {
            return this.type;
        }
        return this.type + " " + this.feature + " " + this.featureValue;
    }
}

