/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.AnnotationColor;
import edu.nyu.jet.tipster.AnnotationColorEntry;
import edu.nyu.jet.tipster.AnnotationTool;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSplitter;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class CollectionAnnotationTool
extends JFrame {
    AnnotationTool tool;
    String[] types;

    public static void main(String[] args) {
        String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String collectionFile = home + "ACE 05/pre-pilot files.txt";
        String colorFile = "pilot event colors.txt";
        CollectionAnnotationTool jf = new CollectionAnnotationTool(collectionFile, colorFile);
        jf.setDefaultCloseOperation(3);
    }

    public CollectionAnnotationTool(String collectionFile, String colorFile) {
        DocumentCollection col = new DocumentCollection(collectionFile);
        col.open();
        AnnotationColor ac = new AnnotationColor(null, colorFile);
        AnnotationColor.showColors();
        this.createCollectionFrame(col);
        this.tool = new AnnotationTool();
        ArrayList<AnnotationColorEntry> colors = AnnotationColor.colors;
        HashSet<String> typeSet = new HashSet<String>();
        for (int i = 0; i < colors.size(); ++i) {
            AnnotationColorEntry entry = colors.get(i);
            Annotation ann = new Annotation(entry.type, null, new FeatureSet(entry.feature, entry.featureValue));
            char key = entry.key;
            this.tool.addType(key, ann);
            typeSet.add(entry.type);
        }
        this.types = typeSet.toArray(new String[0]);
    }

    private void createCollectionFrame(DocumentCollection col) {
        if (col == null) {
            return;
        }
        int size = col.size();
        Box mainBox = Box.createHorizontalBox();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new GridLayout(size, 1));
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new GridLayout(size, 1));
        mainBox.add(namePanel);
        mainBox.add(buttonPanel1);
        BevelBorder raised = new BevelBorder(0);
        for (int idoc = 0; idoc < size; ++idoc) {
            ExternalDocument doc = col.get(idoc);
            String name = doc.fileName();
            JCheckBox checkBox = new JCheckBox(name);
            namePanel.add(checkBox);
            JButton annotateButton = new JButton("annotate");
            annotateButton.setBorder(raised);
            annotateButton.addActionListener(new DocumentAnnotator(doc, name, checkBox));
            buttonPanel1.add(annotateButton);
        }
        JScrollPane scrollPane = new JScrollPane(mainBox);
        this.getContentPane().add(scrollPane);
        this.setSize(600, Math.min(400, size * 30 + 60));
        this.setTitle("Collection " + col.getName());
        this.setVisible(true);
    }

    public static void task(String[] args) {
        String collectionFile = null;
        String colorFile = null;
        if (args.length == 3) {
            collectionFile = args[1];
            colorFile = args[2];
        } else if (args.length == 1) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Collection to annotate");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal != 0) {
                System.exit(1);
            }
            collectionFile = chooser.getSelectedFile().getPath();
            chooser.setDialogTitle("Color file");
            returnVal = chooser.showOpenDialog(null);
            if (returnVal != 0) {
                System.exit(1);
            }
            colorFile = chooser.getSelectedFile().getPath();
        } else {
            System.out.println("AnnotateCollection requires 2 arguments: jet -AnnotateCollection <collection> <color file>");
            System.exit(1);
        }
        CollectionAnnotationTool jf = new CollectionAnnotationTool(collectionFile, colorFile);
        jf.setDefaultCloseOperation(3);
    }

    private class DocumentAnnotator
    implements ActionListener {
        ExternalDocument doc;
        String documentName;
        JCheckBox checkBox;

        private DocumentAnnotator(ExternalDocument d, String dName, JCheckBox cb) {
            this.doc = d;
            this.documentName = dName;
            this.checkBox = cb;
        }

        public void actionPerformed(ActionEvent ev) {
            Thread annotatorThread = new Thread(){

                public void run() {
                    DocumentAnnotator.this.doc.setSGMLtags(CollectionAnnotationTool.this.types);
                    DocumentAnnotator.this.doc.open();
                    DocumentAnnotator.this.doc.annotateWithTag("TEXT");
                    Vector<Annotation> textSegments = DocumentAnnotator.this.doc.annotationsOfType("TEXT");
                    if (textSegments == null || textSegments.size() == 0) {
                        return;
                    }
                    Annotation text = textSegments.get(0);
                    Span textSpan = text.span();
                    SentenceSplitter.split(DocumentAnnotator.this.doc, textSpan);
                    Vector<Annotation> sentences = DocumentAnnotator.this.doc.annotationsOfType("sentence");
                    if (sentences == null) {
                        return;
                    }
                    for (Annotation sentence : sentences) {
                        Span sentenceSpan = sentence.span();
                        Tokenizer.tokenize(DocumentAnnotator.this.doc, sentenceSpan);
                    }
                    CollectionAnnotationTool.this.tool.annotateDocument(DocumentAnnotator.this.doc, textSpan);
                    DocumentAnnotator.this.checkBox.setSelected(true);
                    DocumentAnnotator.this.doc.removeAnnotationsOfType("token");
                    DocumentAnnotator.this.doc.setSGMLwrapMargin(0);
                    DocumentAnnotator.this.doc.save();
                }
            };
            annotatorThread.start();
        }
    }
}

