/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.refres.CorefFilter;
import edu.nyu.jet.refres.EntityView;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.View;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class CollectionView
extends JFrame {
    public CollectionView(DocumentCollection col) {
        this(col, false);
    }

    private CollectionView(DocumentCollection col, boolean createEntities) {
        if (col == null) {
            return;
        }
        int size = col.size();
        Box mainBox = Box.createHorizontalBox();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new GridLayout(size, 1));
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new GridLayout(size, 1));
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setLayout(new GridLayout(size, 1));
        mainBox.add(namePanel);
        mainBox.add(buttonPanel1);
        mainBox.add(buttonPanel2);
        BevelBorder raised = new BevelBorder(0);
        for (int idoc = 0; idoc < size; ++idoc) {
            ExternalDocument doc = col.get(idoc);
            String name = doc.fileName();
            JLabel documentName = new JLabel(name);
            namePanel.add(documentName);
            JButton viewButton = new JButton("view annotations");
            viewButton.setBorder(raised);
            viewButton.addActionListener(new ViewCreator(doc, name, false, createEntities));
            buttonPanel1.add(viewButton);
            boolean entitiesDiffer = doc.annotationsOfType("entitiesDiffer") != null;
            JButton viewEntities = new JButton("view entities" + (entitiesDiffer ? "*" : ""));
            viewEntities.setBorder(raised);
            viewEntities.addActionListener(new ViewCreator(doc, name, true, createEntities));
            buttonPanel2.add(viewEntities);
        }
        JScrollPane scrollPane = new JScrollPane(mainBox);
        this.getContentPane().add(scrollPane);
        this.setSize(600, 400);
        this.setTitle("Collection " + col.getName());
        this.setVisible(true);
    }

    public static void main(String[] args) {
        String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        DocumentCollection col = new DocumentCollection(home + "ACE/training nwire coref.txt");
        col.open();
        new CollectionView(col, true);
    }

    public static void task(String[] args) {
        String encoding = null;
        String file = null;
        if (args.length == 4 && args[1].equals("-encoding")) {
            encoding = args[2];
            file = args[3];
        } else if (args.length == 2) {
            file = args[1];
        } else {
            System.out.println("CollectionView requires 1 argument: jet -CollectionView [-encoding e] <collection>");
            System.exit(1);
        }
        if (encoding != null && !JetTest.setEncoding(encoding)) {
            System.exit(1);
        }
        DocumentCollection col = new DocumentCollection(file);
        col.open();
        new CollectionView(col, true);
    }

    private class ViewCreator
    implements ActionListener {
        ExternalDocument doc;
        String documentName;
        boolean showEntities;
        boolean createEntities;

        private ViewCreator(ExternalDocument d, String dName, boolean se, boolean ce) {
            this.doc = d;
            this.showEntities = se;
            this.createEntities = ce;
        }

        public void actionPerformed(ActionEvent ev) {
            this.doc.setAllTags(true);
            this.doc.open();
            if (this.showEntities) {
                if (this.createEntities && this.doc.annotationsOfType("entity") == null) {
                    CorefFilter.buildEntitiesFromMentions(this.doc);
                }
                new EntityView(this.doc, 0);
            } else {
                new View(this.doc, 0);
            }
        }
    }
}

