/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class DocumentCollection {
    String fileName;
    String directory;
    ArrayList documents;
    boolean open;
    static final String DEFAULT_DOC_TYPE = "sgml";

    public DocumentCollection(String fileName) {
        this.fileName = fileName;
        this.directory = null;
        this.documents = new ArrayList();
        this.open = false;
    }

    public DocumentCollection(String directory, String fileName) {
        this.fileName = fileName;
        this.directory = directory;
        this.documents = new ArrayList();
        this.open = false;
    }

    public boolean open() {
        if (this.open) {
            return true;
        }
        try {
            String line;
            File collectionFile = new File(this.fileName);
            String collectionDirectory = this.directory != null ? this.directory : collectionFile.getParent();
            BufferedReader reader = new BufferedReader(new FileReader(collectionFile));
            while ((line = reader.readLine()) != null) {
                int pos = line.indexOf(124);
                if (pos != 0 && pos < line.length() - 1) {
                    String docFileName;
                    String docType;
                    if (pos > 0) {
                        docType = line.substring(0, pos);
                        docFileName = line.substring(pos + 1);
                    } else {
                        docType = DEFAULT_DOC_TYPE;
                        docFileName = line;
                    }
                    File docFile = new File(docFileName);
                    if (docFile.isAbsolute()) {
                        this.documents.add(new ExternalDocument(docType, docFileName));
                        continue;
                    }
                    this.documents.add(new ExternalDocument(docType, collectionDirectory, docFileName));
                    continue;
                }
                System.out.println("Error opening collection " + this.fileName);
                System.out.println("Invalid line: " + line);
                return false;
            }
            this.open = true;
            return true;
        }
        catch (IOException e) {
            System.out.println("Error opening collection " + this.fileName);
            System.out.println(e);
            return false;
        }
    }

    public void save() {
        for (int i = 0; i < this.documents.size(); ++i) {
            ExternalDocument doc = (ExternalDocument)this.documents.get(i);
            doc.save();
        }
    }

    public void saveAs(String newFileName) {
        File collectionFile = new File(newFileName);
        String collectionDirectory = this.directory != null ? this.directory : collectionFile.getParent();
        this.saveAs(newFileName, collectionDirectory);
    }

    public void saveAs(String newFileName, String collectionDirectory) {
        try {
            File collectionFile = new File(newFileName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(collectionFile));
            for (int i = 0; i < this.documents.size(); ++i) {
                ExternalDocument doc = (ExternalDocument)this.documents.get(i);
                doc.saveIn(collectionDirectory);
                String format = doc.format();
                writer.write(format, 0, format.length());
                writer.write("|", 0, 1);
                String docFileName = doc.fileName();
                writer.write(docFileName, 0, docFileName.length());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Error saving collection " + this.fileName);
            System.out.println(e);
        }
    }

    public void saveAsAbsolute(String newFileName, String collectionDirectory) {
        try {
            File collectionFile = new File(newFileName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(collectionFile));
            for (int i = 0; i < this.documents.size(); ++i) {
                ExternalDocument doc = (ExternalDocument)this.documents.get(i);
                doc.saveIn(collectionDirectory);
                String format = doc.format();
                writer.write(format, 0, format.length());
                writer.write("|", 0, 1);
                String docFileName = doc.fullFileName();
                writer.write(docFileName, 0, docFileName.length());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Error saving collection " + this.fileName);
            System.out.println(e);
        }
    }

    public int size() {
        return this.documents.size();
    }

    public ExternalDocument get(int i) {
        return (ExternalDocument)this.documents.get(i);
    }

    public String getName() {
        return new File(this.fileName).getName();
    }
}

