/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.tipster.Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class MakeCollection {
    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("MakeCollection must have 4 arguments: \ninput-file collection-file collection-directory file-extension");
            System.exit(1);
        }
        String inputFileName = args[0];
        String collectionFileName = args[1];
        String directory = args[2];
        String ext = args[3];
        Vector<String> files = new Vector<String>(100);
        try {
            Document doc;
            BufferedReader rdr = new BufferedReader(new FileReader(inputFileName));
            File collectionFile = new File(collectionFileName);
            while ((doc = JetTest.readDocument(rdr)) != null) {
                if (JetTest.docId == "") {
                    System.out.println("Error:  document without <DOCID>");
                    continue;
                }
                if (doc.text().contains("type=\"advis\"") || doc.text().contains("type=\"other\"")) continue;
                String docFileName = JetTest.docId + "." + ext;
                files.add(docFileName);
                File docFile = new File(directory, docFileName);
                PrintWriter docStream = new PrintWriter(new FileWriter(docFile));
                docStream.println(doc.text());
                docStream.close();
            }
            PrintWriter colStream = new PrintWriter(new FileWriter(collectionFile));
            for (int i = 0; i < files.size(); ++i) {
                colStream.println((String)files.get(i));
            }
            colStream.close();
        }
        catch (IOException ioe) {
            System.err.println("IO Error in MakeCollection: " + ioe);
            System.exit(1);
        }
    }
}

