/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.parser.ParseView;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.AnnotationColor;
import edu.nyu.jet.tipster.Document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class View
extends JFrame {
    protected Document document;
    protected JSplitPane jSplitPaneTop = new JSplitPane();
    private JSplitPane jSplitPaneMain = new JSplitPane(0);
    protected JTextPaneX jTextPane = new JTextPaneX();
    private JTextArea jTextArea = new JTextArea();
    private JScrollPane jScrollPaneLeft = new JScrollPane();
    private JScrollPane jScrollPaneRight = new JScrollPane();
    private JScrollPane jScrollPaneBottom = new JScrollPane();
    private JPanel jPanelLeft = new JPanel();
    private JPanel jPanelRight = new JPanel();
    private JPanel jPanelBottom = new JPanel();
    private Annotation parse = null;

    public View(Document doc, int docNo) {
        this.document = doc;
        try {
            this.jbInit(this.document.getAnnotationTypes(), "types");
            this.setTitle("Jet Document " + docNo);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            int n = (screenSize.width - frameSize.width) / 30;
            this.setLocation(30 * (docNo % n), 20 * (docNo % n));
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected View() {
    }

    protected void jbInit(Object[] list, String listTitle) throws Exception {
        JList<Object> jList = new JList<Object>(list);
        jList.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                View.this.jListValueChanged(evt);
            }
        });
        this.jScrollPaneLeft.getViewport().add(jList);
        this.jPanelLeft.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), listTitle));
        this.jPanelLeft.setLayout(new BorderLayout());
        this.jPanelLeft.add((Component)this.jScrollPaneLeft, "Center");
        this.jTextPane.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextPane.setEditable(false);
        this.jTextPane.setFont(new Font("dialog", 0, 12));
        this.jTextPane.setText(this.document.text().toString());
        this.jTextPane.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                View.this.jTextPaneCaretUpdate(evt);
            }
        });
        Keymap keymap = JTextComponent.addKeymap("AnnotationToolMap", null);
        KeyStroke p = KeyStroke.getKeyStroke('p');
        keymap.addActionForKeyStroke(p, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                View.this.displayParse();
            }
        });
        this.jTextPane.setKeymap(keymap);
        this.jScrollPaneRight.getViewport().add(this.jTextPane);
        this.jPanelRight.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Annotated Document"));
        this.jPanelRight.setLayout(new BorderLayout());
        this.jPanelRight.add((Component)this.jScrollPaneRight, "Center");
        this.jSplitPaneTop.setLeftComponent(this.jPanelLeft);
        this.jSplitPaneTop.setRightComponent(this.jPanelRight);
        this.jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextArea.setEditable(false);
        this.jTextArea.setText("Select a region to see annotations.");
        this.jScrollPaneBottom.getViewport().add(this.jTextArea);
        this.jPanelBottom.setPreferredSize(new Dimension(600, 80));
        this.jPanelBottom.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Annotations"));
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.add((Component)this.jScrollPaneBottom, "Center");
        this.jSplitPaneMain.setTopComponent(this.jSplitPaneTop);
        this.jSplitPaneMain.setBottomComponent(this.jPanelBottom);
        this.jSplitPaneMain.setResizeWeight(0.8);
        this.setSize(600, 400);
        this.getContentPane().add((Component)this.jSplitPaneMain, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                View.this.dispose();
            }
        });
    }

    private void jTextPaneCaretUpdate(CaretEvent evt) {
        StringBuffer annBuffer = new StringBuffer();
        int dot = evt.getDot();
        int mark = evt.getMark();
        this.parse = null;
        for (int pos = Math.min(dot, mark); pos < Math.max(dot, mark); ++pos) {
            Vector<Annotation> annotationsAtCaret = this.document.annotationsAt(pos);
            if (annotationsAtCaret == null) continue;
            for (Annotation ann : annotationsAtCaret) {
                annBuffer.append(ann.toString() + "\n");
                if (this.parse != null || ann.get("parse") == null) continue;
                this.parse = (Annotation)ann.get("parse");
                annBuffer.append("[type 'p' in document window to display parse]\n");
            }
        }
        String annText = annBuffer.toString();
        if (annText.length() == 0) {
            annText = "No annotations found in the selected region.";
        }
        this.jTextArea.setText(annText);
    }

    private void displayParse() {
        if (this.parse != null) {
            new ParseView("parse", this.parse);
        }
    }

    protected void jListValueChanged(ListSelectionEvent evt) {
        int i;
        if (evt.getValueIsAdjusting()) {
            return;
        }
        JList theList = (JList)evt.getSource();
        Object[] types = this.document.getAnnotationTypes();
        for (i = 0; i < types.length; ++i) {
            if (theList.isSelectedIndex(i)) continue;
            this.bleach((String)types[i]);
        }
        types = theList.getSelectedValues();
        for (i = 0; i < types.length; ++i) {
            this.highlight((String)types[i]);
        }
    }

    public void highlight(String type) {
        AnnotationColor.addType(type);
        this.setAnnotationAttribute(type, null);
    }

    public void bleach(String type) {
        SimpleAttributeSet bleached = new SimpleAttributeSet();
        this.setAnnotationAttribute(type, bleached);
    }

    public void setAnnotationAttribute(String annType, SimpleAttributeSet atrSet) {
        this.setAnnotationAttribute(this.document.annotationsOfType(annType), atrSet);
    }

    public void setAnnotationAttribute(Vector annotations, SimpleAttributeSet atrSet) {
        if (annotations != null && !annotations.isEmpty()) {
            StyledDocument styleDocument = this.jTextPane.getStyledDocument();
            for (Annotation ann : annotations) {
                SimpleAttributeSet highlighting;
                if (atrSet != null) {
                    highlighting = atrSet;
                } else {
                    highlighting = new SimpleAttributeSet();
                    Color color = AnnotationColor.getColor(ann);
                    StyleConstants.setBackground(highlighting, color);
                    StyleConstants.setBold(highlighting, true);
                }
                int start = ann.span().start();
                int length = ann.span().endNoWS(this.document) - start;
                styleDocument.setCharacterAttributes(start, length, highlighting, true);
            }
        }
    }

    protected class JTextPaneX
    extends JTextPane {
        private ArrayList startPoint = new ArrayList();
        private ArrayList endPoint = new ArrayList();
        private ArrayList color = new ArrayList();

        protected JTextPaneX() {
        }

        public void clearLines() {
            this.startPoint = new ArrayList();
            this.endPoint = new ArrayList();
            this.color = new ArrayList();
        }

        public void addLine(Point start, Point end) {
            this.addLine(start, end, Color.BLUE);
        }

        public void addLine(Point start, Point end, Color clr) {
            this.startPoint.add(start);
            this.endPoint.add(end);
            this.color.add(clr);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            for (int i = 0; i < this.startPoint.size(); ++i) {
                Point start = (Point)this.startPoint.get(i);
                Point end = (Point)this.endPoint.get(i);
                Color clr = (Color)this.color.get(i);
                g.setColor(clr);
                int offset = clr == Color.RED ? 2 : 0;
                g.drawLine(start.x + offset, start.y, end.x + offset, end.y);
                g.drawLine(start.x + 1 + offset, start.y, end.x + 1 + offset, end.y);
            }
        }
    }
}

