/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.util;

import edu.nyu.jet.util.Cdb;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class CdbBuilder {
    private String filename;
    private String tmpFilename;
    private RandomAccessFile file;
    private List<List<HashPointer>> bucket;

    public CdbBuilder(String filename, String tmpFilename) throws IOException {
        this.filename = filename;
        this.tmpFilename = tmpFilename;
        this.file = new RandomAccessFile(tmpFilename, "rw");
        this.bucket = new ArrayList<List<HashPointer>>(256);
        for (int i = 0; i < 256; ++i) {
            this.bucket.add(new ArrayList());
        }
        this.file.seek(2048L);
    }

    public void add(byte[] key, int koff, int klen, byte[] value, int voff, int vlen) throws IOException {
        int p = (int)this.file.getFilePointer();
        CdbBuilder.writeIntInLittleEndian(this.file, klen);
        CdbBuilder.writeIntInLittleEndian(this.file, vlen);
        this.file.write(key, koff, klen);
        this.file.write(value, voff, vlen);
        int h = Cdb.hash(key, koff, klen);
        this.bucket.get(h & 0xFF).add(new HashPointer(h, p));
    }

    public void add(byte[] key, byte[] value) throws IOException {
        int p = (int)this.file.getFilePointer();
        CdbBuilder.writeIntInLittleEndian(this.file, key.length);
        CdbBuilder.writeIntInLittleEndian(this.file, value.length);
        this.file.write(key);
        this.file.write(value);
        int h = Cdb.hash(key, 0, key.length);
        this.bucket.get(h & 0xFF).add(new HashPointer(h, p));
    }

    public void finish() throws IOException {
        int pos_hash = (int)this.file.getFilePointer();
        for (List<HashPointer> b1 : this.bucket) {
            if (b1.size() == 0) continue;
            int ncells = b1.size() * 2;
            HashPointer[] cell = new HashPointer[ncells];
            for (int i = 0; i < cell.length; ++i) {
                cell[i] = new HashPointer(0, 0);
            }
            for (HashPointer pair : b1) {
                int i = (pair.h >>> 8) % ncells;
                while (cell[i].p != 0) {
                    i = (i + 1) % ncells;
                }
                cell[i] = pair;
            }
            for (HashPointer pair : cell) {
                CdbBuilder.writeIntInLittleEndian(this.file, pair.h);
                CdbBuilder.writeIntInLittleEndian(this.file, pair.p);
            }
        }
        this.file.seek(0L);
        for (List<HashPointer> b1 : this.bucket) {
            CdbBuilder.writeIntInLittleEndian(this.file, pos_hash);
            CdbBuilder.writeIntInLittleEndian(this.file, b1.size() * 2);
            pos_hash += b1.size() * 2 * 8;
        }
        this.file.close();
        File fromFile = new File(this.tmpFilename);
        File toFile = new File(this.filename);
        fromFile.renameTo(toFile);
    }

    private static void writeIntInLittleEndian(RandomAccessFile file, int n) throws IOException {
        file.write((byte)n & 0xFF);
        file.write((byte)(n >> 8 & 0xFF));
        file.write((byte)(n >> 16 & 0xFF));
        file.write((byte)(n >> 24 & 0xFF));
    }

    private static final class HashPointer {
        int h;
        int p;

        public HashPointer(int h, int p) {
            this.h = h;
            this.p = p;
        }
    }
}

