/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.util;

import edu.nyu.jet.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayTrie {
    int[] base = new int[0];
    int[] check = new int[0];
    MappedByteBuffer map = null;
    boolean[] used;
    int size;
    int alloc_size = 0;
    char[][] keys;
    int[] length;
    int[] val;
    int next_check_pos;
    int progress;
    int error;

    private void resize(int newSize) {
        this.base = this.resize(this.base, this.alloc_size, newSize);
        this.check = this.resize(this.check, this.alloc_size, newSize);
        this.used = this.resize(this.used, this.alloc_size, newSize);
        this.alloc_size = newSize;
    }

    private <T> T resize(T array, int oldSize, int newSize) {
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        System.arraycopy(array, 0, newArray, 0, Math.min(oldSize, newSize));
        return (T)newArray;
    }

    private int fetch(Node parent, List<Node> siblings) {
        if (this.error < 0) {
            return 0;
        }
        int prev = 0;
        for (int i = parent.left; i < parent.right; ++i) {
            if (this.keys[i].length < parent.depth) continue;
            char[] tmp = this.keys[i];
            int cur = 0;
            if (this.keys[i].length != parent.depth) {
                cur = tmp[parent.depth] + '\u0001';
            }
            if (prev > cur) {
                this.error = -3;
                return 0;
            }
            if (cur != prev || siblings.isEmpty()) {
                Node tmpNode = new Node();
                tmpNode.depth = parent.depth + 1;
                tmpNode.code = cur;
                tmpNode.left = i;
                if (!siblings.isEmpty()) {
                    siblings.get((int)(siblings.size() - 1)).right = i;
                }
                siblings.add(tmpNode);
            }
            prev = cur;
        }
        if (!siblings.isEmpty()) {
            siblings.get((int)(siblings.size() - 1)).right = parent.right;
        }
        return siblings.size();
    }

    private int insert(List<Node> siblings) {
        int i;
        if (this.error < 0) {
            return 0;
        }
        int begin = 0;
        int pos = Math.max(siblings.get((int)0).code + 1, this.next_check_pos) - 1;
        int nonzero_num = 0;
        boolean first = false;
        if (this.alloc_size <= pos) {
            this.resize(pos + 1);
        }
        block0: while (true) {
            if (this.alloc_size <= ++pos) {
                this.resize(pos + 1);
            }
            if (this.getCheck(pos) != 0) {
                ++nonzero_num;
                continue;
            }
            if (!first) {
                this.next_check_pos = pos;
                first = true;
            }
            if (this.alloc_size <= (begin = pos - siblings.get((int)0).code) + siblings.get((int)(siblings.size() - 1)).code) {
                this.resize((int)((double)this.alloc_size * Math.max(1.05, 1.0 * (double)this.keys.length / (double)this.progress)));
            }
            if (this.used[begin]) continue;
            for (i = 1; i < siblings.size(); ++i) {
                if (this.getCheck(begin + siblings.get((int)i).code) == 0) continue;
                continue block0;
            }
            break;
        }
        if (1.0 * (double)nonzero_num / (double)(pos - this.next_check_pos + 1) >= 0.95) {
            this.next_check_pos = pos;
        }
        this.used[begin] = true;
        this.size = Math.max(this.size, begin + siblings.get((int)(siblings.size() - 1)).code + 1);
        for (i = 0; i < siblings.size(); ++i) {
            this.setCheck(begin + siblings.get((int)i).code, begin);
        }
        for (i = 0; i < siblings.size(); ++i) {
            ArrayList<Node> new_siblings = new ArrayList<Node>();
            if (this.fetch(siblings.get(i), new_siblings) == 0) {
                int x = this.val != null ? -this.val[siblings.get((int)i).left] - 1 : -siblings.get((int)i).left - 1;
                this.setBase(begin + siblings.get((int)i).code, x);
                if (this.val != null && -this.val[siblings.get((int)i).left] - 1 >= 0) {
                    this.error = -2;
                    return 0;
                }
                ++this.progress;
                continue;
            }
            int h = this.insert(new_siblings);
            this.setBase(begin + siblings.get((int)i).code, h);
        }
        return begin;
    }

    public boolean build(char[][] key, int[] value) {
        this.keys = key;
        this.val = value;
        this.progress = 0;
        this.used = new boolean[this.alloc_size];
        this.length = new int[key.length];
        for (int i = 0; i < key.length; ++i) {
            this.length[i] = key[i].length;
        }
        this.resize(8192);
        this.setBase(0, 1);
        this.next_check_pos = 0;
        Node rootNode = new Node();
        rootNode.left = 0;
        rootNode.right = key.length;
        rootNode.depth = 0;
        ArrayList<Node> siblings = new ArrayList<Node>();
        this.fetch(rootNode, siblings);
        this.insert(siblings);
        this.size += 65537;
        if (this.size >= this.alloc_size) {
            this.resize(this.size);
        }
        this.used = null;
        return this.error >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) throws IOException {
        RandomAccessFile file = null;
        AbstractInterruptibleChannel channel = null;
        try {
            int i;
            file = new RandomAccessFile(filename, "rw");
            int size = this.alloc_size * 8;
            file.setLength(size);
            channel = file.getChannel();
            MappedByteBuffer map = ((FileChannel)channel).map(FileChannel.MapMode.READ_WRITE, 0L, size);
            map.order(ByteOrder.LITTLE_ENDIAN);
            for (i = 0; i < this.alloc_size; ++i) {
                map.putInt(this.getBase(i));
            }
            for (i = 0; i < this.alloc_size; ++i) {
                map.putInt(this.getCheck(i));
            }
            file.setLength(map.position());
        }
        finally {
            if (channel != null) {
                channel.close();
            } else if (file != null) {
                file.close();
            }
        }
    }

    public void load(String filename) throws IOException {
        this.load(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        RandomAccessFile raf = null;
        FileChannel channel = null;
        try {
            raf = new RandomAccessFile(file, "r");
            channel = raf.getChannel();
            this.map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
            this.map.order(ByteOrder.LITTLE_ENDIAN);
            this.alloc_size = (int)(raf.length() / 8L);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(channel);
            IOUtils.closeQuietly(raf);
            throw throwable;
        }
        IOUtils.closeQuietly(channel);
        IOUtils.closeQuietly(raf);
    }

    public int exactMatchSearch(CharSequence key, int offset, int length, int nodePos) {
        int p;
        int b = this.getBase(nodePos);
        int result = -1;
        for (int i = 0; i < length; ++i) {
            p = b + key.charAt(offset + i) + 1;
            if (b != this.getCheck(p)) {
                return result;
            }
            b = this.getBase(p);
        }
        p = b;
        int n = this.getBase(p);
        if (b == this.getCheck(p) && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    public int exactMatchSearch(CharSequence key, int offset, int length) {
        return this.exactMatchSearch(key, offset, length, 0);
    }

    public int exactMatchSearch(CharSequence key, int offset) {
        return this.exactMatchSearch(key, offset, key.length() - offset, 0);
    }

    public int exactMatchSearch(CharSequence key) {
        return this.exactMatchSearch(key, 0, key.length(), 0);
    }

    public List<Result> commonPrefixSearch(CharSequence key, int offset, int length, int nodePos) {
        int n;
        int p;
        int b = this.getBase(nodePos);
        ArrayList<Result> result = new ArrayList<Result>();
        for (int i = 0; i < length; ++i) {
            p = b;
            n = this.getBase(p);
            if (b == this.getCheck(p) && n < 0) {
                result.add(new Result(-n - 1, i));
            }
            if (b != this.getCheck(p = b + key.charAt(offset + i) + 1)) {
                return result;
            }
            b = this.getBase(p);
        }
        p = b;
        n = this.getBase(p);
        if (b == this.getCheck(p) && n < 0) {
            result.add(new Result(-n - 1, length));
        }
        return result;
    }

    public List<Result> commonPrefixSearch(CharSequence key, int offset, int length) {
        return this.commonPrefixSearch(key, offset, length, 0);
    }

    public List<Result> commonPrefixSearch(CharSequence key, int offset) {
        return this.commonPrefixSearch(key, offset, key.length() - offset, 0);
    }

    public List<Result> commonPrefixSearch(CharSequence key) {
        return this.commonPrefixSearch(key, 0, key.length(), 0);
    }

    public Result getLongestCommonPrefix(CharSequence key, int offset, int length, int nodePos) {
        int n;
        int p;
        int b = this.getBase(nodePos);
        int resultVal = -1;
        int resultLen = -1;
        for (int i = 0; i < length; ++i) {
            p = b;
            n = this.getBase(p);
            if (b == this.getCheck(p) && n < 0) {
                resultVal = -n - 1;
                resultLen = i;
            }
            if (b != this.getCheck(p = b + key.charAt(offset + i) + 1)) {
                if (resultLen < 0) {
                    return null;
                }
                return new Result(resultVal, resultLen);
            }
            b = this.getBase(p);
        }
        p = b;
        n = this.getBase(p);
        if (b == this.getCheck(p) && n < 0) {
            resultVal = -n - 1;
            resultLen = length;
        }
        if (resultLen > 0) {
            return new Result(resultVal, resultLen);
        }
        return null;
    }

    public Result getLongestCommonPrefix(CharSequence key, int offset, int length) {
        return this.getLongestCommonPrefix(key, offset, length, 0);
    }

    public Result getLongestCommonPrefix(CharSequence key, int offset) {
        return this.getLongestCommonPrefix(key, offset, key.length() - offset, 0);
    }

    public Result getLongestCommonPrefix(CharSequence key) {
        return this.getLongestCommonPrefix(key, 0, key.length(), 0);
    }

    private int getBase(int index) {
        if (this.map != null) {
            int offset = index * 32 / 8;
            this.map.position(offset);
            return this.map.getInt();
        }
        return this.base[index];
    }

    private void setBase(int index, int value) {
        this.base[index] = value;
    }

    private int getCheck(int index) {
        if (this.map != null) {
            int offset = this.alloc_size * 32 / 8 + index * 32 / 8;
            this.map.position(offset);
            return this.map.getInt();
        }
        return this.check[index];
    }

    private void setCheck(int index, int value) {
        this.check[index] = value;
    }

    public static final class Result {
        private int value;
        private int length;

        Result(int value, int length) {
            this.value = value;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getValue() {
            return this.value;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Result) {
                Result other = (Result)obj;
                return this.value == other.value && this.length == other.length;
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[value=");
            builder.append(this.value);
            builder.append(", length=");
            builder.append(this.length);
            builder.append("]");
            return builder.toString();
        }
    }

    private static class Node {
        int code;
        int depth;
        int left;
        int right;

        private Node() {
        }
    }
}

