/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String encoding) throws IOException {
        String string;
        InputStream in = null;
        InputStreamReader reader = null;
        try {
            int ch;
            in = new FileInputStream(file);
            in = new BufferedInputStream(in);
            reader = new InputStreamReader(in, encoding);
            StringBuilder buffer = new StringBuilder();
            while ((ch = ((Reader)reader).read()) != -1) {
                buffer.append((char)ch);
            }
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String encoding, CharSequence content) throws IOException {
        OutputStream out = null;
        OutputStreamWriter writer = null;
        try {
            out = new FileOutputStream(file);
            out = new BufferedOutputStream(out);
            writer = new OutputStreamWriter(out, encoding);
            ((Writer)writer).append(content);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        IOUtils.closeQuietly(out);
    }

    public static BufferedWriter getBufferedWriter(File file, Charset charset) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static BufferedWriter getBufferedWriter(File file, String encoding) throws FileNotFoundException {
        Charset charset = Charset.forName(encoding);
        return IOUtils.getBufferedWriter(file, charset);
    }

    public static BufferedReader getBufferedReader(File file, Charset charset) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedReader getBufferedReader(File file, String encoding) throws FileNotFoundException {
        Charset charset = Charset.forName(encoding);
        return IOUtils.getBufferedReader(file, charset);
    }
}

