/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.fst;

import edu.umass.cs.mallet.base.fst.CRF;
import edu.umass.cs.mallet.base.fst.Transducer;
import edu.umass.cs.mallet.base.fst.TransducerEvaluator;
import edu.umass.cs.mallet.base.maximize.LimitedMemoryBFGS;
import edu.umass.cs.mallet.base.maximize.Maximizable;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.DenseVector;
import edu.umass.cs.mallet.base.types.ExpGain;
import edu.umass.cs.mallet.base.types.FeatureInducer;
import edu.umass.cs.mallet.base.types.FeatureSelection;
import edu.umass.cs.mallet.base.types.FeatureSequence;
import edu.umass.cs.mallet.base.types.FeatureVector;
import edu.umass.cs.mallet.base.types.FeatureVectorSequence;
import edu.umass.cs.mallet.base.types.GradientGain;
import edu.umass.cs.mallet.base.types.IndexedSparseVector;
import edu.umass.cs.mallet.base.types.InfoGain;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.InstanceList;
import edu.umass.cs.mallet.base.types.Label;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import edu.umass.cs.mallet.base.types.LabelSequence;
import edu.umass.cs.mallet.base.types.LabelVector;
import edu.umass.cs.mallet.base.types.Matrix;
import edu.umass.cs.mallet.base.types.MatrixOps;
import edu.umass.cs.mallet.base.types.RankedFeatureVector;
import edu.umass.cs.mallet.base.types.Sequence;
import edu.umass.cs.mallet.base.types.SparseVector;
import edu.umass.cs.mallet.base.util.ArrayUtils;
import edu.umass.cs.mallet.base.util.MalletLogger;
import edu.umass.cs.mallet.base.util.Maths;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CRF4
extends Transducer
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(CRF.class.getName());
    static final double DEFAULT_GAUSSIAN_PRIOR_VARIANCE = 1.0;
    static final double DEFAULT_HYPERBOLIC_PRIOR_SLOPE = 0.2;
    static final double DEFAULT_HYPERBOLIC_PRIOR_SHARPNESS = 10.0;
    static final String LABEL_SEPARATOR = ",";
    Alphabet inputAlphabet;
    Alphabet outputAlphabet;
    ArrayList states = new ArrayList();
    ArrayList initialStates = new ArrayList();
    HashMap name2state = new HashMap();
    SparseVector[] weights;
    SparseVector[] constraints;
    SparseVector[] expectations;
    double[] defaultWeights;
    double[] defaultConstraints;
    double[] defaultExpectations;
    BitSet[] weightsPresent;
    FeatureSelection globalFeatureSelection;
    FeatureSelection[] featureSelections;
    boolean[] weightsFrozen;
    Alphabet weightAlphabet = new Alphabet();
    boolean trainable = false;
    boolean gatheringConstraints = false;
    boolean gatheringWeightsPresent = false;
    boolean usingHyperbolicPrior = false;
    double gaussianPriorVariance = 1.0;
    double hyperbolicPriorSlope = 0.2;
    double hyperbolicPriorSharpness = 10.0;
    boolean useSparseWeights = true;
    private transient boolean useSomeUnsupportedTrick = true;
    private boolean cachedValueStale = true;
    private boolean cachedGradientStale = true;
    protected boolean someTrainingDone = false;
    private int transductionType = 0;
    ArrayList featureInducers = new ArrayList();
    public boolean printGradient = false;
    public static final int VITERBI = 0;
    public static final int VITERBI_FBEAM = 1;
    public static final int VITERBI_BBEAM = 2;
    public static final int VITERBI_FBBEAM = 3;
    public static final int VITERBI_FBEAMKL = 4;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 4;
    static final int NULL_INTEGER = -1;

    public CRF4(Pipe inputPipe, Pipe outputPipe) {
        this.inputPipe = inputPipe;
        this.outputPipe = outputPipe;
        this.inputAlphabet = inputPipe.getDataAlphabet();
        this.outputAlphabet = inputPipe.getTargetAlphabet();
    }

    public CRF4(Alphabet inputAlphabet, Alphabet outputAlphabet) {
        inputAlphabet.stopGrowth();
        logger.info("CRF input dictionary size = " + inputAlphabet.size());
        this.inputAlphabet = inputAlphabet;
        this.outputAlphabet = outputAlphabet;
    }

    public CRF4(CRF4 other) {
        this(other.getInputPipe(), other.getOutputPipe());
        this.copyStatesAndWeightsFrom(other);
        this.assertWeightsLength();
    }

    private void copyStatesAndWeightsFrom(CRF4 initialCRF) {
        this.weightAlphabet = (Alphabet)initialCRF.weightAlphabet.clone();
        this.weights = new SparseVector[initialCRF.weights.length];
        this.states.clear();
        int i = 0;
        while (i < initialCRF.states.size()) {
            State s = (State)initialCRF.getState(i);
            String[][] weightNames = new String[s.weightsIndices.length][];
            int j = 0;
            while (j < weightNames.length) {
                int[] thisW = s.weightsIndices[j];
                weightNames[j] = (String[])initialCRF.weightAlphabet.lookupObjects(thisW, new String[s.weightsIndices[j].length]);
                ++j;
            }
            this.addState(s.name, s.initialCost, s.finalCost, s.destinationNames, s.labels, weightNames);
            ++i;
        }
        assert (this.weights.length > 0);
        this.defaultWeights = (double[])initialCRF.defaultWeights.clone();
        i = 0;
        while (i < this.weights.length) {
            Object wname = this.weightAlphabet.lookupObject(i);
            int otherIndex = initialCRF.weightAlphabet.lookupIndex(wname);
            this.weights[i] = (SparseVector)initialCRF.weights[otherIndex].cloneMatrix();
            ++i;
        }
        this.featureSelections = (FeatureSelection[])initialCRF.featureSelections.clone();
        this.weightsFrozen = (boolean[])initialCRF.weightsFrozen.clone();
    }

    public Alphabet getInputAlphabet() {
        return this.inputAlphabet;
    }

    public Alphabet getOutputAlphabet() {
        return this.outputAlphabet;
    }

    public void setUseHyperbolicPrior(boolean f) {
        this.usingHyperbolicPrior = f;
    }

    public void setHyperbolicPriorSlope(double p) {
        this.hyperbolicPriorSlope = p;
    }

    public void setHyperbolicPriorSharpness(double p) {
        this.hyperbolicPriorSharpness = p;
    }

    public double getUseHyperbolicPriorSlope() {
        return this.hyperbolicPriorSlope;
    }

    public double getUseHyperbolicPriorSharpness() {
        return this.hyperbolicPriorSharpness;
    }

    public void setGaussianPriorVariance(double p) {
        this.gaussianPriorVariance = p;
    }

    public double getGaussianPriorVariance() {
        return this.gaussianPriorVariance;
    }

    public void setUseSparseWeights(boolean b) {
        this.useSparseWeights = b;
    }

    public boolean getUseSparseWeights() {
        return this.useSparseWeights;
    }

    public void setUseSomeUnsupportedTrick(boolean b) {
        this.useSomeUnsupportedTrick = b;
    }

    public int getTransductionType() {
        return this.transductionType;
    }

    public void setTransductionType(int transductionType) {
        this.transductionType = transductionType;
    }

    protected State newState(String name, int index, double initialCost, double finalCost, String[] destinationNames, String[] labelNames, String[][] weightNames, CRF4 crf) {
        return new State(name, index, initialCost, finalCost, destinationNames, labelNames, weightNames, crf);
    }

    public void addState(String name, double initialCost, double finalCost, String[] destinationNames, String[] labelNames, String[][] weightNames) {
        assert (weightNames.length == destinationNames.length);
        assert (labelNames.length == destinationNames.length);
        this.setTrainable(false);
        if (this.name2state.get(name) != null) {
            throw new IllegalArgumentException("State with name `" + name + "' already exists.");
        }
        State s = this.newState(name, this.states.size(), initialCost, finalCost, destinationNames, labelNames, weightNames, this);
        s.print();
        this.states.add(s);
        if (initialCost < Double.POSITIVE_INFINITY) {
            this.initialStates.add(s);
        }
        this.name2state.put(name, s);
    }

    public void addState(String name, double initialCost, double finalCost, String[] destinationNames, String[] labelNames, String[] weightNames) {
        String[][] newWeightNames = new String[weightNames.length][1];
        int i = 0;
        while (i < weightNames.length) {
            newWeightNames[i][0] = weightNames[i];
            ++i;
        }
        this.addState(name, initialCost, finalCost, destinationNames, labelNames, newWeightNames);
    }

    public void addState(String name, double initialCost, double finalCost, String[] destinationNames, String[] labelNames) {
        assert (destinationNames.length == labelNames.length);
        String[] weightNames = new String[labelNames.length];
        int i = 0;
        while (i < labelNames.length) {
            weightNames[i] = String.valueOf(name) + "->" + destinationNames[i] + ":" + labelNames[i];
            ++i;
        }
        this.addState(name, initialCost, finalCost, destinationNames, labelNames, weightNames);
    }

    public void addState(String name, String[] destinationNames) {
        this.addState(name, 0.0, 0.0, destinationNames, destinationNames);
    }

    public void addFullyConnectedStates(String[] stateNames) {
        int i = 0;
        while (i < stateNames.length) {
            this.addState(stateNames[i], stateNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            ++i;
        }
        this.addFullyConnectedStates(labels);
    }

    public void addStartState() {
        this.addStartState("<START>");
    }

    public void addStartState(String name) {
        int i = 0;
        while (i < this.numStates()) {
            this.getState((int)i).initialCost = Double.POSITIVE_INFINITY;
            ++i;
        }
        String[] dests = new String[this.numStates()];
        int i2 = 0;
        while (i2 < dests.length) {
            dests[i2] = this.getState(i2).getName();
            ++i2;
        }
        this.addState(name, 0.0, Double.POSITIVE_INFINITY, dests, dests);
    }

    public void setAsStartState(State state) {
        int i = 0;
        while (i < this.numStates()) {
            Transducer.State other = this.getState(i);
            if (other == state) {
                other.setInitialCost(0.0);
            } else {
                other.setInitialCost(Double.POSITIVE_INFINITY);
            }
            ++i;
        }
    }

    private boolean[][] labelConnectionsIn(InstanceList trainingSet) {
        return this.labelConnectionsIn(trainingSet, null);
    }

    private boolean[][] labelConnectionsIn(InstanceList trainingSet, String start) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = new boolean[numLabels][numLabels];
        int i = 0;
        while (i < trainingSet.size()) {
            Instance instance = trainingSet.getInstance(i);
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            int j = 1;
            while (j < output.size()) {
                int sourceIndex = this.outputAlphabet.lookupIndex(output.get(j - 1));
                int destIndex = this.outputAlphabet.lookupIndex(output.get(j));
                assert (sourceIndex >= 0 && destIndex >= 0);
                connections[sourceIndex][destIndex] = true;
                ++j;
            }
            ++i;
        }
        if (start != null) {
            int startIndex = this.outputAlphabet.lookupIndex(start);
            int j = 0;
            while (j < this.outputAlphabet.size()) {
                connections[startIndex][j] = true;
                ++j;
            }
        }
        return connections;
    }

    public void addStatesForLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j2);
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), destinationNames);
            ++i;
        }
    }

    public void addStatesForHalfLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j2);
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames, destinationNames);
            ++i;
        }
    }

    public void addStatesForThreeQuarterLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            String[][] weightNames = new String[numDestinations][];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    String wn;
                    String labelName;
                    destinationNames[destinationIndex] = labelName = (String)this.outputAlphabet.lookupObject(j2);
                    weightNames[destinationIndex] = new String[2];
                    weightNames[destinationIndex][0] = labelName;
                    weightNames[destinationIndex][1] = wn = String.valueOf((String)this.outputAlphabet.lookupObject(i)) + "->" + (String)this.outputAlphabet.lookupObject(j2);
                    int wi = this.getWeightsIndex(wn);
                    this.featureSelections[wi] = new FeatureSelection(trainingSet.getDataAlphabet());
                    ++destinationIndex;
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames, weightNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForThreeQuarterLabels(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        int i = 0;
        while (i < numLabels) {
            String[] destinationNames = new String[numLabels];
            String[][] weightNames = new String[numLabels][];
            int j = 0;
            while (j < numLabels) {
                String wn;
                String labelName;
                destinationNames[j] = labelName = (String)this.outputAlphabet.lookupObject(j);
                weightNames[j] = new String[2];
                weightNames[j][0] = labelName;
                weightNames[j][1] = wn = String.valueOf((String)this.outputAlphabet.lookupObject(i)) + "->" + (String)this.outputAlphabet.lookupObject(j);
                int wi = this.getWeightsIndex(wn);
                this.featureSelections[wi] = new FeatureSelection(trainingSet.getDataAlphabet());
                ++j;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames, weightNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForBiLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            ++i;
        }
        i = 0;
        while (i < labels.length) {
            int j = 0;
            while (j < labels.length) {
                String[] destinationNames = new String[labels.length];
                int k = 0;
                while (k < labels.length) {
                    destinationNames[k] = String.valueOf(labels[j]) + LABEL_SEPARATOR + labels[k];
                    ++k;
                }
                this.addState(String.valueOf(labels[i]) + LABEL_SEPARATOR + labels[j], 0.0, 0.0, destinationNames, labels);
                ++j;
            }
            ++i;
        }
    }

    public void addStatesForBiLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    int numDestinations = 0;
                    int k = 0;
                    while (k < numLabels) {
                        if (connections[j][k]) {
                            ++numDestinations;
                        }
                        ++k;
                    }
                    String[] destinationNames = new String[numDestinations];
                    String[] labels = new String[numDestinations];
                    int destinationIndex = 0;
                    int k2 = 0;
                    while (k2 < numLabels) {
                        if (connections[j][k2]) {
                            destinationNames[destinationIndex] = String.valueOf((String)this.outputAlphabet.lookupObject(j)) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(k2);
                            labels[destinationIndex] = (String)this.outputAlphabet.lookupObject(k2);
                            ++destinationIndex;
                        }
                        ++k2;
                    }
                    this.addState(String.valueOf((String)this.outputAlphabet.lookupObject(i)) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(j), 0.0, 0.0, destinationNames, labels);
                }
                ++j;
            }
            ++i;
        }
    }

    public void addFullyConnectedStatesForTriLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            ++i;
        }
        i = 0;
        while (i < labels.length) {
            int j = 0;
            while (j < labels.length) {
                int k = 0;
                while (k < labels.length) {
                    String[] destinationNames = new String[labels.length];
                    int l = 0;
                    while (l < labels.length) {
                        destinationNames[l] = String.valueOf(labels[j]) + LABEL_SEPARATOR + labels[k] + LABEL_SEPARATOR + labels[l];
                        ++l;
                    }
                    this.addState(String.valueOf(labels[i]) + LABEL_SEPARATOR + labels[j] + LABEL_SEPARATOR + labels[k], 0.0, 0.0, destinationNames, labels);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addSelfTransitioningStateForAllLabels(String name) {
        String[] labels = new String[this.outputAlphabet.size()];
        String[] destinationNames = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            destinationNames[i] = name;
            ++i;
        }
        this.addState(name, 0.0, 0.0, destinationNames, labels);
    }

    private String concatLabels(String[] labels) {
        String sep = "";
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < labels.length) {
            buf.append(sep).append(labels[i]);
            sep = LABEL_SEPARATOR;
            ++i;
        }
        return buf.toString();
    }

    private String nextKGram(String[] history, int k, String next) {
        int start;
        String sep = "";
        StringBuffer buf = new StringBuffer();
        int i = start = history.length + 1 - k;
        while (i < history.length) {
            buf.append(sep).append(history[i]);
            sep = LABEL_SEPARATOR;
            ++i;
        }
        buf.append(sep).append(next);
        return buf.toString();
    }

    private boolean allowedTransition(String prev, String curr, Pattern no, Pattern yes) {
        String pair = this.concatLabels(new String[]{prev, curr});
        if (no != null && no.matcher(pair).matches()) {
            return false;
        }
        return yes == null || yes.matcher(pair).matches();
    }

    private boolean allowedHistory(String[] history, Pattern no, Pattern yes) {
        int i = 1;
        while (i < history.length) {
            if (!this.allowedTransition(history[i - 1], history[i], no, yes)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String addOrderNStates(InstanceList trainingSet, int[] orders, boolean[] defaults, String start, Pattern forbidden, Pattern allowed, boolean fullyConnected) {
        boolean[][] connections = null;
        if (start != null) {
            this.outputAlphabet.lookupIndex(start);
        }
        if (!fullyConnected) {
            connections = this.labelConnectionsIn(trainingSet, start);
        }
        int order = -1;
        if (defaults != null && defaults.length != orders.length) {
            throw new IllegalArgumentException("Defaults must be null or match orders");
        }
        if (orders == null) {
            order = 0;
        } else {
            int i = 0;
            while (i < orders.length) {
                if (orders[i] <= order) {
                    throw new IllegalArgumentException("Orders must be non-negative and in ascending order");
                }
                order = orders[i];
                ++i;
            }
            if (order < 0) {
                order = 0;
            }
        }
        if (order > 0) {
            int[] historyIndexes = new int[order];
            String[] history = new String[order];
            String label0 = (String)this.outputAlphabet.lookupObject(0);
            int i = 0;
            while (i < order) {
                history[i] = label0;
                ++i;
            }
            int numLabels = this.outputAlphabet.size();
            block2: while (historyIndexes[0] < numLabels) {
                logger.info("Preparing " + this.concatLabels(history));
                if (this.allowedHistory(history, forbidden, allowed)) {
                    String stateName = this.concatLabels(history);
                    int nt = 0;
                    String[] destNames = new String[numLabels];
                    String[] labelNames = new String[numLabels];
                    String[][] weightNames = new String[numLabels][orders.length];
                    int nextIndex = 0;
                    while (nextIndex < numLabels) {
                        String next = (String)this.outputAlphabet.lookupObject(nextIndex);
                        if (this.allowedTransition(history[order - 1], next, forbidden, allowed) && (fullyConnected || connections[historyIndexes[order - 1]][nextIndex])) {
                            destNames[nt] = this.nextKGram(history, order, next);
                            labelNames[nt] = next;
                            int i2 = 0;
                            while (i2 < orders.length) {
                                weightNames[nt][i2] = this.nextKGram(history, orders[i2] + 1, next);
                                if (defaults != null && defaults[i2]) {
                                    int wi = this.getWeightsIndex(weightNames[nt][i2]);
                                    this.featureSelections[wi] = new FeatureSelection(trainingSet.getDataAlphabet());
                                }
                                ++i2;
                            }
                            ++nt;
                        }
                        ++nextIndex;
                    }
                    if (nt < numLabels) {
                        String[] newDestNames = new String[nt];
                        String[] newLabelNames = new String[nt];
                        String[][] newWeightNames = new String[nt][];
                        int t = 0;
                        while (t < nt) {
                            newDestNames[t] = destNames[t];
                            newLabelNames[t] = labelNames[t];
                            newWeightNames[t] = weightNames[t];
                            ++t;
                        }
                        destNames = newDestNames;
                        labelNames = newLabelNames;
                        weightNames = newWeightNames;
                    }
                    int i3 = 0;
                    while (i3 < destNames.length) {
                        StringBuffer b = new StringBuffer();
                        int j = 0;
                        while (j < orders.length) {
                            b.append(" ").append(weightNames[i3][j]);
                            ++j;
                        }
                        logger.info(String.valueOf(stateName) + "->" + destNames[i3] + "(" + labelNames[i3] + ")" + b.toString());
                        ++i3;
                    }
                    this.addState(stateName, 0.0, 0.0, destNames, labelNames, weightNames);
                }
                int o = order - 1;
                while (o >= 0) {
                    int n = o;
                    historyIndexes[n] = historyIndexes[n] + 1;
                    if (historyIndexes[n] < numLabels) {
                        history[o] = (String)this.outputAlphabet.lookupObject(historyIndexes[o]);
                        continue block2;
                    }
                    if (o > 0) {
                        historyIndexes[o] = 0;
                        history[o] = label0;
                    }
                    --o;
                }
            }
            int i4 = 0;
            while (i4 < order) {
                history[i4] = start;
                ++i4;
            }
            return this.concatLabels(history);
        }
        String[] stateNames = new String[this.outputAlphabet.size()];
        int s = 0;
        while (s < this.outputAlphabet.size()) {
            stateNames[s] = (String)this.outputAlphabet.lookupObject(s);
            ++s;
        }
        s = 0;
        while (s < this.outputAlphabet.size()) {
            this.addState(stateNames[s], 0.0, 0.0, stateNames, stateNames, stateNames);
            ++s;
        }
        return start;
    }

    public State getState(String name) {
        return (State)this.name2state.get(name);
    }

    public void setWeights(int weightsIndex, SparseVector transitionWeights) {
        this.cachedGradientStale = true;
        this.cachedValueStale = true;
        if (weightsIndex >= this.weights.length || weightsIndex < 0) {
            throw new IllegalArgumentException("weightsIndex " + weightsIndex + " is out of bounds");
        }
        this.weights[weightsIndex] = transitionWeights;
    }

    public void setWeights(String weightName, SparseVector transitionWeights) {
        this.setWeights(this.getWeightsIndex(weightName), transitionWeights);
    }

    public String getWeightsName(int weightIndex) {
        return (String)this.weightAlphabet.lookupObject(weightIndex);
    }

    public SparseVector getWeights(String weightName) {
        return this.weights[this.getWeightsIndex(weightName)];
    }

    public SparseVector getWeights(int weightIndex) {
        return this.weights[weightIndex];
    }

    public double[] getDefaultWeights() {
        return this.defaultWeights;
    }

    public SparseVector[] getWeights() {
        return this.weights;
    }

    public void setWeights(SparseVector[] m) {
        this.weights = m;
    }

    public void setDefaultWeights(double[] w) {
        this.defaultWeights = w;
    }

    public void setDefaultWeight(int widx, double val) {
        this.defaultWeights[widx] = val;
    }

    public void freezeWeights(int weightsIndex) {
        this.weightsFrozen[weightsIndex] = true;
    }

    public void freezeWeights(String weightsName) {
        int widx = this.getWeightsIndex(weightsName);
        this.freezeWeights(widx);
    }

    public void unfreezeWeights(String weightsName) {
        int widx = this.getWeightsIndex(weightsName);
        this.weightsFrozen[widx] = false;
    }

    public void setFeatureSelection(int weightIdx, FeatureSelection fs) {
        this.featureSelections[weightIdx] = fs;
    }

    public void setWeightsDimensionAsIn(InstanceList trainingData) {
        int numWeights = 0;
        this.cachedGradientStale = true;
        this.cachedValueStale = true;
        this.setTrainable(false);
        this.weightsPresent = new BitSet[this.weights.length];
        int i = 0;
        while (i < this.weights.length) {
            this.weightsPresent[i] = new BitSet();
            ++i;
        }
        this.gatheringWeightsPresent = true;
        i = 0;
        while (i < this.weights.length) {
            int j = this.weights[i].numLocations() - 1;
            while (j >= 0) {
                this.weightsPresent[i].set(this.weights[i].indexAtLocation(j));
                --j;
            }
            ++i;
        }
        if (this.someTrainingDone) {
            System.err.println("Some training done previously");
        }
        i = 0;
        while (i < trainingData.size()) {
            Instance instance = trainingData.getInstance(i);
            FeatureVectorSequence input = (FeatureVectorSequence)instance.getData();
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            this.gatheringConstraints = true;
            this.forwardBackward((Sequence)input, (Sequence)output, true);
            this.gatheringConstraints = false;
            if (this.someTrainingDone && this.useSomeUnsupportedTrick) {
                logger.info("CRF4: Incremental training detected.  Adding weights for some supported features...");
                this.forwardBackward((Sequence)input, null, true);
            }
            ++i;
        }
        this.gatheringWeightsPresent = false;
        SparseVector[] newWeights = new SparseVector[this.weights.length];
        int i2 = 0;
        while (i2 < this.weights.length) {
            int numLocations = this.weightsPresent[i2].cardinality();
            logger.info("CRF weights[" + this.weightAlphabet.lookupObject(i2) + "] num features = " + numLocations);
            int[] indices = new int[numLocations];
            int j = 0;
            while (j < numLocations) {
                indices[j] = this.weightsPresent[i2].nextSetBit(j == 0 ? 0 : indices[j - 1] + 1);
                ++j;
            }
            newWeights[i2] = new IndexedSparseVector(indices, new double[numLocations], numLocations, numLocations, false, false, false);
            newWeights[i2].plusEqualsSparse(this.weights[i2]);
            numWeights += numLocations + 1;
            ++i2;
        }
        logger.info("Number of weights = " + numWeights);
        this.weights = newWeights;
    }

    public void setWeightsDimensionDensely() {
        SparseVector[] newWeights = new SparseVector[this.weights.length];
        int max = this.inputAlphabet.size();
        int numWeights = 0;
        logger.info("CRF using dense weights, num input features = " + max);
        int i = 0;
        while (i < this.weights.length) {
            int nfeatures;
            if (this.featureSelections[i] == null) {
                nfeatures = max;
                newWeights[i] = new SparseVector(null, new double[max], max, max, false, false, false);
            } else {
                FeatureSelection fs = this.featureSelections[i];
                nfeatures = fs.getBitSet().cardinality();
                int[] idxs = new int[nfeatures];
                int j = 0;
                int thisIdx = -1;
                while ((thisIdx = fs.nextSelectedIndex(thisIdx + 1)) >= 0) {
                    idxs[j++] = thisIdx;
                }
                newWeights[i] = new SparseVector(idxs, new double[nfeatures], nfeatures, nfeatures, false, false, false);
            }
            newWeights[i].plusEqualsSparse(this.weights[i]);
            numWeights += nfeatures + 1;
            ++i;
        }
        logger.info("Number of weights = " + numWeights);
        this.weights = newWeights;
    }

    public int getWeightsIndex(String weightName) {
        int wi = this.weightAlphabet.lookupIndex(weightName);
        if (wi == -1) {
            throw new IllegalArgumentException("Alphabet frozen, and no weight with name " + weightName);
        }
        if (this.weights == null) {
            assert (wi == 0);
            this.weights = new SparseVector[1];
            this.defaultWeights = new double[1];
            this.featureSelections = new FeatureSelection[1];
            this.weightsFrozen = new boolean[1];
            this.weights[0] = new IndexedSparseVector();
            this.defaultWeights[0] = 0.0;
            this.featureSelections[0] = null;
        } else if (wi == this.weights.length) {
            SparseVector[] newWeights = new SparseVector[this.weights.length + 1];
            double[] newDefaultWeights = new double[this.weights.length + 1];
            FeatureSelection[] newFeatureSelections = new FeatureSelection[this.weights.length + 1];
            int i = 0;
            while (i < this.weights.length) {
                newWeights[i] = this.weights[i];
                newDefaultWeights[i] = this.defaultWeights[i];
                newFeatureSelections[i] = this.featureSelections[i];
                ++i;
            }
            newWeights[wi] = new IndexedSparseVector();
            newDefaultWeights[wi] = 0.0;
            newFeatureSelections[wi] = null;
            this.weights = newWeights;
            this.defaultWeights = newDefaultWeights;
            this.featureSelections = newFeatureSelections;
            this.weightsFrozen = ArrayUtils.append(this.weightsFrozen, false);
        }
        this.setTrainable(false);
        return wi;
    }

    private void assertWeightsLength() {
        if (this.weights != null) {
            assert (this.defaultWeights != null);
            assert (this.featureSelections != null);
            assert (this.weightsFrozen != null);
            int n = this.weights.length;
            assert (this.defaultWeights.length == n);
            assert (this.featureSelections.length == n);
            assert (this.weightsFrozen.length == n);
        }
    }

    public int numStates() {
        return this.states.size();
    }

    public Transducer.State getState(int index) {
        return (Transducer.State)this.states.get(index);
    }

    public Iterator initialStateIterator() {
        return this.initialStates.iterator();
    }

    public boolean isTrainable() {
        return this.trainable;
    }

    public void setTrainable(boolean f) {
        if (f != this.trainable) {
            int i;
            if (f) {
                this.constraints = new SparseVector[this.weights.length];
                this.expectations = new SparseVector[this.weights.length];
                this.defaultConstraints = new double[this.weights.length];
                this.defaultExpectations = new double[this.weights.length];
                i = 0;
                while (i < this.weights.length) {
                    this.constraints[i] = (SparseVector)this.weights[i].cloneMatrixZeroed();
                    this.expectations[i] = (SparseVector)this.weights[i].cloneMatrixZeroed();
                    ++i;
                }
            } else {
                this.expectations = null;
                this.constraints = null;
                this.defaultExpectations = null;
                this.defaultConstraints = null;
            }
            i = 0;
            while (i < this.numStates()) {
                ((State)this.getState(i)).setTrainable(f);
                ++i;
            }
            this.trainable = f;
        }
    }

    public double getParametersAbsNorm() {
        double ret = 0.0;
        int i = 0;
        while (i < this.numStates()) {
            State s = (State)this.getState(i);
            ret += Math.abs(s.initialCost);
            ret += Math.abs(s.finalCost);
            ++i;
        }
        i = 0;
        while (i < this.weights.length) {
            ret += Math.abs(this.defaultWeights[i]);
            ret += this.weights[i].absNorm();
            ++i;
        }
        return ret;
    }

    public void setParameter(int sourceStateIndex, int destStateIndex, int featureIndex, double value) {
        this.cachedGradientStale = true;
        this.cachedValueStale = true;
        State source = (State)this.getState(sourceStateIndex);
        State dest = (State)this.getState(destStateIndex);
        int rowIndex = 0;
        while (rowIndex < source.destinationNames.length) {
            if (source.destinationNames[rowIndex].equals(dest.name)) break;
            ++rowIndex;
        }
        if (rowIndex == source.destinationNames.length) {
            throw new IllegalArgumentException("No transtition from state " + sourceStateIndex + " to state " + destStateIndex + ".");
        }
        int weightsIndex = source.weightsIndices[rowIndex][0];
        if (featureIndex < 0) {
            this.defaultWeights[weightsIndex] = value;
        } else {
            this.weights[weightsIndex].setValue(featureIndex, value);
        }
        this.someTrainingDone = true;
    }

    public double getParameter(int sourceStateIndex, int destStateIndex, int featureIndex, double value) {
        State source = (State)this.getState(sourceStateIndex);
        State dest = (State)this.getState(destStateIndex);
        int rowIndex = 0;
        while (rowIndex < source.destinationNames.length) {
            if (source.destinationNames[rowIndex].equals(dest.name)) break;
            ++rowIndex;
        }
        if (rowIndex == source.destinationNames.length) {
            throw new IllegalArgumentException("No transtition from state " + sourceStateIndex + " to state " + destStateIndex + ".");
        }
        int weightsIndex = source.weightsIndices[rowIndex][0];
        if (featureIndex < 0) {
            return this.defaultWeights[weightsIndex];
        }
        return this.weights[weightsIndex].value(featureIndex);
    }

    public void reset() {
        throw new UnsupportedOperationException("Not used in CRFs");
    }

    public void estimate() {
        if (!this.trainable) {
            throw new IllegalStateException("This transducer not currently trainable.");
        }
        throw new UnsupportedOperationException("Not yet implemented.  Never?");
    }

    public Sequence transduce(Object unpipedInput) {
        Instance inst = new Instance(unpipedInput, null, null, null, this.inputPipe);
        return this.transduce((FeatureVectorSequence)inst.getData());
    }

    public Sequence transduce(Sequence input) {
        if (!(input instanceof FeatureVectorSequence)) {
            throw new IllegalArgumentException("CRF4.transduce requires FeatureVectorSequence.  This may be relaxed later...");
        }
        switch (this.transductionType) {
            case 0: {
                Transducer.ViterbiPath lattice = this.viterbiPath(input);
                return lattice.output();
            }
            case 1: {
                Transducer.ViterbiPathBeam lattice2 = this.viterbiPathBeam(input);
                return lattice2.output();
            }
            case 2: {
                Transducer.ViterbiPathBeamB lattice3 = this.viterbiPathBeamB(input);
                return lattice3.output();
            }
            case 3: {
                Transducer.ViterbiPathBeamFB lattice4 = this.viterbiPathBeamFB(input);
                return lattice4.output();
            }
            case 4: {
                Transducer.ViterbiPathBeamKL lattice5 = this.viterbiPathBeamKL(input);
                return lattice5.output();
            }
        }
        throw new IllegalStateException("Unknown CRF4 transuction type " + this.transductionType);
    }

    public void print() {
        this.print(new PrintWriter((Writer)new OutputStreamWriter(System.out), true));
    }

    public void print(PrintWriter out) {
        out.println("*** CRF STATES ***");
        int i = 0;
        while (i < this.numStates()) {
            State s = (State)this.getState(i);
            out.print("STATE NAME=\"");
            out.print(s.name);
            out.print("\" (");
            out.print(s.destinations.length);
            out.print(" outgoing transitions)\n");
            out.print("  ");
            out.print("initialCost = ");
            out.print(s.initialCost);
            out.print('\n');
            out.print("  ");
            out.print("finalCost = ");
            out.print(s.finalCost);
            out.print('\n');
            out.println("  transitions:");
            int j = 0;
            while (j < s.destinations.length) {
                out.print("    ");
                out.print(s.name);
                out.print(" -> ");
                out.println(s.getDestinationState(j).getName());
                int k = 0;
                while (k < s.weightsIndices[j].length) {
                    out.print("        WEIGHTS = \"");
                    int widx = s.weightsIndices[j][k];
                    out.print(this.weightAlphabet.lookupObject(widx).toString());
                    out.print("\"\n");
                    ++k;
                }
                ++j;
            }
            out.println();
            ++i;
        }
        out.println("\n\n\n*** CRF WEIGHTS ***");
        int widx = 0;
        while (widx < this.weights.length) {
            out.println("WEIGHTS NAME = " + this.weightAlphabet.lookupObject(widx));
            out.print(": <DEFAULT_FEATURE> = ");
            out.print(this.defaultWeights[widx]);
            out.print('\n');
            SparseVector transitionWeights = this.weights[widx];
            if (transitionWeights.numLocations() != 0) {
                RankedFeatureVector rfv = new RankedFeatureVector(this.inputAlphabet, transitionWeights);
                int m = 0;
                while (m < rfv.numLocations()) {
                    double v = rfv.getValueAtRank(m);
                    int index = rfv.indexAtLocation(rfv.getIndexAtRank(m));
                    Object feature = this.inputAlphabet.lookupObject(index);
                    if (v != 0.0) {
                        out.print(": ");
                        out.print(feature);
                        out.print(" = ");
                        out.println(v);
                    }
                    ++m;
                }
            }
            ++widx;
        }
        out.flush();
    }

    public boolean train(InstanceList ilist) {
        return this.train(ilist, null, null);
    }

    public boolean train(InstanceList ilist, InstanceList validation, InstanceList testing) {
        return this.train(ilist, validation, testing, null);
    }

    public boolean train(InstanceList ilist, InstanceList validation, InstanceList testing, TransducerEvaluator eval) {
        return this.train(ilist, validation, testing, eval, 9999);
    }

    public boolean train(InstanceList ilist, InstanceList validation, InstanceList testing, TransducerEvaluator eval, int numIterations) {
        if (numIterations <= 0) {
            return false;
        }
        assert (ilist.size() > 0);
        if (this.useSparseWeights) {
            this.setWeightsDimensionAsIn(ilist);
        } else {
            this.setWeightsDimensionDensely();
        }
        MaximizableCRF mc = new MaximizableCRF(ilist, this);
        LimitedMemoryBFGS maximizer = new LimitedMemoryBFGS();
        boolean continueTraining = true;
        boolean converged = false;
        logger.info("CRF about to train with " + numIterations + " iterations");
        int i = 0;
        while (i < numIterations) {
            try {
                this.setCurIter(i);
                converged = maximizer.maximize(mc, 1);
                logger.info("CRF took " + this.tctIter + " intermediate iterations");
                logger.info("CRF finished one iteration of maximizer, i=" + i);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                logger.info("Catching exception; saying converged.");
                converged = true;
            }
            if (eval != null && !(continueTraining = eval.evaluate(this, converged || i == numIterations - 1, i, converged, mc.getValue(), ilist, validation, testing))) break;
            if (converged) {
                logger.info("CRF training has converged, i=" + i);
                break;
            }
            ++i;
        }
        logger.info("About to setTrainable(false)");
        this.setTrainable(false);
        logger.info("Done setTrainable(false)");
        return converged;
    }

    public boolean train(InstanceList training, InstanceList validation, InstanceList testing, TransducerEvaluator eval, int numIterations, int numIterationsPerProportion, double[] trainingProportions) {
        int trainingIteration = 0;
        int i = 0;
        while (i < trainingProportions.length) {
            InstanceList theTrainingData = training;
            if (trainingProportions != null && i < trainingProportions.length) {
                logger.info("Training on " + trainingProportions[i] + "% of the data this round.");
                InstanceList[] sampledTrainingData = training.split(new Random(1L), new double[]{trainingProportions[i], 1.0 - trainingProportions[i]});
                theTrainingData = sampledTrainingData[0];
            }
            boolean converged = this.train(theTrainingData, validation, testing, eval, numIterationsPerProportion);
            trainingIteration += numIterationsPerProportion;
            ++i;
        }
        logger.info("Training on 100% of the data this round, for " + (numIterations - trainingIteration) + " iterations.");
        return this.train(training, validation, testing, eval, numIterations - trainingIteration);
    }

    public boolean trainWithFeatureInduction(InstanceList trainingData, InstanceList validationData, InstanceList testingData, TransducerEvaluator eval, int numIterations, int numIterationsBetweenFeatureInductions, int numFeatureInductions, int numFeaturesPerFeatureInduction, double trueLabelProbThreshold, boolean clusteredFeatureInduction, double[] trainingProportions) {
        return this.trainWithFeatureInduction(trainingData, validationData, testingData, eval, numIterations, numIterationsBetweenFeatureInductions, numFeatureInductions, numFeaturesPerFeatureInduction, trueLabelProbThreshold, clusteredFeatureInduction, trainingProportions, "exp");
    }

    public boolean trainWithFeatureInduction(InstanceList trainingData, InstanceList validationData, InstanceList testingData, TransducerEvaluator eval, int numIterations, int numIterationsBetweenFeatureInductions, int numFeatureInductions, int numFeaturesPerFeatureInduction, double trueLabelProbThreshold, boolean clusteredFeatureInduction, double[] trainingProportions, String gainName) {
        int trainingIteration = 0;
        int numLabels = this.outputAlphabet.size();
        this.globalFeatureSelection = trainingData.getFeatureSelection();
        if (this.globalFeatureSelection == null) {
            this.globalFeatureSelection = new FeatureSelection(trainingData.getDataAlphabet());
            trainingData.setFeatureSelection(this.globalFeatureSelection);
        }
        if (validationData != null) {
            validationData.setFeatureSelection(this.globalFeatureSelection);
        }
        if (testingData != null) {
            testingData.setFeatureSelection(this.globalFeatureSelection);
        }
        int featureInductionIteration = 0;
        while (featureInductionIteration < numFeatureInductions) {
            logger.info("Feature induction iteration " + featureInductionIteration);
            InstanceList theTrainingData = trainingData;
            if (trainingProportions != null && featureInductionIteration < trainingProportions.length) {
                logger.info("Training on " + trainingProportions[featureInductionIteration] + "% of the data this round.");
                InstanceList[] sampledTrainingData = trainingData.split(new Random(1L), new double[]{trainingProportions[featureInductionIteration], 1.0 - trainingProportions[featureInductionIteration]});
                theTrainingData = sampledTrainingData[0];
                theTrainingData.setFeatureSelection(this.globalFeatureSelection);
                logger.info("  which is " + theTrainingData.size() + " instances");
            }
            boolean converged = false;
            if (featureInductionIteration != 0) {
                converged = this.train(theTrainingData, validationData, testingData, eval, numIterationsBetweenFeatureInductions);
            }
            trainingIteration += numIterationsBetweenFeatureInductions;
            this.print();
            logger.info("Starting feature induction with " + this.inputAlphabet.size() + " features.");
            InstanceList errorInstances = new InstanceList(trainingData.getDataAlphabet(), trainingData.getTargetAlphabet());
            errorInstances.setFeatureSelection(this.globalFeatureSelection);
            ArrayList<LabelVector> errorLabelVectors = new ArrayList<LabelVector>();
            InstanceList[][] clusteredErrorInstances = new InstanceList[numLabels][numLabels];
            ArrayList[][] clusteredErrorLabelVectors = new ArrayList[numLabels][numLabels];
            int i = 0;
            while (i < numLabels) {
                int j = 0;
                while (j < numLabels) {
                    clusteredErrorInstances[i][j] = new InstanceList(trainingData.getDataAlphabet(), trainingData.getTargetAlphabet());
                    clusteredErrorInstances[i][j].setFeatureSelection(this.globalFeatureSelection);
                    clusteredErrorLabelVectors[i][j] = new ArrayList();
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < theTrainingData.size()) {
                logger.info("instance=" + i);
                Instance instance = theTrainingData.getInstance(i);
                Sequence input = (Sequence)instance.getData();
                Sequence trueOutput = (Sequence)instance.getTarget();
                assert (input.size() == trueOutput.size());
                Transducer.Lattice lattice = this.forwardBackward(input, null, false, (LabelAlphabet)theTrainingData.getTargetAlphabet());
                int prevLabelIndex = 0;
                int j = 0;
                while (j < trueOutput.size()) {
                    Label label = ((LabelSequence)trueOutput).getLabelAtPosition(j);
                    assert (label != null);
                    LabelVector latticeLabeling = lattice.getLabelingAtPosition(j);
                    double trueLabelProb = latticeLabeling.value(label.getIndex());
                    int labelIndex = latticeLabeling.getBestIndex();
                    if (trueLabelProb < trueLabelProbThreshold) {
                        logger.info("Adding error: instance=" + i + " position=" + j + " prtrue=" + trueLabelProb + (label == latticeLabeling.getBestLabel() ? "  " : " *") + " truelabel=" + label + " predlabel=" + latticeLabeling.getBestLabel() + " fv=" + ((FeatureVector)input.get(j)).toString(true));
                        errorInstances.add(input.get(j), label, null, null);
                        errorLabelVectors.add(latticeLabeling);
                        clusteredErrorInstances[prevLabelIndex][labelIndex].add(input.get(j), label, null, null);
                        clusteredErrorLabelVectors[prevLabelIndex][labelIndex].add(latticeLabeling);
                    }
                    prevLabelIndex = labelIndex;
                    ++j;
                }
                ++i;
            }
            logger.info("Error instance list size = " + errorInstances.size());
            if (clusteredFeatureInduction) {
                FeatureInducer[][] klfi = new FeatureInducer[numLabels][numLabels];
                int i2 = 0;
                while (i2 < numLabels) {
                    int j = 0;
                    while (j < numLabels) {
                        logger.info("Doing feature induction for " + this.outputAlphabet.lookupObject(i2) + " -> " + this.outputAlphabet.lookupObject(j) + " with " + clusteredErrorInstances[i2][j].size() + " instances");
                        if (clusteredErrorInstances[i2][j].size() < 20) {
                            logger.info("..skipping because only " + clusteredErrorInstances[i2][j].size() + " instances.");
                        } else {
                            int s = clusteredErrorLabelVectors[i2][j].size();
                            LabelVector[] lvs = new LabelVector[s];
                            int k = 0;
                            while (k < s) {
                                lvs[k] = (LabelVector)clusteredErrorLabelVectors[i2][j].get(k);
                                ++k;
                            }
                            RankedFeatureVector.Factory gainFactory = null;
                            if (gainName.equals("exp")) {
                                gainFactory = new ExpGain.Factory(lvs, this.gaussianPriorVariance);
                            } else if (gainName.equals("grad")) {
                                gainFactory = new GradientGain.Factory(lvs);
                            } else if (gainName.equals("info")) {
                                gainFactory = new InfoGain.Factory();
                            }
                            klfi[i2][j] = new FeatureInducer(gainFactory, clusteredErrorInstances[i2][j], numFeaturesPerFeatureInduction, 2 * numFeaturesPerFeatureInduction, 2 * numFeaturesPerFeatureInduction);
                            this.featureInducers.add(klfi[i2][j]);
                        }
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < numLabels) {
                    int j = 0;
                    while (j < numLabels) {
                        logger.info("Adding new induced features for " + this.outputAlphabet.lookupObject(i2) + " -> " + this.outputAlphabet.lookupObject(j));
                        if (klfi[i2][j] == null) {
                            logger.info("...skipping because no features induced.");
                        } else {
                            klfi[i2][j].induceFeaturesFor(trainingData, false, false);
                            if (testingData != null) {
                                klfi[i2][j].induceFeaturesFor(testingData, false, false);
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
                klfi = null;
            } else {
                int s = errorLabelVectors.size();
                LabelVector[] lvs = new LabelVector[s];
                int i3 = 0;
                while (i3 < s) {
                    lvs[i3] = (LabelVector)errorLabelVectors.get(i3);
                    ++i3;
                }
                RankedFeatureVector.Factory gainFactory = null;
                if (gainName.equals("exp")) {
                    gainFactory = new ExpGain.Factory(lvs, this.gaussianPriorVariance);
                } else if (gainName.equals("grad")) {
                    gainFactory = new GradientGain.Factory(lvs);
                } else if (gainName.equals("info")) {
                    gainFactory = new InfoGain.Factory();
                }
                FeatureInducer klfi = new FeatureInducer(gainFactory, errorInstances, numFeaturesPerFeatureInduction, 2 * numFeaturesPerFeatureInduction, 2 * numFeaturesPerFeatureInduction);
                this.featureInducers.add(klfi);
                klfi.induceFeaturesFor(trainingData, false, false);
                if (testingData != null) {
                    klfi.induceFeaturesFor(testingData, false, false);
                }
                logger.info("CRF4 FeatureSelection now includes " + this.globalFeatureSelection.cardinality() + " features");
                klfi = null;
            }
            ++featureInductionIteration;
        }
        return this.train(trainingData, validationData, testingData, eval, numIterations - trainingIteration);
    }

    public Sequence[] predict(InstanceList testing) {
        testing.setFeatureSelection(this.globalFeatureSelection);
        int i = 0;
        while (i < this.featureInducers.size()) {
            FeatureInducer klfi = (FeatureInducer)this.featureInducers.get(i);
            klfi.induceFeaturesFor(testing, false, false);
            ++i;
        }
        Sequence[] ret = new Sequence[testing.size()];
        int i2 = 0;
        while (i2 < testing.size()) {
            Instance instance = testing.getInstance(i2);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = this.viterbiPath(input).output();
            assert (predOutput.size() == trueOutput.size());
            ret[i2] = predOutput;
            ++i2;
        }
        return ret;
    }

    public void evaluate(TransducerEvaluator eval, InstanceList testing) {
        testing.setFeatureSelection(this.globalFeatureSelection);
        int i = 0;
        while (i < this.featureInducers.size()) {
            FeatureInducer klfi = (FeatureInducer)this.featureInducers.get(i);
            klfi.induceFeaturesFor(testing, false, false);
            ++i;
        }
        eval.evaluate(this, true, 0, true, 0.0, null, null, testing);
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    public MaximizableCRF getMaximizableCRF(InstanceList ilist) {
        return new MaximizableCRF(ilist, this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeObject(this.inputPipe);
        out.writeObject(this.outputPipe);
        out.writeObject(this.inputAlphabet);
        out.writeObject(this.outputAlphabet);
        int size = this.states.size();
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            out.writeObject(this.states.get(i));
            ++i;
        }
        size = this.initialStates.size();
        out.writeInt(size);
        i = 0;
        while (i < size) {
            out.writeObject(this.initialStates.get(i));
            ++i;
        }
        out.writeObject(this.name2state);
        if (this.weights != null) {
            size = this.weights.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.weights[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.constraints != null) {
            size = this.constraints.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.constraints[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.expectations != null) {
            size = this.expectations.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.expectations[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.defaultWeights != null) {
            size = this.defaultWeights.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeDouble(this.defaultWeights[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.defaultConstraints != null) {
            size = this.defaultConstraints.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeDouble(this.defaultConstraints[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.defaultExpectations != null) {
            size = this.defaultExpectations.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeDouble(this.defaultExpectations[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.weightsPresent != null) {
            size = this.weightsPresent.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.weightsPresent[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.featureSelections != null) {
            size = this.featureSelections.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.featureSelections[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.weightsFrozen != null) {
            size = this.weightsFrozen.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeBoolean(this.weightsFrozen[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        out.writeObject(this.globalFeatureSelection);
        out.writeObject(this.weightAlphabet);
        out.writeBoolean(this.trainable);
        out.writeBoolean(this.gatheringConstraints);
        out.writeBoolean(this.gatheringWeightsPresent);
        out.writeBoolean(this.usingHyperbolicPrior);
        out.writeDouble(this.gaussianPriorVariance);
        out.writeDouble(this.hyperbolicPriorSlope);
        out.writeDouble(this.hyperbolicPriorSharpness);
        out.writeBoolean(this.cachedValueStale);
        out.writeBoolean(this.cachedGradientStale);
        out.writeBoolean(this.someTrainingDone);
        out.writeInt(this.featureInducers.size());
        i = 0;
        while (i < this.featureInducers.size()) {
            out.writeObject(this.featureInducers.get(i));
            ++i;
        }
        out.writeBoolean(this.printGradient);
        out.writeBoolean(this.useSparseWeights);
        out.writeInt(this.transductionType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        State s;
        int version = in.readInt();
        this.inputPipe = (Pipe)in.readObject();
        this.outputPipe = (Pipe)in.readObject();
        this.inputAlphabet = (Alphabet)in.readObject();
        this.outputAlphabet = (Alphabet)in.readObject();
        int size = in.readInt();
        this.states = new ArrayList();
        int i = 0;
        while (i < size) {
            s = (State)in.readObject();
            this.states.add(s);
            ++i;
        }
        size = in.readInt();
        this.initialStates = new ArrayList();
        i = 0;
        while (i < size) {
            s = (State)in.readObject();
            this.initialStates.add(s);
            ++i;
        }
        this.name2state = (HashMap)in.readObject();
        size = in.readInt();
        if (size == -1) {
            this.weights = null;
        } else {
            this.weights = new SparseVector[size];
            i = 0;
            while (i < size) {
                this.weights[i] = (SparseVector)in.readObject();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.constraints = null;
        } else {
            this.constraints = new SparseVector[size];
            i = 0;
            while (i < size) {
                this.constraints[i] = (SparseVector)in.readObject();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.expectations = null;
        } else {
            this.expectations = new SparseVector[size];
            i = 0;
            while (i < size) {
                this.expectations[i] = (SparseVector)in.readObject();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.defaultWeights = null;
        } else {
            this.defaultWeights = new double[size];
            i = 0;
            while (i < size) {
                this.defaultWeights[i] = in.readDouble();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.defaultConstraints = null;
        } else {
            this.defaultConstraints = new double[size];
            i = 0;
            while (i < size) {
                this.defaultConstraints[i] = in.readDouble();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.defaultExpectations = null;
        } else {
            this.defaultExpectations = new double[size];
            i = 0;
            while (i < size) {
                this.defaultExpectations[i] = in.readDouble();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.weightsPresent = null;
        } else {
            this.weightsPresent = new BitSet[size];
            i = 0;
            while (i < size) {
                this.weightsPresent[i] = (BitSet)in.readObject();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.featureSelections = null;
        } else {
            this.featureSelections = new FeatureSelection[size];
            i = 0;
            while (i < size) {
                this.featureSelections[i] = (FeatureSelection)in.readObject();
                ++i;
            }
        }
        if (version >= 4) {
            size = in.readInt();
            if (size == -1) {
                this.weightsFrozen = null;
            } else {
                this.weightsFrozen = new boolean[size];
                i = 0;
                while (i < size) {
                    this.weightsFrozen[i] = in.readBoolean();
                    ++i;
                }
            }
        } else {
            this.weightsFrozen = new boolean[this.weights.length];
        }
        this.assertWeightsLength();
        this.globalFeatureSelection = (FeatureSelection)in.readObject();
        this.weightAlphabet = (Alphabet)in.readObject();
        this.trainable = in.readBoolean();
        this.gatheringConstraints = in.readBoolean();
        this.gatheringWeightsPresent = in.readBoolean();
        this.usingHyperbolicPrior = in.readBoolean();
        this.gaussianPriorVariance = in.readDouble();
        this.hyperbolicPriorSlope = in.readDouble();
        this.hyperbolicPriorSharpness = in.readDouble();
        this.cachedValueStale = in.readBoolean();
        this.cachedGradientStale = in.readBoolean();
        this.someTrainingDone = in.readBoolean();
        size = in.readInt();
        this.featureInducers = new ArrayList();
        i = 0;
        while (i < size) {
            this.featureInducers.add((FeatureInducer)in.readObject());
            ++i;
        }
        this.printGradient = in.readBoolean();
        this.useSparseWeights = version > 1 ? in.readBoolean() : false;
        this.transductionType = version >= 3 ? in.readInt() : 0;
    }

    public Transducer.ViterbiPath viterbiPath(Sequence inputSequence, boolean keepLattice) {
        return new Transducer.ViterbiPath(inputSequence, null, keepLattice);
    }

    public class MaximizableCRF
    implements Maximizable.ByGradient,
    Serializable {
        InstanceList trainingSet;
        double cachedValue = -1.23456789E8;
        DenseVector cachedGradient;
        BitSet infiniteValues = null;
        int numParameters;
        CRF4 crf;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !MaximizableCRF.class.desiredAssertionStatus();
        }

        protected MaximizableCRF(InstanceList ilist, CRF4 crf) {
            this.numParameters = 2 * CRF4.this.numStates() + CRF4.this.defaultWeights.length;
            int i = 0;
            while (i < CRF4.this.weights.length) {
                this.numParameters += CRF4.this.weights[i].numLocations();
                ++i;
            }
            this.trainingSet = ilist;
            this.crf = crf;
            this.cachedGradient = new DenseVector(this.numParameters);
            CRF4.this.setTrainable(true);
            CRF4.this.cachedGradientStale = true;
            CRF4.this.cachedValueStale = true;
            this.gatherConstraints(ilist);
        }

        protected void gatherConstraints(InstanceList ilist) {
            CRF4.this.gatheringConstraints = true;
            int i = 0;
            while (i < ilist.size()) {
                Instance instance = ilist.getInstance(i);
                FeatureVectorSequence input = (FeatureVectorSequence)instance.getData();
                FeatureSequence output = (FeatureSequence)instance.getTarget();
                this.crf.forwardBackward((Sequence)input, (Sequence)output, true);
                ++i;
            }
            CRF4.this.gatheringConstraints = false;
        }

        public void setCurIter(int curIter) {
            this.crf.setCurIter(curIter);
        }

        public Matrix getNewMatrix() {
            return new DenseVector(this.numParameters);
        }

        public int getNumParameters() {
            return this.numParameters;
        }

        public void getParameters(double[] buffer) {
            if (buffer.length != this.getNumParameters()) {
                buffer = new double[this.getNumParameters()];
            }
            DenseVector parameters = new DenseVector(buffer, true);
            int pi = 0;
            int i = 0;
            while (i < CRF4.this.numStates()) {
                State s = (State)CRF4.this.getState(i);
                parameters.setValue(pi++, -s.initialCost);
                parameters.setValue(pi++, -s.finalCost);
                ++i;
            }
            i = 0;
            while (i < CRF4.this.weights.length) {
                parameters.setValue(pi++, CRF4.this.defaultWeights[i]);
                int nl = CRF4.this.weights[i].numLocations();
                int j = 0;
                while (j < nl) {
                    parameters.setValue(pi++, CRF4.this.weights[i].valueAtLocation(j));
                    ++j;
                }
                ++i;
            }
            parameters.arrayCopyTo(0, buffer);
        }

        public double getParameter(int index) {
            int numStateParms = 2 * CRF4.this.numStates();
            if (index < numStateParms) {
                State s = (State)CRF4.this.getState(index / 2);
                if (index % 2 == 0) {
                    return -s.initialCost;
                }
                return -s.finalCost;
            }
            index -= numStateParms;
            int i = 0;
            while (i < CRF4.this.weights.length) {
                if (index == 0) {
                    return CRF4.this.defaultWeights[i];
                }
                if (--index < CRF4.this.weights[i].numLocations()) {
                    return CRF4.this.weights[i].valueAtLocation(index);
                }
                index -= CRF4.this.weights[i].numLocations();
                ++i;
            }
            throw new IllegalArgumentException("index too high = " + index);
        }

        public void setParameters(double[] buff) {
            if (!$assertionsDisabled && buff.length != this.getNumParameters()) {
                throw new AssertionError();
            }
            CRF4.this.cachedGradientStale = true;
            CRF4.this.cachedValueStale = true;
            DenseVector parameters = new DenseVector(buff, true);
            int pi = 0;
            int i = 0;
            while (i < CRF4.this.numStates()) {
                State s = (State)CRF4.this.getState(i);
                s.initialCost = -parameters.value(pi++);
                s.finalCost = -parameters.value(pi++);
                ++i;
            }
            i = 0;
            while (i < CRF4.this.weights.length) {
                CRF4.this.defaultWeights[i] = parameters.value(pi++);
                int nl = CRF4.this.weights[i].numLocations();
                int j = 0;
                while (j < nl) {
                    CRF4.this.weights[i].setValueAtLocation(j, parameters.value(pi++));
                    ++j;
                }
                ++i;
            }
            CRF4.this.someTrainingDone = true;
        }

        public void setParameter(int index, double value) {
            CRF4.this.cachedGradientStale = true;
            CRF4.this.cachedValueStale = true;
            int numStateParms = 2 * CRF4.this.numStates();
            if (index < numStateParms) {
                State s = (State)CRF4.this.getState(index / 2);
                if (index % 2 == 0) {
                    s.initialCost = -value;
                } else {
                    s.finalCost = -value;
                }
            } else {
                index -= numStateParms;
                int i = 0;
                while (i < CRF4.this.weights.length) {
                    if (index == 0) {
                        CRF4.this.defaultWeights[i] = value;
                        return;
                    }
                    if (--index < CRF4.this.weights[i].numLocations()) {
                        CRF4.this.weights[i].setValueAtLocation(index, value);
                    } else {
                        index -= CRF4.this.weights[i].numLocations();
                    }
                    ++i;
                }
                throw new IllegalArgumentException("index too high = " + index);
            }
        }

        protected double getExpectationValue() {
            boolean initializingInfiniteValues = false;
            double value = 0.0;
            if (this.infiniteValues == null) {
                this.infiniteValues = new BitSet();
                initializingInfiniteValues = true;
            }
            double[] meanStatesExpl = new double[this.trainingSet.size()];
            ++CRF4.this.tctIter;
            int ii = 0;
            while (ii < this.trainingSet.size()) {
                double cost;
                double unlabeledCost;
                FeatureSequence output;
                Instance instance = this.trainingSet.getInstance(ii);
                FeatureVectorSequence input = (FeatureVectorSequence)instance.getData();
                double labeledCost = CRF4.this.forwardBackward((Sequence)input, (Sequence)(output = (FeatureSequence)instance.getTarget()), false).getCost();
                if (Double.isInfinite(labeledCost)) {
                    logger.warning(String.valueOf(instance.getName().toString()) + " has infinite labeled cost.\n" + (instance.getSource() != null ? instance.getSource() : ""));
                }
                if (CRF4.this.UseForwardBackwardBeam) {
                    unlabeledCost = CRF4.this.forwardBackwardBeam((Sequence)input, true).getCost();
                    meanStatesExpl[ii] = MatrixOps.mean(CRF4.this.getNstatesExpl());
                } else {
                    unlabeledCost = CRF4.this.forwardBackward((Sequence)input, true).getCost();
                }
                if (Double.isInfinite(unlabeledCost)) {
                    logger.warning(String.valueOf(instance.getName().toString()) + " has infinite unlabeled cost.\n" + (instance.getSource() != null ? instance.getSource() : ""));
                }
                if (Double.isInfinite(cost = labeledCost - unlabeledCost)) {
                    logger.warning(String.valueOf(instance.getName().toString()) + " has infinite cost; skipping.");
                    if (initializingInfiniteValues) {
                        this.infiniteValues.set(ii);
                    } else if (!this.infiniteValues.get(ii)) {
                        throw new IllegalStateException("Instance i used to have non-infinite value, but now it has infinite value.");
                    }
                } else {
                    value -= cost;
                }
                ++ii;
            }
            if (CRF4.this.UseForwardBackwardBeam) {
                double cMean = MatrixOps.mean(meanStatesExpl);
                logger.info("Mean states explored=" + cMean);
            }
            return value;
        }

        public double getValue() {
            if (CRF4.this.cachedValueStale) {
                State s;
                long startingTime = System.currentTimeMillis();
                this.cachedValue = 0.0;
                CRF4.this.cachedGradientStale = true;
                int i = 0;
                while (i < CRF4.this.numStates()) {
                    s = (State)CRF4.this.getState(i);
                    s.initialExpectation = 0.0;
                    s.finalExpectation = 0.0;
                    ++i;
                }
                i = 0;
                while (i < CRF4.this.weights.length) {
                    CRF4.this.expectations[i].setAll(0.0);
                    CRF4.this.defaultExpectations[i] = 0.0;
                    ++i;
                }
                this.cachedValue = -this.getExpectationValue();
                if (CRF4.this.usingHyperbolicPrior) {
                    i = 0;
                    while (i < CRF4.this.numStates()) {
                        s = (State)CRF4.this.getState(i);
                        if (!Double.isInfinite(s.initialCost)) {
                            this.cachedValue += CRF4.this.hyperbolicPriorSlope / CRF4.this.hyperbolicPriorSharpness * Math.log(Maths.cosh(CRF4.this.hyperbolicPriorSharpness * -s.initialCost));
                        }
                        if (!Double.isInfinite(s.finalCost)) {
                            this.cachedValue += CRF4.this.hyperbolicPriorSlope / CRF4.this.hyperbolicPriorSharpness * Math.log(Maths.cosh(CRF4.this.hyperbolicPriorSharpness * -s.finalCost));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < CRF4.this.weights.length) {
                        this.cachedValue += CRF4.this.hyperbolicPriorSlope / CRF4.this.hyperbolicPriorSharpness * Math.log(Maths.cosh(CRF4.this.hyperbolicPriorSharpness * CRF4.this.defaultWeights[i]));
                        int j = 0;
                        while (j < CRF4.this.weights[i].numLocations()) {
                            double w = CRF4.this.weights[i].valueAtLocation(j);
                            if (!Double.isInfinite(w)) {
                                this.cachedValue += CRF4.this.hyperbolicPriorSlope / CRF4.this.hyperbolicPriorSharpness * Math.log(Maths.cosh(CRF4.this.hyperbolicPriorSharpness * w));
                            }
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    double priorDenom = 2.0 * CRF4.this.gaussianPriorVariance;
                    int i2 = 0;
                    while (i2 < CRF4.this.numStates()) {
                        State s2 = (State)CRF4.this.getState(i2);
                        if (!Double.isInfinite(s2.initialCost)) {
                            this.cachedValue += s2.initialCost * s2.initialCost / priorDenom;
                        }
                        if (!Double.isInfinite(s2.finalCost)) {
                            this.cachedValue += s2.finalCost * s2.finalCost / priorDenom;
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < CRF4.this.weights.length) {
                        if (!Double.isInfinite(CRF4.this.defaultWeights[i2])) {
                            this.cachedValue += CRF4.this.defaultWeights[i2] * CRF4.this.defaultWeights[i2] / priorDenom;
                        }
                        int j = 0;
                        while (j < CRF4.this.weights[i2].numLocations()) {
                            double w = CRF4.this.weights[i2].valueAtLocation(j);
                            if (!Double.isInfinite(w)) {
                                this.cachedValue += w * w / priorDenom;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                }
                this.cachedValue *= -1.0;
                CRF4.this.cachedValueStale = false;
                logger.info("getValue() (loglikelihood) = " + this.cachedValue);
                logger.fine("getValue() (loglikelihood) = " + this.cachedValue);
                long endingTime = System.currentTimeMillis();
                logger.info("Inference milliseconds = " + (endingTime - startingTime));
            }
            return this.cachedValue;
        }

        private boolean checkForNaN() {
            int i = 0;
            while (i < CRF4.this.weights.length) {
                if (!$assertionsDisabled && CRF4.this.weights[i].isNaN()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && CRF4.this.constraints != null && CRF4.this.constraints[i].isNaN()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && CRF4.this.expectations != null && CRF4.this.expectations[i].isNaN()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.isNaN(CRF4.this.defaultExpectations[i])) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.isNaN(CRF4.this.defaultConstraints[i])) {
                    throw new AssertionError();
                }
                ++i;
            }
            i = 0;
            while (i < CRF4.this.numStates()) {
                State s = (State)CRF4.this.getState(i);
                if (!$assertionsDisabled && Double.isNaN(s.initialExpectation)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.isNaN(s.initialConstraint)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.isNaN(s.initialCost)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.isNaN(s.finalExpectation)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.isNaN(s.finalConstraint)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.isNaN(s.finalCost)) {
                    throw new AssertionError();
                }
                ++i;
            }
            return true;
        }

        public void getValueGradient(double[] buffer) {
            if (CRF4.this.cachedGradientStale) {
                if (CRF4.this.cachedValueStale) {
                    this.getValue();
                }
                if (!$assertionsDisabled && !this.checkForNaN()) {
                    throw new AssertionError();
                }
                int gi = 0;
                int i = 0;
                while (i < CRF4.this.numStates()) {
                    State s = (State)CRF4.this.getState(i);
                    double initialPrior = CRF4.this.usingHyperbolicPrior ? CRF4.this.hyperbolicPriorSlope * Maths.tanh(-s.initialCost) * CRF4.this.hyperbolicPriorSharpness : -s.initialCost / CRF4.this.gaussianPriorVariance;
                    this.cachedGradient.setValue(gi++, Double.isInfinite(s.initialCost) ? 0.0 : s.initialExpectation + initialPrior - s.initialConstraint);
                    if (CRF4.this.printGradient) {
                        System.out.println("CRF gradient initial cost [" + this.crf.getState(i).getName() + "] (gidx:" + (gi - 1) + ") = " + s.initialExpectation + " (exp) - " + s.initialConstraint + " (ctr) + " + initialPrior + "(reg) = " + this.cachedGradient.value(gi - 1));
                    }
                    double finalPrior = CRF4.this.usingHyperbolicPrior ? CRF4.this.hyperbolicPriorSlope * Maths.tanh(-s.finalCost) * CRF4.this.hyperbolicPriorSharpness : -s.finalCost / CRF4.this.gaussianPriorVariance;
                    this.cachedGradient.setValue(gi++, Double.isInfinite(s.finalCost) ? 0.0 : s.finalExpectation + finalPrior - s.finalConstraint);
                    if (CRF4.this.printGradient) {
                        System.out.println("CRF gradient final cost  [" + this.crf.getState(i).getName() + "] (gidx:" + (gi - 1) + ") = " + s.finalExpectation + " (exp) - " + s.finalConstraint + " (ctr) + " + finalPrior + "(reg) = " + this.cachedGradient.value(gi - 1));
                    }
                    ++i;
                }
                if (CRF4.this.usingHyperbolicPrior) {
                    i = 0;
                    while (i < CRF4.this.weights.length) {
                        if (CRF4.this.weightsFrozen[i]) {
                            gi += CRF4.this.weights[i].numLocations() + 1;
                        } else {
                            this.cachedGradient.setValue(gi++, Double.isInfinite(CRF4.this.defaultWeights[i]) ? 0.0 : CRF4.this.defaultExpectations[i] + CRF4.this.hyperbolicPriorSlope * Maths.tanh(CRF4.this.defaultWeights[i]) * CRF4.this.hyperbolicPriorSharpness - CRF4.this.defaultConstraints[i]);
                            if (CRF4.this.printGradient) {
                                System.out.println("CRF gradient[" + this.crf.getWeightsName(i) + "][<DEFAULT_FEATURE>] (gidx:" + (gi - 1) + "=" + this.cachedGradient.value(gi - 1));
                            }
                            int j = 0;
                            while (j < CRF4.this.weights[i].numLocations()) {
                                this.cachedGradient.setValue(gi++, Double.isInfinite(CRF4.this.weights[i].valueAtLocation(j)) ? 0.0 : CRF4.this.expectations[i].valueAtLocation(j) + CRF4.this.hyperbolicPriorSlope * Maths.tanh(CRF4.this.weights[i].valueAtLocation(j)) * CRF4.this.hyperbolicPriorSharpness - CRF4.this.constraints[i].valueAtLocation(j));
                                if (CRF4.this.printGradient) {
                                    System.out.println("CRF gradient[" + this.crf.getWeightsName(i) + "][" + CRF4.this.inputAlphabet.lookupObject(j) + "]=" + this.cachedGradient.value(gi - 1));
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < CRF4.this.weights.length) {
                        if (CRF4.this.weightsFrozen[i]) {
                            gi += CRF4.this.weights[i].numLocations() + 1;
                        } else {
                            this.cachedGradient.setValue(gi++, Double.isInfinite(CRF4.this.defaultWeights[i]) ? 0.0 : CRF4.this.defaultExpectations[i] + CRF4.this.defaultWeights[i] / CRF4.this.gaussianPriorVariance - CRF4.this.defaultConstraints[i]);
                            if (CRF4.this.printGradient) {
                                System.out.println("CRF gradient[" + this.crf.getWeightsName(i) + "][<DEFAULT_FEATURE>] (gidx:" + (gi - 1) + ") = " + CRF4.this.defaultExpectations[i] + " (exp) - " + CRF4.this.defaultConstraints[i] + " (ctr) + " + CRF4.this.defaultWeights[i] / CRF4.this.gaussianPriorVariance + "(reg) = " + this.cachedGradient.value(gi - 1));
                            }
                            int j = 0;
                            while (j < CRF4.this.weights[i].numLocations()) {
                                this.cachedGradient.setValue(gi++, Double.isInfinite(CRF4.this.weights[i].valueAtLocation(j)) ? 0.0 : CRF4.this.expectations[i].valueAtLocation(j) + CRF4.this.weights[i].valueAtLocation(j) / CRF4.this.gaussianPriorVariance - CRF4.this.constraints[i].valueAtLocation(j));
                                if (CRF4.this.printGradient) {
                                    System.out.println("CRF gradient[" + this.crf.getWeightsName(i) + "][" + CRF4.this.inputAlphabet.lookupObject(CRF4.this.constraints[i].indexAtLocation(j)) + "] (gidx:" + (gi - 1) + ") =" + CRF4.this.expectations[i].valueAtLocation(j) + " (exp) - " + CRF4.this.constraints[i].valueAtLocation(j) + " (ctr) + " + CRF4.this.weights[i].valueAtLocation(j) / CRF4.this.gaussianPriorVariance + " (reg) = " + this.cachedGradient.value(gi - 1));
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                CRF4.this.cachedGradientStale = false;
                if (!$assertionsDisabled && this.cachedGradient.isNaN()) {
                    throw new AssertionError();
                }
                this.cachedGradient.timesEquals(-1.0);
            }
            if (buffer.length != this.numParameters) {
                buffer = new double[this.numParameters];
            }
            this.cachedGradient.arrayCopyTo(0, buffer);
            CRF4.this.printGradient = false;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.trainingSet);
            out.writeDouble(this.cachedValue);
            out.writeObject(this.cachedGradient);
            out.writeObject(this.infiniteValues);
            out.writeInt(this.numParameters);
            out.writeObject(this.crf);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.trainingSet = (InstanceList)in.readObject();
            this.cachedValue = in.readDouble();
            this.cachedGradient = (DenseVector)in.readObject();
            this.infiniteValues = (BitSet)in.readObject();
            this.numParameters = in.readInt();
            this.crf = (CRF4)in.readObject();
        }
    }

    public static class State
    extends Transducer.State
    implements Serializable {
        double initialConstraint;
        double initialExpectation;
        double finalConstraint;
        double finalExpectation;
        String name;
        int index;
        String[] destinationNames;
        State[] destinations;
        int[][] weightsIndices;
        String[] labels;
        CRF4 crf;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !State.class.desiredAssertionStatus();
        }

        protected State() {
        }

        protected State(String name, int index, double initialCost, double finalCost, String[] destinationNames, String[] labelNames, String[][] weightNames, CRF4 crf) {
            if (!$assertionsDisabled && destinationNames.length != labelNames.length) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && destinationNames.length != weightNames.length) {
                throw new AssertionError();
            }
            this.name = name;
            this.index = index;
            this.initialCost = initialCost;
            this.finalCost = finalCost;
            this.destinationNames = new String[destinationNames.length];
            this.destinations = new State[labelNames.length];
            this.weightsIndices = new int[labelNames.length][];
            this.labels = new String[labelNames.length];
            this.crf = crf;
            int i = 0;
            while (i < labelNames.length) {
                crf.outputAlphabet.lookupIndex(labelNames[i]);
                this.destinationNames[i] = destinationNames[i];
                this.labels[i] = labelNames[i];
                this.weightsIndices[i] = new int[weightNames[i].length];
                int j = 0;
                while (j < weightNames[i].length) {
                    this.weightsIndices[i][j] = crf.getWeightsIndex(weightNames[i][j]);
                    ++j;
                }
                ++i;
            }
            crf.cachedGradientStale = true;
            crf.cachedValueStale = true;
        }

        public void print() {
            System.out.println("State #" + this.index + " \"" + this.name + "\"");
            System.out.println("initialCost=" + this.initialCost + ", finalCost=" + this.finalCost);
            System.out.println("#destinations=" + this.destinations.length);
            int i = 0;
            while (i < this.destinations.length) {
                System.out.println("-> " + this.destinationNames[i]);
                ++i;
            }
        }

        public int numDestinations() {
            return this.destinations.length;
        }

        public String[] getWeightNames(int index) {
            int[] indices = this.weightsIndices[index];
            String[] ret = new String[indices.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = this.crf.weightAlphabet.lookupObject(indices[i]).toString();
                ++i;
            }
            return ret;
        }

        public void addWeight(int didx, String weightName) {
            int widx = this.crf.getWeightsIndex(weightName);
            this.weightsIndices[didx] = ArrayUtils.append(this.weightsIndices[didx], widx);
        }

        public String getLabelName(int index) {
            return this.labels[index];
        }

        public State getDestinationState(int index) {
            State ret = this.destinations[index];
            if (ret == null && (ret = (this.destinations[index] = (State)this.crf.name2state.get(this.destinationNames[index]))) == null) {
                throw new IllegalArgumentException("this.name=" + this.name + " index=" + index + " destinationNames[index]=" + this.destinationNames[index] + " name2state.size()=" + this.crf.name2state.size());
            }
            return ret;
        }

        public void setTrainable(boolean f) {
            if (f) {
                this.finalConstraint = 0.0;
                this.initialConstraint = 0.0;
                this.finalExpectation = 0.0;
                this.initialExpectation = 0.0;
            }
        }

        public Transducer.TransitionIterator transitionIterator(Sequence inputSequence, int inputPosition, Sequence outputSequence, int outputPosition) {
            if (inputPosition < 0 || outputPosition < 0) {
                throw new UnsupportedOperationException("Epsilon transitions not implemented.");
            }
            if (inputSequence == null) {
                throw new UnsupportedOperationException("CRFs are not generative models; must have an input sequence.");
            }
            return new TransitionIterator(this, (FeatureVectorSequence)inputSequence, inputPosition, outputSequence == null ? null : (String)outputSequence.get(outputPosition), this.crf);
        }

        public Transducer.TransitionIterator transitionIterator(FeatureVector fv, String output) {
            return new TransitionIterator(this, fv, output, this.crf);
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public void incrementInitialCount(double count) {
            if (!($assertionsDisabled || this.crf.trainable || this.crf.gatheringWeightsPresent)) {
                throw new AssertionError();
            }
            if (this.crf.gatheringConstraints) {
                this.initialConstraint += count;
            } else {
                this.initialExpectation += count;
            }
        }

        public void incrementFinalCount(double count) {
            if (!($assertionsDisabled || this.crf.trainable || this.crf.gatheringWeightsPresent)) {
                throw new AssertionError();
            }
            if (this.crf.gatheringConstraints) {
                this.finalConstraint += count;
            } else {
                this.finalExpectation += count;
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            int i;
            out.writeInt(0);
            out.writeDouble(this.initialConstraint);
            out.writeDouble(this.initialExpectation);
            out.writeDouble(this.finalConstraint);
            out.writeDouble(this.finalExpectation);
            out.writeObject(this.name);
            out.writeInt(this.index);
            int size = this.destinationNames == null ? -1 : this.destinationNames.length;
            out.writeInt(size);
            if (size != -1) {
                i = 0;
                while (i < size) {
                    out.writeObject(this.destinationNames[i]);
                    ++i;
                }
            }
            size = this.destinations == null ? -1 : this.destinations.length;
            out.writeInt(size);
            if (size != -1) {
                i = 0;
                while (i < size) {
                    out.writeObject(this.destinations[i]);
                    ++i;
                }
            }
            size = this.weightsIndices == null ? -1 : this.weightsIndices.length;
            out.writeInt(size);
            if (size != -1) {
                i = 0;
                while (i < size) {
                    out.writeInt(this.weightsIndices[i].length);
                    int j = 0;
                    while (j < this.weightsIndices[i].length) {
                        out.writeInt(this.weightsIndices[i][j]);
                        ++j;
                    }
                    ++i;
                }
            }
            size = this.labels == null ? -1 : this.labels.length;
            out.writeInt(size);
            if (size != -1) {
                i = 0;
                while (i < size) {
                    out.writeObject(this.labels[i]);
                    ++i;
                }
            }
            out.writeObject(this.crf);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int i;
            int version = in.readInt();
            this.initialConstraint = in.readDouble();
            this.initialExpectation = in.readDouble();
            this.finalConstraint = in.readDouble();
            this.finalExpectation = in.readDouble();
            this.name = (String)in.readObject();
            this.index = in.readInt();
            int size = in.readInt();
            if (size != -1) {
                this.destinationNames = new String[size];
                i = 0;
                while (i < size) {
                    this.destinationNames[i] = (String)in.readObject();
                    ++i;
                }
            } else {
                this.destinationNames = null;
            }
            size = in.readInt();
            if (size != -1) {
                this.destinations = new State[size];
                i = 0;
                while (i < size) {
                    this.destinations[i] = (State)in.readObject();
                    ++i;
                }
            } else {
                this.destinations = null;
            }
            size = in.readInt();
            if (size != -1) {
                this.weightsIndices = new int[size][];
                i = 0;
                while (i < size) {
                    int size2 = in.readInt();
                    this.weightsIndices[i] = new int[size2];
                    int j = 0;
                    while (j < size2) {
                        this.weightsIndices[i][j] = in.readInt();
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.weightsIndices = null;
            }
            size = in.readInt();
            if (size != -1) {
                this.labels = new String[size];
                i = 0;
                while (i < size) {
                    this.labels[i] = (String)in.readObject();
                    ++i;
                }
            } else {
                this.labels = null;
            }
            this.crf = (CRF4)in.readObject();
        }
    }

    protected static class TransitionIterator
    extends Transducer.TransitionIterator
    implements Serializable {
        State source;
        int index;
        int nextIndex;
        protected double[] costs;
        FeatureVector input;
        CRF4 crf;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !TransitionIterator.class.desiredAssertionStatus();
        }

        public TransitionIterator(State source, FeatureVectorSequence inputSeq, int inputPosition, String output, CRF4 crf) {
            this(source, (FeatureVector)inputSeq.get(inputPosition), output, crf);
        }

        protected TransitionIterator(State source, FeatureVector fv, String output, CRF4 crf) {
            this.source = source;
            this.crf = crf;
            this.input = fv;
            this.costs = new double[source.destinations.length];
            int transIndex = 0;
            while (transIndex < source.destinations.length) {
                if (output == null || output.equals(source.labels[transIndex])) {
                    this.costs[transIndex] = 0.0;
                    int nwi = source.weightsIndices[transIndex].length;
                    int wi = 0;
                    while (wi < nwi) {
                        int swi = source.weightsIndices[transIndex][wi];
                        int n = transIndex;
                        this.costs[n] = this.costs[n] - (crf.weights[swi].dotProduct(fv) + crf.defaultWeights[swi]);
                        ++wi;
                    }
                    if (!$assertionsDisabled && Double.isNaN(this.costs[transIndex])) {
                        throw new AssertionError();
                    }
                } else {
                    this.costs[transIndex] = Double.POSITIVE_INFINITY;
                }
                ++transIndex;
            }
            this.nextIndex = 0;
            while (this.nextIndex < source.destinations.length && this.costs[this.nextIndex] == Double.POSITIVE_INFINITY) {
                ++this.nextIndex;
            }
        }

        public boolean hasNext() {
            return this.nextIndex < this.source.destinations.length;
        }

        public Transducer.State nextState() {
            if (!$assertionsDisabled && this.nextIndex >= this.source.destinations.length) {
                throw new AssertionError();
            }
            this.index = this.nextIndex++;
            while (this.nextIndex < this.source.destinations.length && this.costs[this.nextIndex] == Double.POSITIVE_INFINITY) {
                ++this.nextIndex;
            }
            return this.source.getDestinationState(this.index);
        }

        public Object getInput() {
            return this.input;
        }

        public Object getOutput() {
            return this.source.labels[this.index];
        }

        public double getCost() {
            return this.costs[this.index];
        }

        public Transducer.State getSourceState() {
            return this.source;
        }

        public Transducer.State getDestinationState() {
            return this.source.getDestinationState(this.index);
        }

        public void incrementCount(double count) {
            if (!($assertionsDisabled || this.crf.trainable || this.crf.gatheringWeightsPresent)) {
                throw new AssertionError();
            }
            int nwi = this.source.weightsIndices[this.index].length;
            int wi = 0;
            while (wi < nwi) {
                int weightsIndex = this.source.weightsIndices[this.index][wi];
                if (this.crf.gatheringWeightsPresent) {
                    if (this.crf.gatheringConstraints || count >= 0.2) {
                        int i = 0;
                        while (i < this.input.numLocations()) {
                            int index = this.input.indexAtLocation(i);
                            if ((this.crf.globalFeatureSelection == null || this.crf.globalFeatureSelection.contains(index)) && (this.crf.featureSelections == null || this.crf.featureSelections[weightsIndex] == null || this.crf.featureSelections[weightsIndex].contains(index))) {
                                this.crf.weightsPresent[weightsIndex].set(index);
                            }
                            ++i;
                        }
                    }
                } else if (this.crf.gatheringConstraints) {
                    this.crf.constraints[weightsIndex].plusEqualsSparse(this.input, count);
                    int n = weightsIndex;
                    this.crf.defaultConstraints[n] = this.crf.defaultConstraints[n] + count;
                } else {
                    this.crf.expectations[weightsIndex].plusEqualsSparse(this.input, count);
                    int n = weightsIndex;
                    this.crf.defaultExpectations[n] = this.crf.defaultExpectations[n] + count;
                }
                ++wi;
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.source);
            out.writeInt(this.index);
            out.writeInt(this.nextIndex);
            if (this.costs != null) {
                out.writeInt(this.costs.length);
                int i = 0;
                while (i < this.costs.length) {
                    out.writeDouble(this.costs[i]);
                    ++i;
                }
            } else {
                out.writeInt(-1);
            }
            out.writeObject(this.input);
            out.writeObject(this.crf);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.source = (State)in.readObject();
            this.index = in.readInt();
            this.nextIndex = in.readInt();
            int size = in.readInt();
            if (size == -1) {
                this.costs = null;
            } else {
                this.costs = new double[size];
                int i = 0;
                while (i < size) {
                    this.costs[i] = in.readDouble();
                    ++i;
                }
            }
            this.input = (FeatureVector)in.readObject();
            this.crf = (CRF4)in.readObject();
        }

        public String describeTransition(double cutoff) {
            DecimalFormat f = new DecimalFormat("0.###");
            StringBuffer buf = new StringBuffer();
            buf.append("Value: " + f.format(-this.getCost()) + " <br />\n");
            try {
                int[] theseWeights = this.source.weightsIndices[this.index];
                int i = 0;
                while (i < theseWeights.length) {
                    int wi = theseWeights[i];
                    SparseVector w = this.crf.weights[wi];
                    buf.append("WEIGHTS <br />\n" + this.crf.weightAlphabet.lookupObject(wi) + "<br />\n");
                    buf.append("  d.p. = " + f.format(w.dotProduct(this.input)) + "<br />\n");
                    double[] vals = new double[this.input.numLocations()];
                    double[] absVals = new double[this.input.numLocations()];
                    int k = 0;
                    while (k < vals.length) {
                        int index = this.input.indexAtLocation(k);
                        vals[k] = w.value(index) * this.input.value(index);
                        absVals[k] = Math.abs(vals[k]);
                        ++k;
                    }
                    buf.append("DEFAULT " + f.format(this.crf.defaultWeights[wi]) + "<br />\n");
                    RankedFeatureVector rfv = new RankedFeatureVector(this.crf.inputAlphabet, this.input.getIndices(), absVals);
                    int rank = 0;
                    while (rank < absVals.length) {
                        int fidx = rfv.getIndexAtRank(rank);
                        Object fname = this.crf.inputAlphabet.lookupObject(this.input.indexAtLocation(fidx));
                        if (absVals[fidx] < cutoff) break;
                        if (vals[fidx] != 0.0) {
                            buf.append(fname + " " + f.format(vals[fidx]) + "<br />\n");
                        }
                        ++rank;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println("Error writing transition descriptions.");
                e.printStackTrace();
                buf.append("ERROR WHILE WRITING OUTPUT...\n");
            }
            return buf.toString();
        }
    }
}

