/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.maximize;

import edu.umass.cs.mallet.base.maximize.LineMaximizer;
import edu.umass.cs.mallet.base.maximize.Maximizable;
import edu.umass.cs.mallet.base.types.MatrixOps;
import java.util.logging.Logger;

public class BackTrackLineSearch
implements LineMaximizer.ByGradient {
    private static Logger logger = Logger.getLogger(BackTrackLineSearch.class.getName());
    final int maxIterations = 100;
    final double stpmax = 100.0;
    final double EPS = 3.0E-12;
    final double TOLX = 1.2E-11;
    final double ALF = 1.0E-4;

    public double maximize(Maximizable.ByGradient function, double[] line, double initialStep) {
        double fold;
        double[] g = new double[function.getNumParameters()];
        double[] x = new double[function.getNumParameters()];
        double[] oldParameters = new double[function.getNumParameters()];
        function.getParameters(x);
        System.arraycopy(x, 0, oldParameters, 0, x.length);
        function.getValueGradient(g);
        double tmplam = 0.0;
        double alam2 = 0.0;
        double f2 = fold = function.getValue();
        logger.fine("ENTERING BACKTRACK\n");
        logger.fine("Entering BackTrackLnSrch, value=" + fold + ",\ndirection.oneNorm:" + MatrixOps.oneNorm(line));
        assert (!MatrixOps.isNaN(g));
        double sum = MatrixOps.twoNorm(line);
        if (sum > 100.0) {
            logger.warning("attempted step too big. scaling: sum=" + sum + ", stpmax=" + 100.0);
            MatrixOps.timesEquals(line, 100.0 / sum);
        }
        double slope = MatrixOps.dotProduct(g, line);
        logger.fine("slope=" + slope);
        if (slope < 0.0) {
            throw new IllegalStateException("Slope = " + slope + " is negative");
        }
        double test = 0.0;
        int i = 0;
        while (i < oldParameters.length) {
            double temp = Math.abs(line[i]) / Math.max(Math.abs(oldParameters[i]), 1.0);
            if (temp > test) {
                test = temp;
            }
            ++i;
        }
        double alamin = 1.2E-11 / test;
        double alam = 1.0;
        double oldAlam = 0.0;
        int iteration = 0;
        iteration = 0;
        while (iteration < 100) {
            logger.fine("BackTrack loop iteration " + iteration + ": alam=" + alam + " oldAlam=" + oldAlam);
            logger.fine("before step, x.1norm: " + MatrixOps.oneNorm(x) + "\nalam: " + alam + "\noldAlam: " + oldAlam);
            assert (alam != oldAlam) : "alam == oldAlam";
            MatrixOps.plusEquals(x, line, alam - oldAlam);
            logger.fine("after step, x.1norm: " + MatrixOps.oneNorm(x));
            function.setParameters(x);
            oldAlam = alam;
            double f = function.getValue();
            logger.fine("value=" + f);
            if (alam < alamin) {
                function.setParameters(oldParameters);
                f = function.getValue();
                logger.warning("EXITING BACKTRACK: Jump too small. Exiting and using xold. Value=" + f);
                return 0.0;
            }
            if (f >= fold + 1.0E-4 * alam * slope) {
                logger.fine("EXITING BACKTRACK: value=" + f);
                if (f < fold) {
                    throw new IllegalStateException("Function did not increase: f=" + f + " < " + fold + "=fold");
                }
                return alam;
            }
            if (Double.isInfinite(f) || Double.isInfinite(f2)) {
                logger.warning("Value is infinite after jump " + oldAlam + ". f=" + f + ", f2=" + f2 + ". Scaling back step size...");
                tmplam = 0.2 * alam;
                if (alam < alamin) {
                    function.setParameters(oldParameters);
                    f = function.getValue();
                    logger.warning("EXITING BACKTRACK: Jump too small. Exiting and using xold. Value=" + f);
                    return 0.0;
                }
            } else if (alam == 1.0) {
                tmplam = -slope / (2.0 * (f - fold - slope));
            } else {
                double disc;
                double rhs1 = f - fold - alam * slope;
                double rhs2 = f2 - fold - alam2 * slope;
                assert (alam - alam2 != 0.0) : "FAILURE: dividing by alam-alam2. alam=" + alam;
                double a = (rhs1 / (alam * alam) - rhs2 / (alam2 * alam2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                tmplam = a == 0.0 ? -slope / (2.0 * b) : ((disc = b * b - 3.0 * a * slope) < 0.0 ? 0.5 * alam : (b <= 0.0 ? (-b + Math.sqrt(disc)) / (3.0 * a) : -slope / (b + Math.sqrt(disc))));
                if (tmplam > 0.5 * alam) {
                    tmplam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f;
            logger.fine("tmplam:" + tmplam);
            alam = Math.max(tmplam, 0.1 * alam);
            ++iteration;
        }
        if (iteration >= 100) {
            throw new IllegalStateException("Too many iterations.");
        }
        return 0.0;
    }
}

