/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.pipe.tsf;

import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.Token;
import edu.umass.cs.mallet.base.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TokenTextCharNGrams
extends Pipe
implements Serializable {
    static char startBorderChar = (char)62;
    static char endBorderChar = (char)60;
    String prefix;
    int[] gramSizes;
    boolean distinguishBorders = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public TokenTextCharNGrams(String prefix, int[] gramSizes, boolean distinguishBorders) {
        this.prefix = prefix;
        this.gramSizes = gramSizes;
        this.distinguishBorders = distinguishBorders;
    }

    public TokenTextCharNGrams(String prefix, int[] gramSizes) {
        this.prefix = prefix;
        this.gramSizes = gramSizes;
    }

    public TokenTextCharNGrams() {
        this("CHARBIGRAM=", new int[]{2});
    }

    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            Token t = ts.getToken(i);
            String s = t.getText();
            if (this.distinguishBorders) {
                s = String.valueOf(startBorderChar) + s + endBorderChar;
            }
            int slen = s.length();
            int j = 0;
            while (j < this.gramSizes.length) {
                int size = this.gramSizes[j];
                int k = 0;
                while (k < slen - size + 1) {
                    t.setFeatureValue((String.valueOf(this.prefix) + s.substring(k, k + size)).intern(), 1.0);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.prefix);
        out.writeInt(this.gramSizes.length);
        int i = 0;
        while (i < this.gramSizes.length) {
            out.writeInt(this.gramSizes[i]);
            ++i;
        }
        out.writeBoolean(this.distinguishBorders);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.prefix = (String)in.readObject();
        int gsl = in.readInt();
        if (gsl > 0) {
            this.gramSizes = new int[gsl];
            int i = 0;
            while (i < gsl) {
                this.gramSizes[i] = in.readInt();
                ++i;
            }
        }
        if (version >= 1) {
            this.distinguishBorders = in.readBoolean();
        }
    }
}

