/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Alphabet
implements Serializable {
    TObjectIntHashMap map;
    ArrayList entries;
    boolean growthStopped = false;
    Class entryClass = null;
    VMID instanceId = new VMID();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    private static transient HashMap deserializedEntries = new HashMap();

    public Alphabet(int capacity, Class entryClass) {
        this.map = new TObjectIntHashMap(capacity);
        this.entries = new ArrayList(capacity);
        this.entryClass = entryClass;
    }

    public Alphabet(Class entryClass) {
        this(8, entryClass);
    }

    public Alphabet(int capacity) {
        this(capacity, null);
    }

    public Alphabet() {
        this(8, null);
    }

    public Object clone() {
        Alphabet ret = new Alphabet();
        ret.map = (TObjectIntHashMap)this.map.clone();
        ret.entries = (ArrayList)this.entries.clone();
        ret.growthStopped = this.growthStopped;
        ret.entryClass = this.entryClass;
        return ret;
    }

    public int lookupIndex(Object entry, boolean addIfNotPresent) {
        if (entry == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        if (this.entryClass == null) {
            this.entryClass = entry.getClass();
        } else if (entry.getClass() != this.entryClass) {
            throw new IllegalArgumentException("Non-matching entry class, " + entry.getClass() + ", was " + this.entryClass);
        }
        int retIndex = -1;
        if (this.map.containsKey(entry)) {
            retIndex = this.map.get(entry);
        } else if (!this.growthStopped && addIfNotPresent) {
            retIndex = this.entries.size();
            this.map.put(entry, retIndex);
            this.entries.add(entry);
        }
        return retIndex;
    }

    public int lookupIndex(Object entry) {
        return this.lookupIndex(entry, true);
    }

    public Object lookupObject(int index) {
        return this.entries.get(index);
    }

    public Object[] toArray() {
        return this.entries.toArray();
    }

    public Object[] toArray(Object[] in) {
        return this.entries.toArray(in);
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public Object[] lookupObjects(int[] indices) {
        Object[] ret = new Object[indices.length];
        int i = 0;
        while (i < indices.length) {
            ret[i] = this.entries.get(indices[i]);
            ++i;
        }
        return ret;
    }

    public Object[] lookupObjects(int[] indices, Object[] buf) {
        int i = 0;
        while (i < indices.length) {
            buf[i] = this.entries.get(indices[i]);
            ++i;
        }
        return buf;
    }

    public int[] lookupIndices(Object[] objects, boolean addIfNotPresent) {
        int[] ret = new int[objects.length];
        int i = 0;
        while (i < objects.length) {
            ret[i] = this.lookupIndex(objects[i], addIfNotPresent);
            ++i;
        }
        return ret;
    }

    public boolean contains(Object entry) {
        return this.map.contains(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public void stopGrowth() {
        this.growthStopped = true;
    }

    public void startGrowth() {
        this.growthStopped = false;
    }

    public boolean growthStopped() {
        return this.growthStopped;
    }

    public Class entryClass() {
        return this.entryClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.entries.size()) {
            sb.append(this.entries.get(i).toString());
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        this.dump(new PrintWriter((Writer)new OutputStreamWriter(out), true));
    }

    public void dump(PrintWriter out) {
        int i = 0;
        while (i < this.entries.size()) {
            out.println(String.valueOf(i) + " => " + this.entries.get(i));
            ++i;
        }
    }

    public VMID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(VMID id) {
        this.instanceId = id;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.entries.size());
        int i = 0;
        while (i < this.entries.size()) {
            out.writeObject(this.entries.get(i));
            ++i;
        }
        out.writeBoolean(this.growthStopped);
        out.writeObject(this.entryClass);
        out.writeObject(this.instanceId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int size = in.readInt();
        this.entries = new ArrayList(size);
        this.map = new TObjectIntHashMap(size);
        int i = 0;
        while (i < size) {
            Object o = in.readObject();
            this.map.put(o, i);
            this.entries.add(o);
            ++i;
        }
        this.growthStopped = in.readBoolean();
        this.entryClass = (Class)in.readObject();
        if (version > 0) {
            this.instanceId = (VMID)in.readObject();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        Object previous = deserializedEntries.get(this.instanceId);
        if (previous != null) {
            return previous;
        }
        if (this.instanceId != null) {
            deserializedEntries.put(this.instanceId, this);
        }
        return this;
    }
}

