/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.AugmentableFeatureVector;
import edu.umass.cs.mallet.base.types.FeatureSelection;
import edu.umass.cs.mallet.base.types.FeatureVector;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FeatureConjunction
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(FeatureConjunction.class.getName());
    private static final String conjunctionString = "_&_";
    private static final String negationString = "!";
    private static final Pattern conjunctionPattern = Pattern.compile("_&_");
    String name;
    Alphabet dictionary;
    int[] features;
    boolean[] negations;
    int index = -1;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public FeatureConjunction(String name, Alphabet dictionary, int[] features, boolean[] negations, boolean checkSorted, boolean copyFeatures, boolean copyNegations) {
        assert (negations == null || features.length == negations.length);
        this.dictionary = dictionary;
        if (copyFeatures) {
            this.features = new int[features.length];
            System.arraycopy(features, 0, this.features, 0, features.length);
        } else {
            this.features = features;
        }
        if (copyNegations && negations != null) {
            this.negations = new boolean[negations.length];
            System.arraycopy(negations, 0, this.negations, 0, negations.length);
        } else {
            this.negations = negations;
        }
        if (checkSorted) {
            int i = this.features.length - 1;
            while (i >= 0) {
                boolean swapped = false;
                int j = 0;
                while (j < i) {
                    if (features[i - 1] > features[i]) {
                        int tmpf = this.features[i];
                        this.features[i] = this.features[i - 1];
                        this.features[i - 1] = tmpf;
                        if (negations != null) {
                            boolean tmpb = this.negations[i];
                            this.negations[i] = this.negations[i - 1];
                            this.negations[i - 1] = tmpb;
                        }
                        swapped = true;
                    } else if (features[i - 1] == features[i]) {
                        throw new IllegalArgumentException("Same Feature cannot occur twice.");
                    }
                    ++j;
                }
                if (!swapped) break;
                --i;
            }
        }
        if (name != null) {
            this.name = name;
        } else {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.features.length) {
                if (negations != null && !this.negations[i]) {
                    sb.append(negationString);
                }
                if (i > 0) {
                    sb.append(conjunctionString);
                }
                sb.append(dictionary.lookupObject(features[i]).toString());
                ++i;
            }
        }
    }

    public FeatureConjunction(String name, Alphabet dictionary, int[] features, boolean[] negations, boolean checkSorted) {
        this(name, dictionary, features, negations, checkSorted, true, true);
    }

    public FeatureConjunction(String name, Alphabet dictionary, int[] features, boolean[] negations) {
        this(name, dictionary, features, negations, true);
    }

    public static boolean isValidConjunction(int[] features) {
        int i = 1;
        while (i < features.length) {
            if (features[i - 1] >= features[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getName(Alphabet dictionary, int[] features, boolean[] negations) {
        if (negations != null) {
            int i = 0;
            while (i < negations.length) {
                if (negations[i]) {
                    throw new UnsupportedOperationException("Doesn't yet check for sub-duplicates with negations.");
                }
                ++i;
            }
        }
        return FeatureConjunction.getName(dictionary, features);
    }

    public static String getName(Alphabet dictionary, int[] features) {
        int i = 0;
        while (i < features.length) {
            int[] featureIndices = FeatureConjunction.getFeatureIndices(dictionary, (String)dictionary.lookupObject(features[i]));
            if (featureIndices.length > 1) {
                int newLength = features.length - 1 + featureIndices.length;
                int[] newFeatures = new int[newLength];
                int n = 0;
                int j = 0;
                while (j < i) {
                    newFeatures[n++] = features[j];
                    ++j;
                }
                j = 0;
                while (j < featureIndices.length) {
                    newFeatures[n++] = featureIndices[j];
                    ++j;
                }
                j = i + 1;
                while (j < features.length) {
                    newFeatures[n++] = features[j];
                    ++j;
                }
                Arrays.sort(newFeatures);
                return FeatureConjunction.getName(dictionary, newFeatures);
            }
            ++i;
        }
        i = 1;
        while (i < features.length) {
            if (features[i - 1] == features[i]) {
                int[] newFeatures = new int[features.length - 1];
                int n = 0;
                int j = 0;
                while (j < i) {
                    newFeatures[n++] = features[j];
                    ++j;
                }
                j = i + 1;
                while (j < features.length) {
                    newFeatures[n++] = features[j];
                    ++j;
                }
                return FeatureConjunction.getName(dictionary, newFeatures);
            }
            if (features[i - 1] > features[i]) {
                throw new IllegalArgumentException("feature indices not sorted");
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < features.length) {
            if (i2 > 0) {
                sb.append(conjunctionString);
            }
            sb.append(dictionary.lookupObject(features[i2]).toString());
            ++i2;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean featuresOverlap(Alphabet dictionary, int feature1, int feature2) {
        if (feature1 == feature2) {
            return true;
        }
        fis1 = FeatureConjunction.getFeatureIndices(dictionary, (String)dictionary.lookupObject(feature1));
        fis2 = FeatureConjunction.getFeatureIndices(dictionary, (String)dictionary.lookupObject(feature2));
        i = 0;
        j = 0;
        while (i < fis1.length) {
            if (!FeatureConjunction.$assertionsDisabled && i < fis1.length - 2 && fis1[i] >= fis1[i + 1]) {
                throw new AssertionError();
            }
            if (FeatureConjunction.$assertionsDisabled || j >= fis2.length - 2 || fis2[j] < fis2[j + 1]) ** GOTO lbl13
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                ++j;
lbl13:
                // 2 sources

                ** while (fis2[j] < fis1[i] && j < fis2.length - 1)
            }
lbl14:
            // 1 sources

            if (fis1[i] == fis2[j]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getName(Alphabet dictionary, int feature1, int feature2) {
        if (feature1 < feature2) {
            return FeatureConjunction.getName(dictionary, new int[]{feature1, feature2});
        }
        return FeatureConjunction.getName(dictionary, new int[]{feature2, feature1});
    }

    public static int[] getFeatureIndices(Alphabet dictionary, String featureConjunctionName) {
        String[] featureNames = conjunctionPattern.split(featureConjunctionName);
        int[] ret = new int[featureNames.length];
        int i = 0;
        while (i < featureNames.length) {
            assert (!featureNames[i].startsWith(negationString));
            ret[i] = dictionary.lookupIndex(featureNames[i], false);
            logger.fine(String.valueOf(i) + "th feature: " + featureNames[i] + " in " + featureConjunctionName);
            assert (ret[i] != -1) : "Couldn't find index for " + i + "th feature: " + featureNames[i] + " in " + featureConjunctionName;
            ++i;
        }
        Arrays.sort(ret);
        return ret;
    }

    public FeatureConjunction(Alphabet dictionary, int[] features, boolean[] negations) {
        this(FeatureConjunction.getName(dictionary, features, negations), dictionary, features, negations, true);
    }

    private static boolean[] trueArray(int length) {
        boolean[] ret = new boolean[length];
        int i = 0;
        while (i < length) {
            ret[i] = true;
            ++i;
        }
        return ret;
    }

    public FeatureConjunction(Alphabet dictionary, int[] features) {
        this(FeatureConjunction.getName(dictionary, features, null), dictionary, features, null, true, true, false);
    }

    public boolean satisfiedBy(FeatureVector fv) {
        if (fv.getAlphabet() != this.dictionary) {
            throw new IllegalArgumentException("Vocabularies do not match.");
        }
        int fvsize = fv.numLocations();
        int fvl = 0;
        int fcl = 0;
        while (fcl < this.features.length) {
            int fcli = this.features[fcl];
            while (fvl < fvsize && fv.indexAtLocation(fvl) < fcli) {
                ++fvl;
            }
            if (fvl < fvsize && fv.indexAtLocation(fvl) == fcli && fv.valueAtLocation(fvl) != 0.0 ? this.negations != null && !this.negations[fcl] : this.negations == null || this.negations[fcl]) {
                return false;
            }
            ++fcl;
        }
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public void addTo(AugmentableFeatureVector fv, double value, FeatureSelection fs) {
        if (this.satisfiedBy(fv)) {
            this.index = fv.getAlphabet().lookupIndex(this.name);
            if (fs != null) {
                fs.add(this.index);
            }
            if (this.index >= 0 && fv.value(this.index) > 0.0) {
                return;
            }
            assert (this.index != -1);
            fv.add(this.index, value);
        }
    }

    public void addTo(AugmentableFeatureVector fv, double value) {
        this.addTo(fv, value, null);
    }

    public void addTo(AugmentableFeatureVector fv) {
        this.addTo(fv, 1.0);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        out.writeInt(0);
        out.writeObject(this.name);
        out.writeObject(this.dictionary);
        if (this.features == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.features.length);
            i = 0;
            while (i < this.features.length) {
                out.writeInt(this.features[i]);
                ++i;
            }
        }
        if (this.negations == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.negations.length);
            i = 0;
            while (i < this.negations.length) {
                out.writeBoolean(this.negations[i]);
                ++i;
            }
        }
        out.writeInt(this.index);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        int version = in.readInt();
        this.name = (String)in.readObject();
        this.dictionary = (Alphabet)in.readObject();
        int size = in.readInt();
        if (size == -1) {
            this.features = null;
        } else {
            this.features = new int[size];
            i = 0;
            while (i < size) {
                this.features[i] = in.readInt();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.negations = null;
        } else {
            this.negations = new boolean[size];
            i = 0;
            while (i < size) {
                this.negations[i] = in.readBoolean();
                ++i;
            }
        }
        this.index = in.readInt();
    }

    public static class List
    implements Serializable {
        ArrayList conjunctions = new ArrayList();
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;

        public int size() {
            return this.conjunctions.size();
        }

        public FeatureConjunction get(int i) {
            return (FeatureConjunction)this.conjunctions.get(i);
        }

        public void add(FeatureConjunction fc) {
            if (this.conjunctions.size() > 0 && fc.dictionary != ((FeatureConjunction)this.conjunctions.get((int)0)).dictionary) {
                throw new IllegalArgumentException("Alphabet does not match.");
            }
            this.conjunctions.add(fc);
        }

        public void addTo(AugmentableFeatureVector fv, double value, FeatureSelection fs) {
            int i = 0;
            while (i < this.conjunctions.size()) {
                ((FeatureConjunction)this.conjunctions.get(i)).addTo(fv, value, fs);
                ++i;
            }
        }

        public void addTo(AugmentableFeatureVector fv, double value) {
            this.addTo(fv, value, null);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            if (this.conjunctions == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.conjunctions.size());
                int i = 0;
                while (i < this.conjunctions.size()) {
                    out.writeObject(this.conjunctions.get(i));
                    ++i;
                }
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            int size = in.readInt();
            if (size == -1) {
                this.conjunctions = null;
            } else {
                this.conjunctions = new ArrayList();
                int i = 0;
                while (i < size) {
                    this.conjunctions.add((FeatureConjunction)in.readObject());
                    ++i;
                }
            }
        }
    }
}

