/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import opennlp.maxent.BasicContextGenerator;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.DataStream;
import opennlp.model.AbstractEventStream;
import opennlp.model.Event;

public class BasicEventStream
extends AbstractEventStream {
    ContextGenerator cg;
    DataStream ds;
    Event next;
    private String separator = " ";

    public BasicEventStream(DataStream ds, String sep) {
        this.separator = sep;
        this.cg = new BasicContextGenerator(this.separator);
        this.ds = ds;
        if (this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
    }

    public BasicEventStream(DataStream ds) {
        this(ds, " ");
    }

    public Event next() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        Event current = this.next;
        this.next = this.ds.hasNext() ? this.createEvent((String)this.ds.nextToken()) : null;
        return current;
    }

    public boolean hasNext() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        return this.next != null;
    }

    private Event createEvent(String obs) {
        int lastSpace = obs.lastIndexOf(this.separator);
        if (lastSpace == -1) {
            return null;
        }
        return new Event(obs.substring(lastSpace + 1), this.cg.getContext(obs.substring(0, lastSpace)));
    }
}

