/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.File;
import java.io.IOException;
import opennlp.maxent.io.GISModelReader;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelReader;
import opennlp.model.DataReader;
import opennlp.model.GenericModelWriter;
import opennlp.perceptron.PerceptronModelReader;

public class GenericModelReader
extends AbstractModelReader {
    private AbstractModelReader delegateModelReader;

    public GenericModelReader(File f) throws IOException {
        super(f);
    }

    public GenericModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (modelType.equals("Perceptron")) {
            this.delegateModelReader = new PerceptronModelReader(this.dataReader);
        } else if (modelType.equals("GIS")) {
            this.delegateModelReader = new GISModelReader(this.dataReader);
        } else {
            throw new IOException("Unknown model format: " + modelType);
        }
    }

    public AbstractModel constructModel() throws IOException {
        return this.delegateModelReader.constructModel();
    }

    public static void main(String[] args) throws IOException {
        AbstractModel m = new GenericModelReader(new File(args[0])).getModel();
        new GenericModelWriter(m, new File(args[1])).persist();
    }
}

